/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.annotation.Nullable;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.StaticResourceCacheConfig;
import org.spincast.core.routing.StaticResourceCorsConfig;
import org.spincast.core.routing.StaticResourceType;

public class StaticResourceDefault<R extends RequestContext<?>>
implements StaticResource<R> {
    private final boolean isSpicastOrPluginAddedResource;
    private final StaticResourceType staticResourceType;
    private final String urlPath;
    private final String resourcePath;
    private final Handler<R> generator;
    private final StaticResourceCorsConfig corsConfig;
    private final StaticResourceCacheConfig cacheConfig;
    private final boolean ignoreQueryString;

    @AssistedInject
    public StaticResourceDefault(@Assisted(value="isSpicastOrPluginAddedResource") boolean isSpicastOrPluginAddedResource, @Assisted StaticResourceType staticResourceType, @Assisted(value="url") String urlPath, @Assisted(value="path") String resourcePath, @Assisted @Nullable Handler<R> generator, @Assisted @Nullable StaticResourceCorsConfig corsConfig, @Assisted @Nullable StaticResourceCacheConfig cacheConfig, @Assisted(value="ignoreQueryString") boolean ignoreQueryString) {
        this.isSpicastOrPluginAddedResource = isSpicastOrPluginAddedResource;
        this.staticResourceType = staticResourceType;
        this.urlPath = urlPath;
        this.resourcePath = resourcePath;
        this.generator = generator;
        this.corsConfig = corsConfig;
        this.cacheConfig = cacheConfig;
        this.ignoreQueryString = ignoreQueryString;
    }

    public boolean isSpicastOrPluginAddedResource() {
        return this.isSpicastOrPluginAddedResource;
    }

    public StaticResourceType getStaticResourceType() {
        return this.staticResourceType;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isCanBeGenerated() {
        return this.getGenerator() != null;
    }

    public Handler<R> getGenerator() {
        return this.generator;
    }

    public StaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    public StaticResourceCacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public boolean isFileResource() {
        return this.getStaticResourceType() == StaticResourceType.FILE || this.getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH;
    }

    public boolean isDirResource() {
        return !this.isFileResource();
    }

    public boolean isClasspath() {
        return this.getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH || this.getStaticResourceType() == StaticResourceType.DIRECTORY_FROM_CLASSPATH;
    }

    public boolean isFileSytem() {
        return !this.isClasspath();
    }

    public boolean isIgnoreQueryString() {
        return this.ignoreQueryString;
    }

    public String toString() {
        return this.getResourcePath();
    }
}

