/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.DefaultRequestContext;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.routing.ETagFactory;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.RedirectRuleBuilder;
import org.spincast.core.routing.RedirectRuleBuilderFactory;
import org.spincast.core.routing.Route;
import org.spincast.core.routing.RouteBuilder;
import org.spincast.core.routing.RouteBuilderFactory;
import org.spincast.core.routing.RouteHandlerMatch;
import org.spincast.core.routing.Router;
import org.spincast.core.routing.RoutingRequestContextAddon;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.StaticResourceBuilder;
import org.spincast.core.routing.StaticResourceBuilderFactory;
import org.spincast.core.routing.StaticResourceCacheConfig;
import org.spincast.core.routing.StaticResourceCorsConfig;
import org.spincast.core.routing.StaticResourceFactory;
import org.spincast.core.routing.hotlinking.HotlinkingManager;
import org.spincast.core.routing.hotlinking.HotlinkingManagerDefault;
import org.spincast.core.websocket.DefaultWebsocketContext;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketRoute;
import org.spincast.core.websocket.WebsocketRouteBuilder;
import org.spincast.core.websocket.WebsocketRouteBuilderFactory;
import org.spincast.core.websocket.WebsocketRouteHandler;
import org.spincast.core.websocket.WebsocketRouteHandlerFactory;
import org.spincast.plugins.routing.DefaultRouter;
import org.spincast.plugins.routing.DefaultRouterDefault;
import org.spincast.plugins.routing.ETagFactoryDefault;
import org.spincast.plugins.routing.RedirectRuleBuilderDefault;
import org.spincast.plugins.routing.RouteBuilderDefault;
import org.spincast.plugins.routing.RouteDefault;
import org.spincast.plugins.routing.RouteFactory;
import org.spincast.plugins.routing.RouteHandlerMatchDefault;
import org.spincast.plugins.routing.RouteHandlerMatchFactory;
import org.spincast.plugins.routing.SpincastRouter;
import org.spincast.plugins.routing.SpincastRouterConfig;
import org.spincast.plugins.routing.SpincastRoutingRequestContextAddon;
import org.spincast.plugins.routing.SpincastWebsocketRoute;
import org.spincast.plugins.routing.StaticResourceBuilderDefault;
import org.spincast.plugins.routing.StaticResourceCacheConfigDefault;
import org.spincast.plugins.routing.StaticResourceCacheConfigFactory;
import org.spincast.plugins.routing.StaticResourceCorsConfigDefault;
import org.spincast.plugins.routing.StaticResourceCorsConfigFactory;
import org.spincast.plugins.routing.StaticResourceDefault;
import org.spincast.plugins.routing.WebsocketRouteBuilderDefault;
import org.spincast.plugins.routing.WebsocketRouteFactory;
import org.spincast.plugins.routing.utils.SpincastRoutingUtils;
import org.spincast.plugins.routing.utils.SpincastRoutingUtilsDefault;

public class SpincastRoutingPluginModule
extends SpincastGuiceModuleBase {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastRoutingPluginModule.class);
    private Class<? extends Router<?, ?>> specificRouterImplementationClass;

    public SpincastRoutingPluginModule() {
        this(null, null, null);
    }

    public SpincastRoutingPluginModule(Class<? extends Router<?, ?>> specificRouterImplementationClass) {
        this(null, null, specificRouterImplementationClass);
    }

    public SpincastRoutingPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        this(requestContextImplementationClass, websocketContextImplementationClass, null);
    }

    public SpincastRoutingPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass, Class<? extends Router<?, ?>> specificRouterImplementationClass) {
        super(requestContextImplementationClass, websocketContextImplementationClass);
        this.specificRouterImplementationClass = specificRouterImplementationClass;
    }

    protected Class<? extends Router<?, ?>> getSpecificRouterImplementationClass() {
        return this.specificRouterImplementationClass;
    }

    protected void configure() {
        this.validateRequirements();
        this.bindRouter();
        this.bindRouteFactory();
        this.bindRouteBuilderFactory();
        this.bindRedirectRuleBuilderFactory();
        this.bindRouteHandlerMatchFactory();
        this.bindStaticResourceFactory();
        this.bindStaticResourceBuilderFactory();
        this.bindStaticResourceCorsConfigFactory();
        this.bindStaticResourceCacheConfigFactory();
        this.bindStaticResourceHotlinkingManager();
        this.bindRequestContextAddon();
        this.bindWebsocketRouteFactory();
        this.bindWebsocketRouteBuilderFactory();
        this.bindWebsocketRouteHandlerFactory();
        this.bindETagFactory();
        this.bindSpincastRoutingUtils();
    }

    protected void validateRequirements() {
        this.requireBinding(SpincastRouterConfig.class);
    }

    protected Key<?> getRouterImplementationKey() {
        if (this.getSpecificRouterImplementationClass() != null) {
            return Key.get(this.getSpecificRouterImplementationClass());
        }
        if (this.getRequestContextInterface().equals(DefaultRequestContext.class) && this.getWebsocketContextInterface().equals(DefaultWebsocketContext.class)) {
            return Key.get(DefaultRouterDefault.class);
        }
        return this.parameterizeWithContextInterfaces(SpincastRouter.class);
    }

    protected Key<?> getRouteKey() {
        return this.parameterizeWithContextInterfaces(RouteDefault.class);
    }

    protected Key<?> getWebsocketRouteKey() {
        return this.parameterizeWithContextInterfaces(SpincastWebsocketRoute.class);
    }

    protected Key<?> getStaticResourceKey() {
        return this.parameterizeWithContextInterfaces(StaticResourceDefault.class);
    }

    protected void bindRouter() {
        Key<?> key = this.getRouterImplementationKey();
        try {
            key.getTypeLiteral().getSupertype(Router.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The router Key must implement " + Router.class.getName() + " : " + key);
        }
        this.bind(key).in(Scopes.SINGLETON);
        this.bind(this.parameterizeWithContextInterfaces(Router.class)).to(key).in(Scopes.SINGLETON);
        this.bind(Router.class).to(key).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<Router<?, ?>>(){}).to(key).in(Scopes.SINGLETON);
        if (this.getRequestContextInterface().equals(DefaultRequestContext.class) && DefaultRouter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
            this.bind(DefaultRouter.class).to(key).in(Scopes.SINGLETON);
        }
    }

    protected void bindRouteFactory() {
        Key<?> key = this.getRouteKey();
        try {
            key.getTypeLiteral().getSupertype(Route.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The route Key must implement " + Route.class.getName() + " : " + key);
        }
        Key routeKey = this.parameterizeWithRequestContext(Route.class);
        Key factoryKey = this.parameterizeWithRequestContext(RouteFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(routeKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(routeKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindWebsocketRouteFactory() {
        Key<?> key = this.getWebsocketRouteKey();
        try {
            key.getTypeLiteral().getSupertype(WebsocketRoute.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The websocket route Key must implement " + WebsocketRoute.class.getName() + " : " + key);
        }
        Key routeKey = this.parameterizeWithContextInterfaces(WebsocketRoute.class);
        Key factoryKey = this.parameterizeWithContextInterfaces(WebsocketRouteFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(routeKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(routeKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindRouteBuilderFactory() {
        Key interfaceKey = this.parameterizeWithRequestContext(RouteBuilder.class);
        Key implementationKey = this.parameterizeWithContextInterfaces(this.getRouteBuilderImplClass());
        Key factoryKey = this.parameterizeWithContextInterfaces(RouteBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends RouteBuilder> getRouteBuilderImplClass() {
        return RouteBuilderDefault.class;
    }

    protected void bindRedirectRuleBuilderFactory() {
        Key interfaceKey = this.parameterizeWithContextInterfaces(RedirectRuleBuilder.class);
        Key implementationKey = this.parameterizeWithContextInterfaces(this.getRedirectRuleBuilderImplClass());
        Key factoryKey = this.parameterizeWithContextInterfaces(RedirectRuleBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends RedirectRuleBuilder> getRedirectRuleBuilderImplClass() {
        return RedirectRuleBuilderDefault.class;
    }

    protected void bindWebsocketRouteBuilderFactory() {
        Key interfaceKey = this.parameterizeWithContextInterfaces(WebsocketRouteBuilder.class);
        Key implementationKey = this.parameterizeWithContextInterfaces(this.getWebsocketRouteBuilderImplClass());
        Key factoryKey = this.parameterizeWithContextInterfaces(WebsocketRouteBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends WebsocketRouteBuilder> getWebsocketRouteBuilderImplClass() {
        return WebsocketRouteBuilderDefault.class;
    }

    protected void bindWebsocketRouteHandlerFactory() {
        Key interfaceKey = this.parameterizeWithRequestContext(Handler.class);
        Key implementationKey = this.parameterizeWithContextInterfaces(this.getWebsocketRouteHandlerImplClass());
        Key factoryKey = this.parameterizeWithContextInterfaces(WebsocketRouteHandlerFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends Handler> getWebsocketRouteHandlerImplClass() {
        return WebsocketRouteHandler.class;
    }

    protected void bindRouteHandlerMatchFactory() {
        Key interfaceKey = this.parameterizeWithRequestContext(RouteHandlerMatch.class);
        Key implementationKey = this.parameterizeWithRequestContext(this.getRouteHandlerMatchImplClass());
        Key factoryKey = this.parameterizeWithRequestContext(RouteHandlerMatchFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends RouteHandlerMatch> getRouteHandlerMatchImplClass() {
        return RouteHandlerMatchDefault.class;
    }

    protected void bindStaticResourceFactory() {
        Key<?> key = this.getStaticResourceKey();
        try {
            key.getTypeLiteral().getSupertype(StaticResource.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The static resource Key must implement " + StaticResource.class.getName() + " : " + key);
        }
        Key staticResourceKey = this.parameterizeWithRequestContext(StaticResource.class);
        Key factoryKey = this.parameterizeWithRequestContext(StaticResourceFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(staticResourceKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(staticResourceKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindStaticResourceBuilderFactory() {
        Key interfaceKey = this.parameterizeWithRequestContext(StaticResourceBuilder.class);
        Key implementationKey = this.parameterizeWithContextInterfaces(this.getStaticResourceBuilderImplClass());
        Key factoryKey = this.parameterizeWithContextInterfaces(StaticResourceBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends StaticResourceBuilder> getStaticResourceBuilderImplClass() {
        return StaticResourceBuilderDefault.class;
    }

    protected void bindStaticResourceCorsConfigFactory() {
        this.install(new FactoryModuleBuilder().implement(StaticResourceCorsConfig.class, this.getStaticResourceCorsConfigImplClass()).build(StaticResourceCorsConfigFactory.class));
    }

    protected Class<? extends StaticResourceCorsConfig> getStaticResourceCorsConfigImplClass() {
        return StaticResourceCorsConfigDefault.class;
    }

    protected void bindStaticResourceCacheConfigFactory() {
        this.install(new FactoryModuleBuilder().implement(StaticResourceCacheConfig.class, this.getStaticResourceCacheConfigImplClass()).build(StaticResourceCacheConfigFactory.class));
    }

    protected Class<? extends StaticResourceCacheConfig> getStaticResourceCacheConfigImplClass() {
        return StaticResourceCacheConfigDefault.class;
    }

    protected void bindStaticResourceHotlinkingManager() {
        this.bind(HotlinkingManagerDefault.class).in(Scopes.SINGLETON);
        this.bind(HotlinkingManager.class).to(HotlinkingManagerDefault.class).in(Scopes.SINGLETON);
    }

    protected void bindRequestContextAddon() {
        this.bind(this.parameterizeWithRequestContext(RoutingRequestContextAddon.class)).to(this.parameterizeWithContextInterfaces(SpincastRoutingRequestContextAddon.class)).in((Scope)SpincastGuiceScopes.REQUEST);
    }

    protected void bindETagFactory() {
        this.bind(ETagFactory.class).to(this.getETagFactoryImplClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends ETagFactory> getETagFactoryImplClass() {
        return ETagFactoryDefault.class;
    }

    protected void bindSpincastRoutingUtils() {
        this.bind(SpincastRoutingUtils.class).to(this.getSpincastRoutingUtilsImplClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends SpincastRoutingUtils> getSpincastRoutingUtilsImplClass() {
        return SpincastRoutingUtilsDefault.class;
    }
}

