/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.RedirectRuleBuilder;
import org.spincast.core.routing.RedirectRuleBuilderFactory;
import org.spincast.core.routing.Route;
import org.spincast.core.routing.RouteBuilder;
import org.spincast.core.routing.RouteBuilderFactory;
import org.spincast.core.routing.RouteHandlerMatch;
import org.spincast.core.routing.Router;
import org.spincast.core.routing.RoutingResult;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.StaticResourceBuilder;
import org.spincast.core.routing.StaticResourceBuilderFactory;
import org.spincast.core.routing.StaticResourceFactory;
import org.spincast.core.server.Server;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketRoute;
import org.spincast.core.websocket.WebsocketRouteBuilder;
import org.spincast.core.websocket.WebsocketRouteBuilderFactory;
import org.spincast.core.websocket.WebsocketRouteHandlerFactory;
import org.spincast.plugins.routing.RouteFactory;
import org.spincast.plugins.routing.RouteHandlerMatchFactory;
import org.spincast.plugins.routing.RoutingResultDefault;
import org.spincast.plugins.routing.SpincastRouterConfig;
import org.spincast.plugins.routing.SpincastRouterDeps;
import org.spincast.plugins.routing.utils.SpincastRoutingUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastRouter<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements Router<R, W> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastRouter.class);
    private final RouteHandlerMatchFactory<R> routeHandlerMatchFactory;
    private final RouteBuilderFactory<R, W> routeBuilderFactory;
    private final RedirectRuleBuilderFactory<R, W> redirectRuleBuilderFactory;
    private final StaticResourceBuilderFactory<R, W> staticResourceBuilderFactory;
    private final StaticResourceFactory<R> staticResourceFactory;
    private final SpincastRouterConfig spincastRouterConfig;
    private final RouteFactory<R> routeFactory;
    private final SpincastConfig spincastConfig;
    private final Dictionary dictionary;
    private final SpincastFilters<R> spincastFilters;
    private final WebsocketRouteBuilderFactory<R, W> websocketRouteBuilderFactory;
    private final WebsocketRouteHandlerFactory<R, W> websocketRouteHandlerFactory;
    private final SpincastRoutingUtils spincastRoutingUtils;
    private TreeMap<Integer, List<Route<R>>> globalBeforeFiltersPerPosition;
    private TreeMap<Integer, List<Route<R>>> globalAfterFiltersPerPosition;
    private List<Route<R>> globalBeforeFilters;
    private List<Route<R>> globalAfterFilters;
    private List<Route<R>> mainRoutes;
    private final Server server;
    private final Map<String, String> routeParamPatternAliases = new HashMap<String, String>();
    private final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    @Inject
    public SpincastRouter(SpincastRouterDeps<R, W> spincastRouterDeps) {
        this.spincastRouterConfig = spincastRouterDeps.getSpincastRouterConfig();
        this.routeFactory = spincastRouterDeps.getRouteFactory();
        this.spincastConfig = spincastRouterDeps.getSpincastConfig();
        this.dictionary = spincastRouterDeps.getDictionary();
        this.server = spincastRouterDeps.getServer();
        this.spincastFilters = spincastRouterDeps.getSpincastFilters();
        this.routeBuilderFactory = spincastRouterDeps.getRouteBuilderFactory();
        this.redirectRuleBuilderFactory = spincastRouterDeps.getRedirectRuleBuilderFactory();
        this.staticResourceBuilderFactory = spincastRouterDeps.getStaticResourceBuilderFactory();
        this.routeHandlerMatchFactory = spincastRouterDeps.getRouteHandlerMatchFactory();
        this.staticResourceFactory = spincastRouterDeps.getStaticResourceFactory();
        this.websocketRouteBuilderFactory = spincastRouterDeps.getWebsocketRouteBuilderFactory();
        this.websocketRouteHandlerFactory = spincastRouterDeps.getWebsocketRouteHandlerFactory();
        this.spincastRoutingUtils = spincastRouterDeps.getSpincastRoutingUtils();
    }

    @Inject
    protected void init() {
        this.validation();
        this.addDefaultFilters();
    }

    protected void validation() {
        int corsFilterPosition = this.getSpincastRouterConfig().getCorsFilterPosition();
        if (corsFilterPosition >= 0) {
            throw new RuntimeException("The position of the Cors filter must be less than 0. Currently : " + corsFilterPosition);
        }
    }

    protected void addDefaultFilters() {
        if (this.getSpincastConfig().isAddDefaultTemplateVariablesFilter()) {
            this.ALL("/*{path}").id("spincast_default_template_variables").spicastCoreRouteOrPluginRoute().pos(this.getSpincastConfig().getDefaultTemplateVariablesFilterPosition()).found().notFound().exception().handle(new Handler<R>(){

                public void handle(R context) {
                    SpincastRouter.this.getSpincastFilters().addDefaultGlobalTemplateVariables(context);
                }
            });
        }
    }

    protected SpincastRouterConfig getSpincastRouterConfig() {
        return this.spincastRouterConfig;
    }

    protected RouteFactory<R> getRouteFactory() {
        return this.routeFactory;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    protected Server getServer() {
        return this.server;
    }

    protected SpincastFilters<R> getSpincastFilters() {
        return this.spincastFilters;
    }

    protected RouteBuilderFactory<R, W> getRouteBuilderFactory() {
        return this.routeBuilderFactory;
    }

    protected RedirectRuleBuilderFactory<R, W> getRedirectRuleBuilderFactory() {
        return this.redirectRuleBuilderFactory;
    }

    protected WebsocketRouteBuilderFactory<R, W> getWebsocketRouteBuilderFactory() {
        return this.websocketRouteBuilderFactory;
    }

    protected WebsocketRouteHandlerFactory<R, W> getWebsocketRouteHandlerFactory() {
        return this.websocketRouteHandlerFactory;
    }

    protected StaticResourceBuilderFactory<R, W> getStaticResourceBuilderFactory() {
        return this.staticResourceBuilderFactory;
    }

    protected RouteHandlerMatchFactory<R> getRouteHandlerMatchFactory() {
        return this.routeHandlerMatchFactory;
    }

    protected StaticResourceFactory<R> getStaticResourceFactory() {
        return this.staticResourceFactory;
    }

    protected SpincastRoutingUtils getSpincastRoutingUtils() {
        return this.spincastRoutingUtils;
    }

    protected Pattern getPattern(String patternStr) {
        Pattern pattern = this.patternCache.get(patternStr);
        if (pattern == null) {
            pattern = Pattern.compile(patternStr);
            this.patternCache.put(patternStr, pattern);
        }
        return pattern;
    }

    public Map<String, String> getRouteParamPatternAliases() {
        return this.routeParamPatternAliases;
    }

    public Route<R> getRoute(String routeId) {
        for (Route<R> route : this.getGlobalBeforeFiltersRoutes()) {
            if ((routeId != null || route.getId() != null) && (routeId == null || !routeId.equals(route.getId()))) continue;
            return route;
        }
        for (Route<R> route : this.getMainRoutes()) {
            if ((routeId != null || route.getId() != null) && (routeId == null || !routeId.equals(route.getId()))) continue;
            return route;
        }
        for (Route<R> route : this.getGlobalAfterFiltersRoutes()) {
            if ((routeId != null || route.getId() != null) && (routeId == null || !routeId.equals(route.getId()))) continue;
            return route;
        }
        return null;
    }

    protected Map<Integer, List<Route<R>>> getGlobalBeforeFiltersPerPosition() {
        if (this.globalBeforeFiltersPerPosition == null) {
            this.globalBeforeFiltersPerPosition = new TreeMap();
        }
        return this.globalBeforeFiltersPerPosition;
    }

    public List<Route<R>> getGlobalBeforeFiltersRoutes() {
        if (this.globalBeforeFilters == null) {
            this.globalBeforeFilters = new ArrayList<Route<R>>();
            Collection<List<Route<R>>> routesLists = this.getGlobalBeforeFiltersPerPosition().values();
            if (routesLists != null) {
                for (List<Route<R>> routeList : routesLists) {
                    this.globalBeforeFilters.addAll(routeList);
                }
            }
        }
        return this.globalBeforeFilters;
    }

    protected Map<Integer, List<Route<R>>> getGlobalAfterFiltersPerPosition() {
        if (this.globalAfterFiltersPerPosition == null) {
            this.globalAfterFiltersPerPosition = new TreeMap();
        }
        return this.globalAfterFiltersPerPosition;
    }

    public List<Route<R>> getGlobalAfterFiltersRoutes() {
        if (this.globalAfterFilters == null) {
            this.globalAfterFilters = new ArrayList<Route<R>>();
            Collection<List<Route<R>>> routesLists = this.getGlobalAfterFiltersPerPosition().values();
            if (routesLists != null) {
                for (List<Route<R>> routeList : routesLists) {
                    this.globalAfterFilters.addAll(routeList);
                }
            }
        }
        return this.globalAfterFilters;
    }

    public List<Route<R>> getMainRoutes() {
        if (this.mainRoutes == null) {
            this.mainRoutes = new ArrayList<Route<R>>();
        }
        return this.mainRoutes;
    }

    public void addRoute(Route<R> route) {
        if (route == null || route.getMainHandler() == null || route.getHttpMethods() == null) {
            return;
        }
        this.validateId(route.getId());
        this.validatePath(route.getPath());
        int position = route.getPosition();
        if (position < 0) {
            this.globalBeforeFilters = null;
            List<Route<R>> routes = this.getGlobalBeforeFiltersPerPosition().get(position);
            if (routes == null) {
                routes = new ArrayList<Route<R>>();
                this.getGlobalBeforeFiltersPerPosition().put(position, routes);
            }
            routes.add(route);
        } else if (position == 0) {
            this.getMainRoutes().add(route);
        } else {
            this.globalAfterFilters = null;
            List<Route<R>> routes = this.getGlobalAfterFiltersPerPosition().get(position);
            if (routes == null) {
                routes = new ArrayList<Route<R>>();
                this.getGlobalAfterFiltersPerPosition().put(position, routes);
            }
            routes.add(route);
        }
    }

    protected void validateId(String id) {
        if (id == null) {
            return;
        }
        Route<R> sameIdRoute = null;
        for (Route<R> route : this.getGlobalBeforeFiltersRoutes()) {
            if (!id.equals(route.getId())) continue;
            sameIdRoute = route;
            break;
        }
        if (sameIdRoute == null) {
            for (Route<R> route : this.getGlobalAfterFiltersRoutes()) {
                if (!id.equals(route.getId())) continue;
                sameIdRoute = route;
                break;
            }
        }
        if (sameIdRoute == null) {
            for (Route<R> route : this.getMainRoutes()) {
                if (!id.equals(route.getId())) continue;
                sameIdRoute = route;
                break;
            }
        }
        if (sameIdRoute != null) {
            throw new RuntimeException("A route already use the id '" + id + "' : " + sameIdRoute + ". Ids must be uniques!");
        }
    }

    protected void validatePath(String path) {
        if (path == null) {
            return;
        }
        HashSet<String> paramNames = new HashSet<String>();
        String[] pathTokens = path.split("/");
        boolean splatFound = false;
        for (String pathToken : pathTokens) {
            if (StringUtils.isBlank((CharSequence)pathToken) || !pathToken.startsWith("${") && !pathToken.startsWith("*{")) continue;
            if (!pathToken.endsWith("}")) {
                throw new RuntimeException("A parameter in the path of a route must end with '}'. Incorrect parameter : " + pathToken);
            }
            if (pathToken.startsWith("*{")) {
                if (splatFound) {
                    throw new RuntimeException("The path of a route can only contain one splat parameter (the one starting with a '*{'). The path is : " + path);
                }
                if (pathToken.contains(":")) {
                    throw new RuntimeException("A splat parameter can't contain a pattern (so no ':' allowed) : " + pathToken);
                }
                splatFound = true;
            } else {
                String token = pathToken.substring(2, pathToken.length() - 1);
                int posColon = token.indexOf(":");
                if (posColon > -1 && (token = token.substring(posColon + 1)).startsWith("<")) {
                    if (!token.endsWith(">")) {
                        throw new RuntimeException("A parameter with an pattern alias must have a closing '>' : " + pathToken);
                    }
                    String pattern = this.getPatternFromAlias(token = token.substring(1, token.length() - 1));
                    if (pattern == null) {
                        throw new RuntimeException("Pattern not found using alias : " + token);
                    }
                }
            }
            String paramName = pathToken.substring(2, pathToken.length() - 1);
            if (!StringUtils.isBlank((CharSequence)paramName) && paramNames.contains(paramName)) {
                throw new RuntimeException("Two parameters with the same name, '" + paramName + "', in route with path : " + path);
            }
            paramNames.add(paramName);
        }
    }

    public void removeAllRoutes() {
        this.removeAllRoutes(false);
    }

    public void removeAllRoutes(boolean removeSpincastAndPluginsRoutesToo) {
        this.globalBeforeFilters = null;
        this.globalAfterFilters = null;
        if (removeSpincastAndPluginsRoutesToo) {
            this.getGlobalBeforeFiltersPerPosition().clear();
            this.getMainRoutes().clear();
            this.getGlobalAfterFiltersPerPosition().clear();
        } else {
            Route<R> route;
            int i;
            Collection<List<Route<R>>> routeLists = this.getGlobalBeforeFiltersPerPosition().values();
            for (List<Route<R>> routes : routeLists) {
                for (i = routes.size() - 1; i >= 0; --i) {
                    route = routes.get(i);
                    if (route.isSpicastCoreRouteOrPluginRoute()) continue;
                    routes.remove(i);
                }
            }
            routeLists = this.getGlobalAfterFiltersPerPosition().values();
            for (List<Route<R>> routes : routeLists) {
                for (i = routes.size() - 1; i >= 0; --i) {
                    route = routes.get(i);
                    if (route.isSpicastCoreRouteOrPluginRoute()) continue;
                    routes.remove(i);
                }
            }
            List<Route<R>> routes = this.getMainRoutes();
            for (int i2 = routes.size() - 1; i2 >= 0; --i2) {
                Route<R> route2 = routes.get(i2);
                if (route2.isSpicastCoreRouteOrPluginRoute()) continue;
                routes.remove(i2);
            }
        }
    }

    protected boolean startsWithAnyOf(String id, Set<String> prefixes) {
        if (id == null || prefixes == null || prefixes.size() == 0) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!id.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public void removeRoute(String routeId) {
        Route<R> route;
        int i;
        if (routeId == null) {
            return;
        }
        Collection<List<Route<R>>> routeLists = this.getGlobalBeforeFiltersPerPosition().values();
        for (List<Route<R>> routes : routeLists) {
            for (i = routes.size() - 1; i >= 0; --i) {
                route = routes.get(i);
                if (route == null || !routeId.equals(route.getId())) continue;
                routes.remove(i);
            }
        }
        this.globalBeforeFilters = null;
        routeLists = this.getGlobalAfterFiltersPerPosition().values();
        for (List<Route<R>> routes : routeLists) {
            for (i = routes.size() - 1; i >= 0; --i) {
                route = routes.get(i);
                if (route == null || !routeId.equals(route.getId())) continue;
                routes.remove(i);
            }
        }
        this.globalAfterFilters = null;
        List<Route<R>> routes = this.getMainRoutes();
        for (int i2 = routes.size() - 1; i2 >= 0; --i2) {
            Route<R> route2 = routes.get(i2);
            if (route2 == null || !routeId.equals(route2.getId())) continue;
            routes.remove(i2);
        }
    }

    public RoutingResult<R> route(R requestContext) {
        return this.route(requestContext, requestContext.request().getFullUrl(), RoutingType.FOUND);
    }

    public RoutingResult<R> route(R requestContext, RoutingType routingType) {
        return this.route(requestContext, requestContext.request().getFullUrl(), routingType);
    }

    public RoutingResult<R> route(R requestContext, String fullUrl, RoutingType routingType) {
        try {
            URL url = new URL(fullUrl);
            HttpMethod httpMethod = requestContext.request().getHttpMethod();
            ArrayList<String> acceptedContentTypes = requestContext.request().getHeader("Accept");
            if (acceptedContentTypes == null) {
                acceptedContentTypes = new ArrayList<String>();
            }
            ArrayList<RouteHandlerMatch<R>> routeHandlerMatches = new ArrayList<RouteHandlerMatch<R>>();
            List<RouteHandlerMatch<R>> mainRouteHandlerMatches = null;
            Route<R> matchingRoute = null;
            for (Route<R> route : this.getMainRoutes()) {
                List<RouteHandlerMatch<R>> routeHandlerMatch = this.createRegularHandlerMatches(routingType, route, httpMethod, acceptedContentTypes, url, 0);
                if (routeHandlerMatch == null || routeHandlerMatch.size() <= 0) continue;
                mainRouteHandlerMatches = routeHandlerMatch;
                matchingRoute = route;
                break;
            }
            if (matchingRoute != null) {
                for (Route<R> route : this.getGlobalBeforeFiltersRoutes()) {
                    List<RouteHandlerMatch<R>> beforeRouteHandlerMatches;
                    if (route.getId() != null && matchingRoute.getFilterIdsToSkip().contains(route.getId()) || !this.isRoutingTypeMatch(routingType, route) || this.isMustSkipResourceRequest(matchingRoute, route) || (beforeRouteHandlerMatches = this.createRegularHandlerMatches(routingType, route, httpMethod, acceptedContentTypes, url, -1)) == null) continue;
                    routeHandlerMatches.addAll(beforeRouteHandlerMatches);
                }
                routeHandlerMatches.addAll(mainRouteHandlerMatches);
                for (Route<R> route : this.getGlobalAfterFiltersRoutes()) {
                    List<RouteHandlerMatch<R>> afterRouteHandlerMatches;
                    if (route.getId() != null && matchingRoute.getFilterIdsToSkip().contains(route.getId()) || !this.isRoutingTypeMatch(routingType, route) || this.isMustSkipResourceRequest(matchingRoute, route) || (afterRouteHandlerMatches = this.createRegularHandlerMatches(routingType, route, httpMethod, acceptedContentTypes, url, 1)) == null) continue;
                    routeHandlerMatches.addAll(afterRouteHandlerMatches);
                }
            }
            if (routeHandlerMatches.size() == 0) {
                return null;
            }
            RoutingResult<R> routingResult = this.createRoutingResult(routeHandlerMatches);
            return routingResult;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected boolean isRoutingTypeMatch(RoutingType routingType, Route<R> route) {
        Objects.requireNonNull(routingType, "routingType can't be NULL");
        Objects.requireNonNull(route, "route can't be NULL");
        return route.getRoutingTypes() != null && route.getRoutingTypes().contains(routingType);
    }

    protected boolean isMustSkipResourceRequest(Route<R> mainRoute, Route<R> filterRoute) {
        return mainRoute.isStaticResourceRoute() && filterRoute.isSkipResourcesRequests();
    }

    protected RoutingResult<R> createRoutingResult(List<RouteHandlerMatch<R>> routeHandlerMatches) {
        RoutingResultDefault<R> routingResult = new RoutingResultDefault<R>(routeHandlerMatches);
        return routingResult;
    }

    protected List<RouteHandlerMatch<R>> createRegularHandlerMatches(RoutingType routingType, Route<R> route, HttpMethod httpMethod, List<String> acceptedContentTypes, URL url, int position) {
        List afterFilters;
        if (!this.isRoutingTypeMatch(routingType, route)) {
            return null;
        }
        if (!this.isRouteMatchHttpMethod(route, httpMethod)) {
            return null;
        }
        if (!this.isRouteMatchAcceptedContentType(route, acceptedContentTypes)) {
            return null;
        }
        String routePath = route.getPath();
        Map<String, String> matchingParams = this.validatePath(routePath, url);
        if (matchingParams == null) {
            return null;
        }
        ArrayList<RouteHandlerMatch<R>> matches = new ArrayList<RouteHandlerMatch<R>>();
        RouteHandlerMatch<R> routeHandlerMatch = this.getRouteHandlerMatchFactory().create(route, route.getMainHandler(), matchingParams, position);
        matches.add(routeHandlerMatch);
        List beforeFilters = route.getBeforeFilters();
        if (beforeFilters != null) {
            for (Handler beforeFilter : beforeFilters) {
                if (beforeFilter == null) continue;
                RouteHandlerMatch<R> beforeMethodRouteHandlerMatch = this.createHandlerMatchForBeforeOrAfterFilter(routeHandlerMatch, beforeFilter, -1);
                matches.add(0, beforeMethodRouteHandlerMatch);
            }
        }
        if ((afterFilters = route.getAfterFilters()) != null) {
            for (Handler afterFilter : afterFilters) {
                if (afterFilter == null) continue;
                RouteHandlerMatch<R> afterMethodRouteHandlerMatch = this.createHandlerMatchForBeforeOrAfterFilter(routeHandlerMatch, afterFilter, 1);
                matches.add(afterMethodRouteHandlerMatch);
            }
        }
        return matches;
    }

    protected boolean isRouteMatchAcceptedContentType(Route<R> route, List<String> requestContentTypes) {
        if (requestContentTypes == null || requestContentTypes.size() == 0) {
            return true;
        }
        Set routeContentTypes = route.getAcceptedContentTypes();
        if (routeContentTypes == null || routeContentTypes.size() == 0) {
            return true;
        }
        for (String contentType : requestContentTypes) {
            if (contentType == null || !routeContentTypes.contains(contentType.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected RouteHandlerMatch<R> createNoMatchingParamsHandlerMatch(Route<R> route, String id, Handler<R> handler, int position) {
        return this.getRouteHandlerMatchFactory().create(route, handler, null, position);
    }

    protected RouteHandlerMatch<R> createHandlerMatchForBeforeOrAfterFilter(RouteHandlerMatch<R> mainRouteHandlerMatch, Handler<R> beforeOrAfterMethod, int position) {
        RouteHandlerMatch<R> routeHandlerMatch = this.getRouteHandlerMatchFactory().create(mainRouteHandlerMatch.getSourceRoute(), beforeOrAfterMethod, mainRouteHandlerMatch.getPathParams(), position);
        return routeHandlerMatch;
    }

    protected boolean isRouteMatchHttpMethod(Route<R> route, HttpMethod httpMethod) {
        return route.getHttpMethods().contains(httpMethod);
    }

    protected Map<String, String> validatePath(String routePath, URL url) {
        String[] urlPathTokens;
        String[] routePathTokens;
        String urlPath = url.getPath();
        String urlPathSlashesStriped = StringUtils.strip((String)urlPath, (String)"/ ");
        String routePathSlashesStriped = StringUtils.strip((String)routePath, (String)"/ ");
        boolean routesAreCaseSensitive = this.getSpincastConfig().isRoutesCaseSensitive();
        if (routesAreCaseSensitive ? urlPathSlashesStriped.equals(routePathSlashesStriped) : urlPathSlashesStriped.equalsIgnoreCase(routePathSlashesStriped)) {
            return new HashMap<String, String>();
        }
        int pos = routePathSlashesStriped.indexOf("*{");
        boolean hasSplat = true;
        if (pos < 0) {
            hasSplat = false;
            pos = routePathSlashesStriped.indexOf("${");
            if (pos < 0) {
                return null;
            }
        }
        if ((routePathTokens = routePathSlashesStriped.split("/")).length == 1 && routePathTokens[0].equals("")) {
            routePathTokens = new String[]{};
        }
        if ((urlPathTokens = urlPathSlashesStriped.split("/")).length == 1 && urlPathTokens[0].equals("")) {
            urlPathTokens = new String[]{};
        }
        if (!hasSplat && urlPathTokens.length > routePathTokens.length) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        int urlTokenPos = 0;
        for (int routePathTokenPos = 0; routePathTokenPos < routePathTokens.length; ++routePathTokenPos) {
            int nbrTokensInSplat;
            String paramValue;
            String routePathToken = routePathTokens[routePathTokenPos];
            String urlPathToken = "";
            if (!routePathToken.startsWith("*{") || urlTokenPos < urlPathTokens.length) {
                if (urlTokenPos + 1 > urlPathTokens.length) {
                    return null;
                }
                urlPathToken = urlPathTokens[urlTokenPos];
            }
            ++urlTokenPos;
            if (!routePathToken.startsWith("${") && !routePathToken.startsWith("*{")) {
                if (!(routesAreCaseSensitive ? !urlPathToken.equals(routePathToken) : !urlPathToken.equalsIgnoreCase(routePathToken))) continue;
                return null;
            }
            String paramName = routePathToken.substring(2, routePathToken.length() - 1);
            try {
                paramValue = URLDecoder.decode(urlPathToken, "UTF-8");
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
            String pattern = null;
            if (routePathToken.startsWith("${")) {
                int posComma = paramName.indexOf(":");
                if (posComma > -1) {
                    pattern = paramName.substring(posComma + 1);
                    paramName = paramName.substring(0, posComma);
                    if (StringUtils.isBlank((CharSequence)pattern)) {
                        pattern = null;
                    } else if (pattern.startsWith("<") && pattern.endsWith(">")) {
                        pattern = this.getPatternFromAlias(pattern.substring(1, pattern.length() - 1));
                    }
                }
                if (pattern != null && !this.getPattern(pattern).matcher(urlPathToken).matches()) {
                    this.logger.debug("Url token '" + urlPathToken + "' doesn't match pattern '" + pattern + "'.");
                    return null;
                }
            } else if (routePathToken.startsWith("*{") && (nbrTokensInSplat = urlPathTokens.length - routePathTokens.length + 1) > 1) {
                StringBuilder builder = new StringBuilder(paramValue);
                for (int i = 1; i < nbrTokensInSplat; ++i) {
                    builder.append("/").append(urlPathTokens[urlTokenPos]);
                    ++urlTokenPos;
                }
                paramValue = builder.toString();
            }
            if (StringUtils.isBlank((CharSequence)paramName)) continue;
            params.put(paramName, paramValue);
        }
        return params;
    }

    protected String getPatternFromAlias(String alias) {
        if (alias == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.getRouteParamPatternAliases().entrySet()) {
            if (!alias.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public void addRouteParamPatternAlias(String alias, String pattern) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            throw new RuntimeException("The alias can't be empty.");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new RuntimeException("The pattern can't be empty.");
        }
        this.getRouteParamPatternAliases().put(alias, pattern);
    }

    public RouteBuilder<R> GET() {
        return this.GET("/*{path}");
    }

    public RouteBuilder<R> GET(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.GET();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> POST() {
        return this.POST("/*{path}");
    }

    public RouteBuilder<R> POST(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.POST();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> PUT() {
        return this.PUT("/*{path}");
    }

    public RouteBuilder<R> PUT(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.PUT();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> DELETE() {
        return this.DELETE("/*{path}");
    }

    public RouteBuilder<R> DELETE(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.DELETE();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> OPTIONS() {
        return this.OPTIONS("/*{path}");
    }

    public RouteBuilder<R> OPTIONS(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.OPTIONS();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> TRACE() {
        return this.TRACE("/*{path}");
    }

    public RouteBuilder<R> TRACE(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.TRACE();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> HEAD() {
        return this.HEAD("/*{path}");
    }

    public RouteBuilder<R> HEAD(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.HEAD();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> PATCH() {
        return this.PATCH("/*{path}");
    }

    public RouteBuilder<R> PATCH(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.PATCH();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> ALL() {
        return this.ALL("/*{path}");
    }

    public RouteBuilder<R> ALL(String path) {
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.ALL();
        builder = builder.path(path);
        return builder;
    }

    public RouteBuilder<R> methods(HttpMethod ... httpMethods) {
        return this.methods("/*{path}", httpMethods);
    }

    public RouteBuilder<R> methods(String path, HttpMethod ... httpMethods) {
        if (httpMethods.length == 0) {
            throw new RuntimeException("Using methods(...), you have to specify at least one HTTP method.");
        }
        return this.methods(path, Sets.newHashSet((Object[])httpMethods));
    }

    public RouteBuilder<R> methods(Set<HttpMethod> httpMethods) {
        return this.methods("/*{path}", httpMethods);
    }

    public RouteBuilder<R> methods(String path, Set<HttpMethod> httpMethods) {
        if (httpMethods == null || httpMethods.size() == 0) {
            throw new RuntimeException("Using methods(...), you have to specify at least one HTTP method.");
        }
        RouteBuilder builder = this.getRouteBuilderFactory().create((Router)this);
        builder = builder.methods(httpMethods);
        builder = builder.path(path);
        return builder;
    }

    public void exception(Handler<R> handler) {
        this.exception("/*{path}", handler);
    }

    public void exception(String path, Handler<R> handler) {
        this.ALL(path).exception().handle(handler);
    }

    public void notFound(Handler<R> handler) {
        this.notFound("/*{path}", handler);
    }

    public void notFound(String path, Handler<R> handler) {
        this.ALL(path).notFound().handle(handler);
    }

    public void cors() {
        this.cors("/*{path}");
    }

    public void cors(Set<String> allowedOrigins) {
        this.cors("/*{path}", allowedOrigins);
    }

    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead);
    }

    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent);
    }

    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies);
    }

    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods);
    }

    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods, int maxAgeInSeconds) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, maxAgeInSeconds);
    }

    public void cors(String path) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).found().notFound().handle(new Handler<R>(){

            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context);
            }
        });
    }

    public void cors(String path, final Set<String> allowedOrigins) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).found().notFound().handle(new Handler<R>(){

            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins);
            }
        });
    }

    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).found().notFound().handle(new Handler<R>(){

            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead);
            }
        });
    }

    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).found().notFound().handle(new Handler<R>(){

            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent);
            }
        });
    }

    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent, final boolean allowCookies) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).found().notFound().handle(new Handler<R>(){

            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies);
            }
        });
    }

    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent, final boolean allowCookies, final Set<HttpMethod> allowedMethods) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).found().notFound().handle(new Handler<R>(){

            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods);
            }
        });
    }

    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent, final boolean allowCookies, final Set<HttpMethod> allowedMethods, final int maxAgeInSeconds) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).found().notFound().handle(new Handler<R>(){

            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, maxAgeInSeconds);
            }
        });
    }

    public StaticResourceBuilder<R> file(String url) {
        StaticResourceBuilder builder = this.getStaticResourceBuilderFactory().create((Router)this, false);
        builder = builder.url(url);
        return builder;
    }

    public StaticResourceBuilder<R> dir(String url) {
        StaticResourceBuilder builder = this.getStaticResourceBuilderFactory().create((Router)this, true);
        builder = builder.url(url);
        return builder;
    }

    public void addStaticResource(final StaticResource<R> staticResource) {
        boolean mustBeRegisteredOnServer;
        String[] tokens;
        if (staticResource.getUrlPath() == null) {
            throw new RuntimeException("The URL to the resource must be specified!");
        }
        if (staticResource.getResourcePath() == null) {
            throw new RuntimeException("A classpath or a file system path must be specified!");
        }
        if (staticResource.isDirResource() && this.getSpincastRoutingUtils().isPathContainDynamicParams(staticResource.getResourcePath())) {
            throw new RuntimeException("You can't use a dynamic (or splat) parameters in the path of the target resource when using 'dir()'. The resulting path must be fixed, since the server will try to find the resource in it. It cannot depend on the current request since the server doesn't know about dynamic parameters and how to replace them.");
        }
        if (staticResource.isClasspath() && staticResource.getGenerator() != null) {
            throw new RuntimeException("A resource generator can only be specified when a file system path is used, not a classpath path.");
        }
        boolean dynParamFound = false;
        boolean splatParamFound = false;
        StringBuilder urlWithoutEndingSplatParamBuilder = new StringBuilder("");
        for (String token : tokens = staticResource.getUrlPath().split("/")) {
            if (StringUtils.isBlank((CharSequence)(token = token.trim()))) continue;
            boolean isDynParam = false;
            boolean isSplatParam = false;
            if (token.startsWith("${")) {
                isDynParam = true;
            } else if (token.startsWith("*{")) {
                isSplatParam = true;
            }
            if (!isSplatParam) {
                urlWithoutEndingSplatParamBuilder.append("/").append(token);
            }
            if (staticResource.isFileResource()) {
                if (isSplatParam) {
                    throw new RuntimeException("A file resource path can't contain a splat parameter. Use 'dir()' instead!");
                }
                if (!staticResource.isCanBeGenerated() && isDynParam) {
                    throw new RuntimeException("A file resource path can't contain dynamic parameters if no generator is used. Use 'dir()', add a generator or use a regular route instead.");
                }
            } else {
                if (isDynParam) {
                    throw new RuntimeException("A dir static resource route can't contains any standard dynamic parameter. It can only contain a splat parameter, at the very end of the path. Invalid token : " + token);
                }
                if (splatParamFound) {
                    throw new RuntimeException("A dir resource path can contain one splat parameter, and only at the very end of the path! For example, this is invalid as a path : '/one/*{param1}/two', but this is valid : '/one/two/*{param1}'.");
                }
            }
            if (isDynParam) {
                dynParamFound = true;
                continue;
            }
            if (!isSplatParam) continue;
            splatParamFound = true;
        }
        String urlWithoutSplatParam = urlWithoutEndingSplatParamBuilder.toString();
        if (StringUtils.isBlank((CharSequence)urlWithoutSplatParam)) {
            urlWithoutSplatParam = "/";
        }
        if (staticResource.isDirResource() && splatParamFound) {
            StaticResource staticResourceNoDynParams = this.getStaticResourceFactory().create(staticResource.isSpicastOrPluginAddedResource(), staticResource.getStaticResourceType(), urlWithoutSplatParam, staticResource.getResourcePath(), staticResource.getGenerator(), staticResource.getCorsConfig(), staticResource.getCacheConfig(), staticResource.isIgnoreQueryString(), staticResource.isHotlinkingProtected(), staticResource.getHotlinkingManager());
            this.getServer().addStaticResourceToServe(staticResourceNoDynParams);
        } else if (!splatParamFound && !dynParamFound) {
            this.getServer().addStaticResourceToServe(staticResource);
        }
        boolean bl = mustBeRegisteredOnServer = staticResource.isFileResource() && (splatParamFound || dynParamFound);
        if (staticResource.getGenerator() != null) {
            Route<R> route = null;
            Handler saveResourceFilter = null;
            if (this.isCreateStaticResourceOnDisk()) {
                final String urlWithoutSplatParamFinal = urlWithoutSplatParam;
                saveResourceFilter = new Handler<R>(){

                    /*
                     * Unable to fully structure code
                     */
                    public void handle(R context) {
                        if (200 != context.response().getStatusCode()) {
                            SpincastRouter.this.logger.info("Nothing will be saved since the response code is not 200");
                            return;
                        }
                        if (!staticResource.isIgnoreQueryString() && context.request().getQueryStringParams() != null && context.request().getQueryStringParams().size() > 0) {
                            SpincastRouter.this.logger.info("Nothing will be saved since the queryString contains parameters and 'isIgnoreQueryString' is false  : " + context.request().getQueryString(false));
                            return;
                        }
                        if (context.response().isHeadersSent()) {
                            SpincastRouter.this.logger.warn("Headers sent, we can't save a copy of the generated resource! You will have to make sure that you save the generated resource by yourself, otherwise, a new version will be generated for each request!");
                            return;
                        }
                        if (staticResource.isDirResource()) {
                            urlPathPrefix = StringUtils.stripStart((String)urlWithoutSplatParamFinal, (String)"/");
                            requestPath = context.request().getRequestPath();
                            if (!(requestPath = StringUtils.stripStart((String)requestPath, (String)"/")).startsWith(urlPathPrefix)) {
                                throw new RuntimeException("The requestPath '" + requestPath + "' should starts with the urlPathPrefix '" + urlPathPrefix + "' here!");
                            }
                            requestPath = requestPath.substring(urlPathPrefix.length());
                            try {
                                resourceToGeneratePath = new File(staticResource.getResourcePath() + "/" + requestPath).getCanonicalFile().getAbsolutePath();
                                resourcesRoot = new File(staticResource.getResourcePath()).getCanonicalFile().getAbsolutePath();
                                if (!resourceToGeneratePath.startsWith(resourcesRoot)) {
                                    throw new RuntimeException("The requestPath '" + resourceToGeneratePath + "' should be inside the root resources folder : " + resourcesRoot);
                                }
                                if (StringUtils.isBlank((CharSequence)requestPath)) ** GOTO lbl36
                                SpincastRouter.this.getSpincastFilters().saveGeneratedResource(context, resourceToGeneratePath);
                            }
                            catch (Exception ex) {
                                throw SpincastStatics.runtimize((Exception)ex);
                            }
                        } else {
                            targetPath = staticResource.getResourcePath();
                            result = SpincastRouter.this.getSpincastRoutingUtils().replaceDynamicParamsInPath(targetPath, context.request().getPathParams());
                            if (result.isPlaceholdersRemaining()) {
                                throw new RuntimeException("Not supposed : there are some remaining placeholders in the target path for the generated static resource file : " + result.getPath());
                            }
                            targetPath = result.getPath();
                            resourceSaved = SpincastRouter.this.getSpincastFilters().saveGeneratedResource(context, targetPath);
                            if (mustBeRegisteredOnServer) {
                                newStaticResource = SpincastRouter.this.getStaticResourceFactory().create(staticResource.isSpicastOrPluginAddedResource(), staticResource.getStaticResourceType(), context.request().getRequestPath(), targetPath, staticResource.getGenerator(), staticResource.getCorsConfig(), staticResource.getCacheConfig(), staticResource.isIgnoreQueryString(), staticResource.isHotlinkingProtected(), staticResource.getHotlinkingManager());
                                SpincastRouter.this.getServer().addStaticResourceToServe(newStaticResource);
                            }
                        }
lbl36:
                        // 5 sources

                        if ((cacheConfig = staticResource.getCacheConfig()) != null) {
                            SpincastRouter.this.getSpincastFilters().cache(context, cacheConfig.getCacheSeconds(), cacheConfig.isCachePrivate(), cacheConfig.getCacheSecondsCdn());
                        }
                    }
                };
            }
            route = this.getRouteFactory().createRoute(null, false, true, staticResource, staticResource.isSpicastOrPluginAddedResource(), Sets.newHashSet((Object[])new HttpMethod[]{HttpMethod.GET}), staticResource.getUrlPath(), Sets.newHashSet((Object[])new RoutingType[]{RoutingType.FOUND}), null, staticResource.getGenerator(), saveResourceFilter != null ? Arrays.asList(saveResourceFilter) : null, 0, null, null, false, null, null, true);
            this.addRoute(route);
        }
    }

    protected boolean isCreateStaticResourceOnDisk() {
        return this.getSpincastConfig().isWriteToDiskDynamicStaticResource();
    }

    public void httpAuth(String pathPrefix, String realmName) {
        String[] tokens;
        if (StringUtils.isBlank((CharSequence)realmName)) {
            throw new RuntimeException("The realm name can't be empty");
        }
        if (StringUtils.isBlank((CharSequence)pathPrefix)) {
            pathPrefix = "/";
        } else if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        for (String token : tokens = pathPrefix.split("/")) {
            if (!(token = token.trim()).startsWith("${") && !token.startsWith("*{")) continue;
            throw new RuntimeException("The path prefix for an HTTP authenticated section can't contain any dynamic parameters: " + token);
        }
        this.getServer().createHttpAuthenticationRealm(pathPrefix, realmName);
    }

    public WebsocketRouteBuilder<R, W> websocket(String path) {
        WebsocketRouteBuilder builder = this.getWebsocketRouteBuilderFactory().create((Router)this);
        builder = builder.path(path);
        return builder;
    }

    public void addWebsocketRoute(WebsocketRoute<R, W> websocketRoute) {
        Route<R> httpRoute = this.createHttpRouteFromWebsocketRoute(websocketRoute);
        this.addRoute(httpRoute);
    }

    protected Route<R> createHttpRouteFromWebsocketRoute(final WebsocketRoute<R, W> websocketRoute) {
        final Handler routeHandler = this.getWebsocketRouteHandlerFactory().createWebsocketRouteHandler(websocketRoute);
        Route httpRoute = new Route<R>(){

            public boolean isWebsocketRoute() {
                return true;
            }

            public String getId() {
                return websocketRoute.getId();
            }

            public boolean isStaticResourceRoute() {
                return false;
            }

            public StaticResource<R> getStaticResource() {
                return null;
            }

            public boolean isSpicastCoreRouteOrPluginRoute() {
                return websocketRoute.isSpicastCoreRouteOrPluginRoute();
            }

            public String getPath() {
                return websocketRoute.getPath();
            }

            public boolean isSkipResourcesRequests() {
                return false;
            }

            public Set<HttpMethod> getHttpMethods() {
                return Sets.newHashSet((Object[])new HttpMethod[]{HttpMethod.GET});
            }

            public Set<String> getAcceptedContentTypes() {
                return null;
            }

            public Set<RoutingType> getRoutingTypes() {
                return Sets.newHashSet((Object[])new RoutingType[]{RoutingType.FOUND});
            }

            public Handler<R> getMainHandler() {
                return routeHandler;
            }

            public List<Handler<R>> getBeforeFilters() {
                return websocketRoute.getBeforeFilters();
            }

            public List<Handler<R>> getAfterFilters() {
                return null;
            }

            public int getPosition() {
                return 0;
            }

            public Set<String> getFilterIdsToSkip() {
                return websocketRoute.getFilterIdsToSkip();
            }

            public Object getSpecs() {
                return null;
            }

            public List<Object> getSpecsParameters() {
                return new ArrayList<Object>();
            }

            public boolean isSpecsIgnore() {
                return false;
            }
        };
        return httpRoute;
    }

    public RedirectRuleBuilder redirect(String oldPath) {
        RedirectRuleBuilder builder = this.getRedirectRuleBuilderFactory().create((Router)this, oldPath);
        return builder;
    }
}

