/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Inject;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.RouteHandlerMatch;
import org.spincast.core.routing.RoutingRequestContextAddon;
import org.spincast.core.routing.RoutingResult;

public class SpincastRoutingRequestContextAddon<R extends RequestContext<R>>
implements RoutingRequestContextAddon<R> {
    private final R requestContext;

    @Inject
    public SpincastRoutingRequestContextAddon(R requestContext) {
        this.requestContext = requestContext;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected RouteHandlerMatch<R> getCurrentRouteMatch() {
        RouteHandlerMatch match = (RouteHandlerMatch)this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.ROUTE_HANDLER_MATCH);
        return match;
    }

    public int getPosition() {
        return this.getCurrentRouteMatch().getPosition();
    }

    public RouteHandlerMatch<R> getCurrentRouteHandlerMatch() {
        return this.getCurrentRouteMatch();
    }

    public RoutingResult<R> getRoutingResult() {
        RoutingResult routingResult = (RoutingResult)this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.ROUTING_RESULT);
        return routingResult;
    }

    public boolean isNotFoundRoute() {
        Boolean isNotFoundRoute = (Boolean)this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.IS_NOT_FOUND_ROUTE, Boolean.class);
        return isNotFoundRoute != null && isNotFoundRoute != false;
    }

    public boolean isExceptionRoute() {
        Boolean isExceptionHandling = (Boolean)this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.IS_EXCEPTION_HANDLING, Boolean.class);
        return isExceptionHandling != null && isExceptionHandling != false;
    }

    public boolean isForwarded() {
        String forwardedUrl = this.getRequestContext().variables().getAsString(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_URL);
        return forwardedUrl != null;
    }
}

