/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.SpincastPluginBase;
import org.spincast.core.routing.Router;
import org.spincast.plugins.routing.SpincastRoutingPluginModule;

public class SpincastRoutingPlugin
extends SpincastPluginBase {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastRoutingPlugin.class);
    public static final String PLUGIN_ID = SpincastRoutingPlugin.class.getName();

    public String getId() {
        return PLUGIN_ID;
    }

    public Module apply(Module module) {
        Class specificRouterImplementationClass = null;
        GuiceModuleUtils guiceModuleUtils = new GuiceModuleUtils(module);
        Set classes = guiceModuleUtils.getBoundClassesExtending(Router.class);
        if (classes.size() > 0) {
            Class temp;
            if (classes.size() > 1) {
                String msg = "More than one custom implementations of " + Router.class.getName() + " has been found. Bindings found :\n";
                for (Class clazz : classes) {
                    msg = msg + "- " + clazz.getName() + "\n";
                }
                throw new RuntimeException(msg);
            }
            specificRouterImplementationClass = temp = (Class)classes.iterator().next();
        }
        Module pluginModule = this.getPluginModule(specificRouterImplementationClass);
        this.setContextTypes(pluginModule);
        module = Modules.override((Module[])new Module[]{module}).with(new Module[]{pluginModule});
        return module;
    }

    protected Module getPluginModule(Class<? extends Router<?, ?>> specificRouterImplementationClass) {
        return new SpincastRoutingPluginModule(specificRouterImplementationClass);
    }
}

