/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.Route;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.routing.StaticResource;

public class RouteDefault<R extends RequestContext<?>>
implements Route<R> {
    private final String id;
    private final boolean isWebsocketRoute;
    private final boolean isResourceRoute;
    private final StaticResource<R> staticResource;
    private final boolean spicastCoreRouteOrPluginRoute;
    private final String path;
    private final Set<HttpMethod> httpMethods;
    private final Set<String> acceptedContentTypes;
    private final Set<RoutingType> routingTypes;
    private final List<Handler<R>> beforeFilters;
    private final Handler<R> mainHandler;
    private final List<Handler<R>> afterFilters;
    private final int position;
    private final Set<String> filterIdsToSkip;
    private final boolean skipResourcesRequests;
    private final Object specs;
    private final List<Object> specsParameters;
    private final boolean specsIgnore;
    private final Set<String> classes;

    @AssistedInject
    public RouteDefault(@Assisted(value="id") @Nullable String id, @Assisted(value="isWebsocketRoute") boolean isWebsocketRoute, @Assisted(value="isResourceRoute") boolean isResourceRoute, @Assisted(value="staticResource") @Nullable StaticResource<R> staticResource, @Assisted(value="isSpicastCoreRouteOrPluginRoute") boolean spicastCoreRouteOrPluginRoute, @Assisted(value="httpMethods") Set<HttpMethod> httpMethods, @Assisted(value="path") String path, @Assisted(value="routingTypes") Set<RoutingType> routingTypes, @Assisted(value="before") @Nullable List<Handler<R>> beforeFilters, @Assisted(value="main") Handler<R> mainHandler, @Assisted(value="after") @Nullable List<Handler<R>> afterFilters, @Assisted(value="position") int position, @Assisted(value="acceptedContentTypes") @Nullable Set<String> acceptedContentTypes, @Assisted(value="filterIdsToSkip") @Nullable Set<String> filterIdsToSkip, @Assisted(value="skipResources") boolean skipResources, @Assisted(value="specs") @Nullable Object specs, @Assisted(value="specsParameters") @Nullable Object[] specsParameters, @Assisted(value="specsIgnore") boolean specsIgnore, @Assisted(value="classes") Set<String> classes) {
        this.id = id;
        this.isWebsocketRoute = isWebsocketRoute;
        this.isResourceRoute = isResourceRoute;
        this.staticResource = staticResource;
        this.spicastCoreRouteOrPluginRoute = spicastCoreRouteOrPluginRoute;
        this.position = position;
        this.httpMethods = httpMethods;
        this.path = path;
        this.routingTypes = routingTypes;
        if (beforeFilters == null) {
            beforeFilters = new ArrayList<Handler<R>>();
        }
        this.beforeFilters = beforeFilters;
        this.mainHandler = mainHandler;
        if (afterFilters == null) {
            afterFilters = new ArrayList<Handler<R>>();
        }
        this.afterFilters = afterFilters;
        if (acceptedContentTypes == null) {
            acceptedContentTypes = new HashSet<String>();
        }
        this.acceptedContentTypes = new HashSet<String>();
        for (String acceptedContentType : acceptedContentTypes) {
            if (acceptedContentType == null) continue;
            this.acceptedContentTypes.add(acceptedContentType.toLowerCase());
        }
        if (filterIdsToSkip == null) {
            filterIdsToSkip = new HashSet<String>();
        }
        this.filterIdsToSkip = filterIdsToSkip;
        this.skipResourcesRequests = skipResources;
        this.specs = specs;
        this.specsParameters = specsParameters != null ? Lists.newArrayList((Object[])specsParameters) : new ArrayList();
        this.specsIgnore = specsIgnore;
        this.classes = classes;
    }

    public Set<HttpMethod> getHttpMethods() {
        return this.httpMethods;
    }

    public Set<String> getAcceptedContentTypes() {
        return this.acceptedContentTypes;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    public boolean isWebsocketRoute() {
        return this.isWebsocketRoute;
    }

    public boolean isStaticResourceRoute() {
        return this.isResourceRoute;
    }

    public StaticResource<R> getStaticResource() {
        return this.staticResource;
    }

    public boolean isSpicastCoreRouteOrPluginRoute() {
        return this.spicastCoreRouteOrPluginRoute;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSkipResourcesRequests() {
        return this.skipResourcesRequests;
    }

    public Set<RoutingType> getRoutingTypes() {
        return this.routingTypes;
    }

    public List<Handler<R>> getBeforeFilters() {
        return this.beforeFilters;
    }

    public Handler<R> getMainHandler() {
        return this.mainHandler;
    }

    public List<Handler<R>> getAfterFilters() {
        return this.afterFilters;
    }

    public int getPosition() {
        return this.position;
    }

    public Set<String> getFilterIdsToSkip() {
        return this.filterIdsToSkip;
    }

    public Object getSpecs() {
        return this.specs;
    }

    public List<Object> getSpecsParameters() {
        return this.specsParameters;
    }

    public boolean isSpecsIgnore() {
        return this.specsIgnore;
    }

    public String toString() {
        return "[" + this.getPosition() + "] " + Arrays.toString(this.getHttpMethods().toArray(new HttpMethod[this.getHttpMethods().size()])) + " " + this.getPath();
    }
}

