/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.Router;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketController;
import org.spincast.core.websocket.WebsocketRoute;
import org.spincast.core.websocket.WebsocketRouteBuilder;
import org.spincast.plugins.routing.WebsocketRouteFactory;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class WebsocketRouteBuilderDefault<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements WebsocketRouteBuilder<R, W> {
    private final WebsocketRouteFactory<R, W> websocketRouteFactory;
    private final Router<R, W> router;
    private String path;
    private String id;
    private Set<String> classes = null;
    private List<Handler<R>> beforeFilters;
    private WebsocketController<R, W> websocketController;
    private Set<String> beforeFilterIdsToSkip;
    private boolean isSpicastCoreRouteOrPluginRoute = false;

    @AssistedInject
    public WebsocketRouteBuilderDefault(WebsocketRouteFactory<R, W> websocketRouteFactory) {
        this(null, websocketRouteFactory);
    }

    @AssistedInject
    public WebsocketRouteBuilderDefault(@Assisted Router<R, W> router, WebsocketRouteFactory<R, W> websocketRouteFactory) {
        this.router = router;
        this.websocketRouteFactory = websocketRouteFactory;
        this.classes = new HashSet<String>();
    }

    protected WebsocketRouteFactory<R, W> getWebsocketRouteFactory() {
        return this.websocketRouteFactory;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    public boolean isSpicastCoreRouteOrPluginRoute() {
        return this.isSpicastCoreRouteOrPluginRoute;
    }

    public Set<String> getBeforeFilterIdsToSkip() {
        if (this.beforeFilterIdsToSkip == null) {
            this.beforeFilterIdsToSkip = new HashSet<String>();
        }
        return this.beforeFilterIdsToSkip;
    }

    public WebsocketController<R, W> getWebsocketController() {
        return this.websocketController;
    }

    public WebsocketRouteBuilder<R, W> path(String path) {
        this.path = path;
        return this;
    }

    public WebsocketRouteBuilder<R, W> id(String id) {
        this.id = id;
        return this;
    }

    public WebsocketRouteBuilder<R, W> classes(String ... classes) {
        if (classes != null) {
            this.classes.addAll(Arrays.asList(classes));
        }
        return this;
    }

    public WebsocketRouteBuilder<R, W> spicastCoreRouteOrPluginRoute() {
        this.isSpicastCoreRouteOrPluginRoute = true;
        return this;
    }

    public WebsocketRouteBuilder<R, W> before(Handler<R> beforeFilter) {
        Objects.requireNonNull(beforeFilter, "beforeFilter can't be NULL");
        this.getBeforeFilters().add(beforeFilter);
        return this;
    }

    public List<Handler<R>> getBeforeFilters() {
        if (this.beforeFilters == null) {
            this.beforeFilters = new ArrayList<Handler<R>>();
        }
        return this.beforeFilters;
    }

    public void handle(WebsocketController<R, W> websocketController) {
        if (this.getRouter() == null) {
            throw new RuntimeException("No router specified, can't save the Websocket route!");
        }
        WebsocketRoute<R, W> websocketRoute = this.create(websocketController);
        this.getRouter().addWebsocketRoute(websocketRoute);
    }

    public WebsocketRoute<R, W> create(WebsocketController<R, W> websocketController) {
        this.websocketController = websocketController;
        WebsocketRoute<R, W> websocketRoute = this.getWebsocketRouteFactory().createRoute(this.isSpicastCoreRouteOrPluginRoute(), this.getId(), this.getPath(), this.getBeforeFilters(), this.getBeforeFilterIdsToSkip(), websocketController, this.getClasses());
        return websocketRoute;
    }

    public WebsocketRouteBuilder<R, W> skip(String beforeFilterId) {
        if (StringUtils.isBlank((CharSequence)beforeFilterId)) {
            throw new RuntimeException("The beforeFilterId can't be empty.");
        }
        this.getBeforeFilterIdsToSkip().add(beforeFilterId);
        return this;
    }
}

