/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.scheduledtasks;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.server.ServerStartedListener;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.scheduledtasks.SpincastScheduledTask;
import org.spincast.plugins.scheduledtasks.SpincastScheduledTaskRegister;

public class SpincastScheduledTaskRegistrerDefault
implements SpincastScheduledTaskRegister,
ServerStartedListener {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastScheduledTaskRegistrerDefault.class);
    private final Set<SpincastScheduledTask> scheduledTasks;
    private final Scheduler scheduler;
    private final SpincastConfig spincastConfig;

    @Inject
    public SpincastScheduledTaskRegistrerDefault(@Nullable Set<SpincastScheduledTask> scheduledTasks, @Nullable Set<Set<SpincastScheduledTask>> scheduledTaskSets, Scheduler scheduler, SpincastConfig spincastConfig) {
        if (scheduledTasks == null) {
            scheduledTasks = new HashSet<SpincastScheduledTask>();
        }
        if (scheduledTaskSets != null) {
            scheduledTasks = new HashSet<SpincastScheduledTask>(scheduledTasks);
            for (Set<SpincastScheduledTask> scheduledTaskJobsSet : scheduledTaskSets) {
                if (scheduledTaskJobsSet == null) continue;
                for (SpincastScheduledTask scheduledTask : scheduledTaskJobsSet) {
                    scheduledTasks.add(scheduledTask);
                }
            }
        }
        this.scheduledTasks = scheduledTasks;
        this.scheduler = scheduler;
        this.spincastConfig = spincastConfig;
    }

    public void serverStartedSuccessfully() {
        if (!this.getSpincastConfig().isTestingMode() || this.registerScheduledTasksInTestingMode()) {
            this.registerBoundedScheduledTasks();
        }
    }

    protected Set<SpincastScheduledTask> getScheduledTasks() {
        return this.scheduledTasks;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    @Override
    public void registerScheduledTask(SpincastScheduledTask scheduledTask) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(scheduledTask.getClass()).withIdentity(scheduledTask.getClass().getSimpleName()).build();
            this.getScheduler().scheduleJob(jobDetail, scheduledTask.getTrigger());
            logger.info("Scheduled Task \"" + scheduledTask.getClass().getSimpleName() + "\" registered.");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public void registerBoundedScheduledTasks() {
        for (SpincastScheduledTask scheduledTask : this.getScheduledTasks()) {
            this.registerScheduledTask(scheduledTask);
        }
    }

    protected boolean registerScheduledTasksInTestingMode() {
        return false;
    }
}

