/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.scheduledtasks;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.plugins.scheduledtasks.SpincastScheduledTask;

public abstract class SpincastScheduledTaskBase
implements SpincastScheduledTask {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastScheduledTaskBase.class);
    private volatile boolean running = false;

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.running) {
            logger.debug("Scheduled Task " + this.getClass().getSimpleName() + " is still running, returning...");
            return;
        }
        this.running = true;
        try {
            logger.debug("Scheduled Task " + this.getClass().getSimpleName() + " starting...");
            this.executeSafe(context);
        }
        finally {
            this.running = false;
            logger.trace("Scheduled Task " + this.getClass().getSimpleName() + " done.");
        }
    }

    @Override
    public abstract Trigger getTrigger();

    protected abstract void executeSafe(JobExecutionContext var1);
}

