/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.session;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.SpincastPluginBase;
import org.spincast.plugins.crons.SpincastCronsPlugin;
import org.spincast.plugins.session.SpincastSessionPluginModule;

public class SpincastSessionPlugin
extends SpincastPluginBase {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastSessionPlugin.class);
    public static final String PLUGIN_ID = SpincastSessionPlugin.class.getName();

    public String getId() {
        return PLUGIN_ID;
    }

    public Module apply(Module module) {
        module = this.applyRequiredPlugins(module);
        Module pluginModule = this.getPluginModule();
        this.setContextTypes(pluginModule);
        module = Modules.override((Module[])new Module[]{module}).with(new Module[]{pluginModule});
        return module;
    }

    protected Module applyRequiredPlugins(Module module) {
        module = this.applySpincastCronsPlugin(module);
        return module;
    }

    protected Module applySpincastCronsPlugin(Module module) {
        SpincastCronsPlugin spincastCronsPlugin = new SpincastCronsPlugin();
        return spincastCronsPlugin.apply(module);
    }

    protected Module getPluginModule() {
        return new SpincastSessionPluginModule();
    }
}

