/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.session;

import com.google.inject.Inject;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.plugins.crons.SpincastCronJobBase;
import org.spincast.plugins.session.SpincastSessionManager;
import org.spincast.plugins.session.config.SpincastSessionConfig;

public class SpincastSessionDeleteOldSessionsCron
extends SpincastCronJobBase {
    protected final Logger logger = LoggerFactory.getLogger(SpincastSessionDeleteOldSessionsCron.class);
    private final SpincastSessionConfig spincastSessionConfig;
    private final SpincastSessionManager spincastSessionManager;

    @Inject
    public SpincastSessionDeleteOldSessionsCron(SpincastSessionConfig spincastSessionConfig, SpincastSessionManager spincastSessionManager) {
        this.spincastSessionConfig = spincastSessionConfig;
        this.spincastSessionManager = spincastSessionManager;
    }

    protected SpincastSessionConfig getSpincastSessionConfig() {
        return this.spincastSessionConfig;
    }

    protected SpincastSessionManager getSpincastSessionManager() {
        return this.spincastSessionManager;
    }

    public Trigger getTrigger() {
        return TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(this.getSpincastSessionConfig().getDeleteOldSessionsCronRunEveryNbrMinutes()).repeatForever()).build();
    }

    public void executeSafe(JobExecutionContext context) {
        this.getSpincastSessionManager().deleteOldInactiveSession(this.getSpincastSessionConfig().getSessionMaxInactiveMinutes());
    }
}

