/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.session.repositories;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.session.SpincastSession;
import org.spincast.plugins.session.SpincastSessionFactory;
import org.spincast.plugins.session.SpincastSessionRepository;
import org.spincast.plugins.session.config.SpincastSessionConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastSessionRepositoryDefault
implements SpincastSessionRepository {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastSessionRepositoryDefault.class);
    private final Provider<RequestContext<?>> requestContextProvider;
    private final SpincastSessionConfig spincastSessionConfig;
    private final SpincastSessionFactory spincastSessionFactory;
    private final JsonManager jsonManager;

    @Inject
    public SpincastSessionRepositoryDefault(Provider<RequestContext<?>> requestContextProvider, SpincastSessionConfig spincastSessionConfig, SpincastSessionFactory spincastSessionFactory, JsonManager jsonManager) {
        this.requestContextProvider = requestContextProvider;
        this.spincastSessionConfig = spincastSessionConfig;
        this.spincastSessionFactory = spincastSessionFactory;
        this.jsonManager = jsonManager;
    }

    protected Provider<RequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    protected SpincastSessionConfig getSpincastSessionConfig() {
        return this.spincastSessionConfig;
    }

    protected SpincastSessionFactory getSpincastSessionFactory() {
        return this.spincastSessionFactory;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    @Override
    public SpincastSession getSession(String sessionId) {
        String sessionValue = null;
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            sessionValue = context.request().getCookieValue(this.getSpincastSessionConfig().getDefaultCookieRepositoryCookieName());
        }
        catch (OutOfScopeException | ProvisionException ex) {
            logger.info("We can't get the session as there is no RequestContext...");
        }
        SpincastSession spincastSession = this.deserializeSession(sessionValue);
        if (spincastSession.getModificationDate() != null && spincastSession.getModificationDate().isBefore(Instant.now().minus(this.getSpincastSessionConfig().getSessionMaxInactiveMinutes(), ChronoUnit.MINUTES))) {
            this.deleteSession(null);
            spincastSession = this.createNewSpincastSession();
        }
        return spincastSession;
    }

    @Override
    public void saveSession(SpincastSession session) {
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            String serializedSession = this.serializeSession(session);
            if (!StringUtils.isBlank((CharSequence)serializedSession)) {
                context.response().setCookie10years(this.getSpincastSessionConfig().getDefaultCookieRepositoryCookieName(), serializedSession);
            } else {
                context.response().deleteCookie(this.getSpincastSessionConfig().getDefaultCookieRepositoryCookieName());
            }
        }
        catch (OutOfScopeException | ProvisionException ex) {
            logger.info("We can't save the session as there is no RequestContext...");
        }
    }

    @Override
    public void deleteSession(String sessionId) {
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            context.response().deleteCookie(this.getSpincastSessionConfig().getDefaultCookieRepositoryCookieName());
        }
        catch (OutOfScopeException | ProvisionException ex) {
            logger.info("We can't delete the session as there is no RequestContext...");
        }
    }

    @Override
    public void deleteOldInactiveSession(int sessionMaxInactiveMinutes) {
    }

    protected String serializeSession(SpincastSession session) {
        if (session == null) {
            return "";
        }
        JsonObject attributes = session.getAttributes();
        if (attributes == null) {
            return "";
        }
        try {
            attributes.set(this.getSessionAttributeNameId(), (Object)session.getId().toString());
            attributes.set(this.getSessionAttributeNameCreationDate(), (Object)session.getCreationDate().toString());
            attributes.set(this.getSessionAttributeNameModificationDate(), (Object)session.getModificationDate().toString());
            String val = attributes.toJsonString(false);
            return val;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected SpincastSession deserializeSession(String sessionValue) {
        Instant modificationDate;
        JsonObject attributes = null;
        if (!StringUtils.isBlank((CharSequence)sessionValue)) {
            try {
                attributes = this.getJsonManager().fromString(sessionValue);
            }
            catch (Exception ex) {
                logger.warn("Unable to deserialize session: " + sessionValue);
            }
        }
        if (attributes == null) {
            return this.createNewSpincastSession();
        }
        String sessionId = attributes.getString(this.getSessionAttributeNameId());
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = UUID.randomUUID().toString();
        }
        Instant now = Instant.now();
        Instant creationDate = attributes.getInstant(this.getSessionAttributeNameCreationDate());
        if (creationDate == null) {
            creationDate = now;
        }
        if ((modificationDate = attributes.getInstant(this.getSessionAttributeNameModificationDate())) == null) {
            modificationDate = now;
        }
        attributes.remove(this.getSessionAttributeNameId());
        attributes.remove(this.getSessionAttributeNameCreationDate());
        attributes.remove(this.getSessionAttributeNameModificationDate());
        SpincastSession spincastSession = this.getSpincastSessionFactory().createSession(sessionId, creationDate, modificationDate, attributes);
        return spincastSession;
    }

    protected SpincastSession createNewSpincastSession() {
        Instant now = Instant.now();
        SpincastSession newSession = this.getSpincastSessionFactory().createSession(UUID.randomUUID().toString(), now, now, this.getJsonManager().create());
        return newSession;
    }

    protected String getSessionAttributeNameId() {
        return "_sid";
    }

    protected String getSessionAttributeNameCreationDate() {
        return "_cdate";
    }

    protected String getSessionAttributeNameModificationDate() {
        return "_mdate";
    }
}

