/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.session;

import com.google.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import org.spincast.core.exchange.RequestContext;
import org.spincast.plugins.session.SpincastSession;
import org.spincast.plugins.session.SpincastSessionFilter;
import org.spincast.plugins.session.SpincastSessionManager;
import org.spincast.plugins.session.SpincastSessionManagerDefault;
import org.spincast.plugins.session.config.SpincastSessionConfig;

public class SpincastSessionFilterDefault
implements SpincastSessionFilter {
    private final SpincastSessionManager spincastSessionManager;
    private final SpincastSessionConfig spincastSessionConfig;

    @Inject
    public SpincastSessionFilterDefault(SpincastSessionManager spincastSessionManager, SpincastSessionConfig spincastSessionConfig) {
        this.spincastSessionManager = spincastSessionManager;
        this.spincastSessionConfig = spincastSessionConfig;
    }

    protected SpincastSessionManager getSpincastSessionManager() {
        return this.spincastSessionManager;
    }

    protected SpincastSessionConfig getSpincastSessionConfig() {
        return this.spincastSessionConfig;
    }

    @Override
    public void before(RequestContext<?> context) {
        if (context.routing().getRoutingResult().getMainRouteHandlerMatch().getSourceRoute().isStaticResourceRoute()) {
            return;
        }
        SpincastSession session = null;
        String sessionId = this.getSessionIdFromUserRequest(context);
        if (sessionId != null) {
            session = this.getSpincastSessionManager().getSavedSession(sessionId);
            if (session != null) {
                if (session.isNew() || session.isDirty()) {
                    session = this.getSpincastSessionManager().createSession(session.getId(), session.getCreationDate(), session.getModificationDate(), session.getAttributes());
                    session.setDirty();
                }
            } else {
                this.getSpincastSessionManager().deleteSessionIdOnUser();
            }
        }
        if (session == null) {
            session = this.getSpincastSessionManager().createNewSession();
        }
        context.variables().set(SpincastSessionManagerDefault.REQUEST_CONTEXT_VARIABLE_SESSION, (Object)session);
    }

    @Override
    public void after(RequestContext<?> context) {
        if (context.routing().getRoutingResult().getMainRouteHandlerMatch().getSourceRoute().isStaticResourceRoute()) {
            return;
        }
        SpincastSession session = (SpincastSession)context.variables().get(SpincastSessionManagerDefault.REQUEST_CONTEXT_VARIABLE_SESSION, SpincastSession.class);
        if (session == null) {
            return;
        }
        if (session.isInvalidated()) {
            this.getSpincastSessionManager().deleteSessionIdOnUser();
            this.getSpincastSessionManager().deleteSession(session.getId());
            return;
        }
        if (session.isDirty() || this.isUpdateModificationDateEvenIfNotDirty(session)) {
            this.getSpincastSessionManager().updateModificationDateAndSaveSession(session);
            if (session.isNew()) {
                this.getSpincastSessionManager().saveSessionIdOnUser(session.getId(), this.getSpincastSessionConfig().isSessionPermanentByDefault());
            }
        }
    }

    protected boolean isUpdateModificationDateEvenIfNotDirty(SpincastSession session) {
        if (session.isNew()) {
            return false;
        }
        Duration timeFromLastTimeSaved = Duration.between(session.getModificationDate(), Instant.now());
        return timeFromLastTimeSaved.getSeconds() > (long)this.getSpincastSessionConfig().getUpdateNotDirtySessionPeriodInSeconds();
    }

    protected String getSessionIdFromUserRequest(RequestContext<?> context) {
        return context.request().getCookieValue(this.getSpincastSessionConfig().getSessionIdCookieName());
    }
}

