/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.session;

import com.google.inject.Inject;
import org.spincast.core.routing.Router;
import org.spincast.plugins.session.SpincastSessionFilter;
import org.spincast.plugins.session.config.SpincastSessionConfig;

public class SpincastSessionFilterAdder {
    private final SpincastSessionConfig spincastSessionConfig;
    private final Router<?, ?> router;
    private final SpincastSessionFilter spincastSessionFilter;

    @Inject
    public SpincastSessionFilterAdder(SpincastSessionConfig spincastSessionConfig, Router<?, ?> router, SpincastSessionFilter spincastSessionFilter) {
        this.spincastSessionConfig = spincastSessionConfig;
        this.router = router;
        this.spincastSessionFilter = spincastSessionFilter;
    }

    protected SpincastSessionConfig getSpincastSessionConfig() {
        return this.spincastSessionConfig;
    }

    protected Router<?, ?> getRouter() {
        return this.router;
    }

    protected SpincastSessionFilter getSpincastSessionFilter() {
        return this.spincastSessionFilter;
    }

    @Inject
    protected void init() {
        if (this.getSpincastSessionConfig().isAutoAddSessionFilters()) {
            this.addFilters();
        }
    }

    protected void addFilters() {
        int beforePos = this.getSpincastSessionConfig().getAutoAddedFilterBeforePosition();
        if (beforePos >= 0) {
            throw new RuntimeException("Invalid position for the before Session filter. Must be negative: " + beforePos);
        }
        int afterPos = this.getSpincastSessionConfig().getAutoAddedFilterAfterPosition();
        if (afterPos <= 0) {
            throw new RuntimeException("Invalid position for the after Session filter. Must be positive: " + afterPos);
        }
        this.getRouter().ALL().pos(beforePos).id("sessionBeforeFilter").spicastCoreRouteOrPluginRoute().skipResourcesRequests().handle(context -> this.getSpincastSessionFilter().before(context));
        this.getRouter().ALL().pos(afterPos).id("sessionAfterFilter").spicastCoreRouteOrPluginRoute().skipResourcesRequests().handle(context -> this.getSpincastSessionFilter().after(context));
    }
}

