/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.session;

import com.google.inject.Inject;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.plugins.scheduledtasks.SpincastScheduledTaskBase;
import org.spincast.plugins.session.SpincastSessionManager;
import org.spincast.plugins.session.config.SpincastSessionConfig;

public class SpincastSessionDeleteOldSessionsScheduledTask
extends SpincastScheduledTaskBase {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastSessionDeleteOldSessionsScheduledTask.class);
    private final SpincastSessionConfig spincastSessionConfig;
    private final SpincastSessionManager spincastSessionManager;

    @Inject
    public SpincastSessionDeleteOldSessionsScheduledTask(SpincastSessionConfig spincastSessionConfig, SpincastSessionManager spincastSessionManager) {
        this.spincastSessionConfig = spincastSessionConfig;
        this.spincastSessionManager = spincastSessionManager;
    }

    protected SpincastSessionConfig getSpincastSessionConfig() {
        return this.spincastSessionConfig;
    }

    protected SpincastSessionManager getSpincastSessionManager() {
        return this.spincastSessionManager;
    }

    public Trigger getTrigger() {
        return TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(this.getSpincastSessionConfig().getDeleteOldSessionsScheduledTaskRunEveryNbrMinutes()).repeatForever()).build();
    }

    public void executeSafe(JobExecutionContext context) {
        this.getSpincastSessionManager().deleteOldInactiveSession(this.getSpincastSessionConfig().getSessionMaxInactiveMinutes());
    }
}

