/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.session;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.time.Instant;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.cookies.CookieSameSite;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.plugins.session.SpincastSession;
import org.spincast.plugins.session.SpincastSessionFactory;
import org.spincast.plugins.session.SpincastSessionManager;
import org.spincast.plugins.session.SpincastSessionRepository;
import org.spincast.plugins.session.config.SpincastSessionConfig;

public class SpincastSessionManagerDefault
implements SpincastSessionManager {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastSessionManagerDefault.class);
    public static final String REQUEST_CONTEXT_VARIABLE_SESSION = SpincastSessionManagerDefault.class.getName() + "_session";
    private final SpincastSessionFactory spincastSessionFactory;
    private final Provider<RequestContext<?>> requestContextProvider;
    private final JsonManager jsonManager;
    private final SpincastSessionConfig spincastSessionConfig;
    private final SpincastSessionRepository spincastSessionRepository;
    private final CookieFactory cookieFactory;
    private final SpincastConfig spincastConfig;

    @Inject
    public SpincastSessionManagerDefault(SpincastSessionFactory spincastSessionFactory, Provider<RequestContext<?>> requestContextProvider, JsonManager jsonManager, SpincastSessionConfig spincastSessionConfig, SpincastSessionRepository spincastSessionRepository, CookieFactory cookieFactory, SpincastConfig spincastConfig) {
        this.spincastSessionFactory = spincastSessionFactory;
        this.requestContextProvider = requestContextProvider;
        this.jsonManager = jsonManager;
        this.spincastSessionConfig = spincastSessionConfig;
        this.spincastSessionRepository = spincastSessionRepository;
        this.cookieFactory = cookieFactory;
        this.spincastConfig = spincastConfig;
    }

    protected SpincastSessionFactory getSpincastSessionFactory() {
        return this.spincastSessionFactory;
    }

    protected Provider<RequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected SpincastSessionConfig getSpincastSessionConfig() {
        return this.spincastSessionConfig;
    }

    protected SpincastSessionRepository getSpincastSessionRepository() {
        return this.spincastSessionRepository;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    @Override
    public SpincastSession createNewSession() {
        return this.getSpincastSessionFactory().createNewSession();
    }

    @Override
    public SpincastSession createSession(String sessionId, Instant creationDate, Instant modificationDate, JsonObject attributes) {
        return this.getSpincastSessionFactory().createSession(sessionId, creationDate, modificationDate, attributes);
    }

    @Override
    public SpincastSession getCurrentSession() {
        SpincastSession session = null;
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            session = (SpincastSession)context.variables().get(REQUEST_CONTEXT_VARIABLE_SESSION);
            if (session == null) {
                logger.error("No session found in request context variables. Make sure the filters provided by the Spincast Session plugin have been added properly to your router!");
            }
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            // empty catch block
        }
        return session;
    }

    @Override
    public String generateNewSessionId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void deleteSessionIdOnUser() {
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            context.response().deleteCookie(this.getSpincastSessionConfig().getSessionIdCookieName());
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            // empty catch block
        }
    }

    @Override
    public void saveSessionIdOnUser(String sessionId, boolean permanent) {
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            this.saveSessionIdOnUser(context, sessionId, permanent);
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            // empty catch block
        }
    }

    protected void saveSessionIdOnUser(RequestContext<?> context, String sessionId, boolean permanent) {
        Cookie sessionCookie = this.getCookieFactory().createCookie(this.getSpincastSessionConfig().getSessionIdCookieName(), sessionId);
        sessionCookie.setSecure(this.getSpincastConfig().getHttpsServerPort() > 0);
        sessionCookie.setHttpOnly(true);
        sessionCookie.setSameSite(CookieSameSite.LAX);
        if (permanent) {
            sessionCookie.setExpiresUsingMaxAge(31536000);
        }
        context.response().setCookie(sessionCookie);
    }

    @Override
    public final void updateModificationDateAndSaveSession(SpincastSession session) {
        SpincastSession updatedSsession = this.createSession(session.getId(), session.getCreationDate(), Instant.now(), session.getAttributes());
        this.saveSession(updatedSsession);
    }

    @Override
    public void deleteCurrentSession() {
        SpincastSession currentSession = this.getCurrentSession();
        if (currentSession != null) {
            currentSession.invalidate();
            this.deleteSessionIdOnUser();
            this.deleteSession(currentSession.getId());
        }
    }

    @Override
    public SpincastSession getSavedSession(String sessionId) {
        return this.getSpincastSessionRepository().getSession(sessionId);
    }

    @Override
    public void saveSession(SpincastSession session) {
        this.getSpincastSessionRepository().saveSession(session);
    }

    @Override
    public void deleteSession(String sessionId) {
        this.getSpincastSessionRepository().deleteSession(sessionId);
    }

    @Override
    public void deleteOldInactiveSession(int sessionMaxInactiveMinutes) {
        this.getSpincastSessionRepository().deleteOldInactiveSession(sessionMaxInactiveMinutes);
    }
}

