/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.swagger.ui;

import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Files;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.Router;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.swagger.ui.config.SpincastSwaggerUiConfig;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class SpincastSwaggerUiManager {
    private final Router<?, ?> router;
    private final SpincastUtils spincastUtils;
    private final SpincastConfig spincastConfig;
    private final TemplatingEngine templatingEngine;
    private final SpincastSwaggerUiConfig spincastSwaggerUiConfig;

    @Inject
    public SpincastSwaggerUiManager(Router<?, ?> router, SpincastUtils spincastUtils, SpincastSwaggerUiConfig spincastSwaggerUiConfig, TemplatingEngine templatingEngine, SpincastConfig spincastConfig) {
        this.router = router;
        this.spincastUtils = spincastUtils;
        this.spincastSwaggerUiConfig = spincastSwaggerUiConfig;
        this.templatingEngine = templatingEngine;
        this.spincastConfig = spincastConfig;
    }

    @Inject
    public void init() {
        this.serverSwaggerUi();
    }

    protected Router<?, ?> getRouter() {
        return this.router;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected TemplatingEngine getTemplatingEngine() {
        return this.templatingEngine;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastSwaggerUiConfig getSpincastSwaggerUiConfig() {
        return this.spincastSwaggerUiConfig;
    }

    protected void serverSwaggerUi() {
        final String swaggerUiFilesRoot = this.getSpincastConfig().getTempDir() + "/plugins/swagger-ui";
        this.getRouter().dir(this.getSpincastSwaggerUiConfig().getSwaggerUiPath()).pathAbsolute(swaggerUiFilesRoot).handle(new Handler<RequestContext<?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(RequestContext<?> context) {
                try {
                    byte[] bytes;
                    String absolutePath = context.request().getRequestPath();
                    String path = absolutePath.substring(SpincastSwaggerUiManager.this.getSpincastSwaggerUiConfig().getSwaggerUiPath().length());
                    File index = new File(swaggerUiFilesRoot + "/index.html");
                    if (!index.exists()) {
                        1 var5_6 = this;
                        synchronized (var5_6) {
                            if (!index.exists()) {
                                SpincastSwaggerUiManager.this.getSpincastUtils().copyClasspathDirToFileSystem("/spincast/plugins/swagger-ui", new File(swaggerUiFilesRoot));
                                File indexFile = new File(swaggerUiFilesRoot, "index.html");
                                String specsUrl = SpincastSwaggerUiManager.this.getSpincastSwaggerUiConfig().getOpenApiSpecificationsUrl();
                                String content = FileUtils.readFileToString((File)indexFile, (String)"UTF-8");
                                content = content.replace("https://petstore.swagger.io/v2/swagger.json", specsUrl);
                                if (!SpincastSwaggerUiManager.this.getSpincastSwaggerUiConfig().showTopBar()) {
                                    content = content.replace("layout: \"StandaloneLayout\"", "layout: \"BaseLayout\"");
                                }
                                FileUtils.write((File)indexFile, (CharSequence)content, (String)"UTF-8");
                            }
                        }
                    }
                    boolean isIndex = path.equals("") || path.equals("/") || path.equals("/index.html");
                    File toSend = new File(swaggerUiFilesRoot + (isIndex ? "/index.html" : path));
                    String mimeTypeFromPath = ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset();
                    if (!isIndex) {
                        mimeTypeFromPath = SpincastSwaggerUiManager.this.getSpincastUtils().getMimeTypeFromPath(path);
                    }
                    try {
                        bytes = Files.readAllBytes(toSend.toPath());
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize((Exception)ex);
                    }
                    context.response().sendBytes(bytes, mimeTypeFromPath);
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize((Exception)ex);
                }
            }
        });
    }
}

