/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.timezoneresolver;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.timezone.TimeZoneResolver;

public class TimeZoneResolverDefault
implements TimeZoneResolver {
    private final SpincastConfig spincastConfig;
    private final Provider<RequestContext<?>> requestContextProvider;
    private final Set<String> validTimeZoneIds;
    private TimeZone defaultTimeZone;

    @Inject
    public TimeZoneResolverDefault(SpincastConfig spincastConfig, Provider<RequestContext<?>> requestContextProvider) {
        this.spincastConfig = spincastConfig;
        this.requestContextProvider = requestContextProvider;
        this.validTimeZoneIds = new HashSet<String>();
    }

    @Inject
    protected void init() {
        String[] availableIDs;
        this.defaultTimeZone = this.getSpincastConfig().getDefaultTimeZone();
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = TimeZone.getTimeZone("UTC");
        }
        for (String availableID : availableIDs = TimeZone.getAvailableIDs()) {
            this.validTimeZoneIds.add(availableID);
        }
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Provider<RequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    protected Set<String> getValidTimeZoneIds() {
        return this.validTimeZoneIds;
    }

    protected TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public TimeZone getTimeZoneToUse() {
        try {
            RequestContext context = (RequestContext)this.getRequestContextProvider().get();
            String cookieValue = context.request().getCookie(this.getSpincastConfig().getCookieNameTimeZoneId());
            if (cookieValue != null && this.getValidTimeZoneIds().contains(cookieValue)) {
                return TimeZone.getTimeZone(cookieValue);
            }
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            // empty catch block
        }
        return this.getDefaultTimeZone();
    }
}

