/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.Inject;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.controllers.IFrontController;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceCorsConfig;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.undertow.FileClassPathResourceManager;
import org.spincast.plugins.undertow.GzipCheckerHandler;
import org.spincast.plugins.undertow.ISSLContextManager;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.commonjava.mimeparse.MIMEParse;

public class SpincastUndertowServer
implements IServer {
    protected final Logger logger = LoggerFactory.getLogger(SpincastUndertowServer.class);
    public static final String UNDERTOW_EXCEPTION_CODE_REQUEST_TOO_LARGE = "UT000020";
    protected static final HttpString HTTPSTRING_GET = new HttpString("GET");
    protected static final HttpString HTTPSTRING_HEAD = new HttpString("HEAD");
    protected static final HttpString HTTPSTRING_VARY = new HttpString("Vary");
    protected static final HttpString HTTPSTRING_ACCESS_CONTROL_ALLOW_ORIGIN = new HttpString("Access-Control-Allow-Origin");
    protected static final HttpString HTTPSTRING_ACCESS_CONTROL_ALLOW_CREDENTIALS = new HttpString("Access-Control-Allow-Credentials");
    protected static final HttpString HTTPSTRING_ACCESS_CONTROL_EXPOSE_HEADERS = new HttpString("Access-Control-Expose-Headers");
    private final ISpincastUtils spincastUtils;
    private final ISpincastConfig config;
    private final IFrontController frontController;
    private final ICookieFactory cookieFactory;
    private final ISSLContextManager sslContextManager;
    private Undertow undertowServer;
    private IoCallback doNothingCallback = null;
    private IoCallback closeExchangeCallback = null;
    private final Map<String, IStaticResource<?>> staticResourcesServedByUrlPath = new HashMap();
    private HttpHandler spincastFrontControllerHandler;
    private PathHandler staticResourcesPathHandler;
    private FormParserFactory formParserFactory;

    @Inject
    public SpincastUndertowServer(ISpincastConfig config, IFrontController frontController, ISpincastUtils spincastUtils, ICookieFactory cookieFactory, ISSLContextManager sslContextManager) {
        this.config = config;
        this.frontController = frontController;
        this.spincastUtils = spincastUtils;
        this.cookieFactory = cookieFactory;
        this.sslContextManager = sslContextManager;
    }

    protected ISpincastConfig getConfig() {
        return this.config;
    }

    protected IFrontController getFrontController() {
        return this.frontController;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ICookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected ISSLContextManager getSslContextManager() {
        return this.sslContextManager;
    }

    protected Map<String, IStaticResource<?>> getStaticResourcesServedByUrlPath() {
        return this.staticResourcesServedByUrlPath;
    }

    protected FormParserFactory getFormParserFactory() {
        if (this.formParserFactory == null) {
            this.formParserFactory = FormParserFactory.builder().build();
        }
        return this.formParserFactory;
    }

    public void start() {
        this.undertowServer = this.getServerBuilder().build();
        this.undertowServer.start();
        if (this.getConfig().getHttpServerPort() > 0) {
            this.logger.info("HTTP server started on host/ip \"" + this.getConfig().getServerHost() + "\", port " + this.getConfig().getHttpServerPort());
        }
        if (this.getConfig().getHttpsServerPort() > 0) {
            this.logger.info("HTTPS server started on host/ip \"" + this.getConfig().getServerHost() + "\", port " + this.getConfig().getHttpsServerPort());
        }
    }

    protected Undertow.Builder getServerBuilder() {
        try {
            String serverHost = this.getConfig().getServerHost();
            int httpServerPort = this.getConfig().getHttpServerPort();
            int httpsServerPort = this.getConfig().getHttpsServerPort();
            if (httpServerPort <= 0 && httpsServerPort <= 0) {
                throw new RuntimeException("At least one of the HTTP or HTTPS port must be greater than 0 to start the server....");
            }
            Undertow.Builder builder = Undertow.builder().setHandler(this.getFinalHandler());
            if (httpServerPort > 0) {
                this.addHttpListener(builder, serverHost, httpServerPort);
            }
            if (httpsServerPort > 0) {
                this.addHttpsListener(builder, serverHost, httpsServerPort);
            }
            builder = this.addBuilderOptions(builder);
            return builder;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void addHttpListener(Undertow.Builder builder, String serverHost, int httpServerPort) {
        builder = builder.addHttpListener(httpServerPort, serverHost);
    }

    protected void addHttpsListener(Undertow.Builder builder, String serverHost, int httpsServerPort) {
        try {
            SSLContext sslContext = this.getSslContextManager().getSSLContext();
            builder = builder.addHttpsListener(httpsServerPort, serverHost, sslContext);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected Undertow.Builder addBuilderOptions(Undertow.Builder builder) {
        builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)this.getConfig().getServerMaxRequestBodyBytes());
        return builder;
    }

    protected HttpHandler getFinalHandler() {
        return this.getStaticResourcesPathHandler();
    }

    protected HttpHandler getSpincastFrontControllerHandler() {
        if (this.spincastFrontControllerHandler == null) {
            this.spincastFrontControllerHandler = new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    if (exchange.isInIoThread()) {
                        exchange.dispatch((HttpHandler)this);
                        return;
                    }
                    SpincastUndertowServer.this.getFrontController().handle((Object)exchange);
                }
            };
        }
        return this.spincastFrontControllerHandler;
    }

    public void stop() {
        if (this.undertowServer != null) {
            try {
                this.undertowServer.stop();
            }
            catch (Exception ex) {
                this.logger.warn("Error stopping the Undertow server :\n" + SpincastStatics.getStackTrace((Throwable)ex));
            }
        }
    }

    protected PathHandler getStaticResourcesPathHandler() {
        if (this.staticResourcesPathHandler == null) {
            this.staticResourcesPathHandler = new PathHandler(this.getSpincastFrontControllerHandler());
        }
        return this.staticResourcesPathHandler;
    }

    public void addStaticResourceToServe(IStaticResource<?> staticResource) {
        Map<String, IStaticResource<?>> staticResourcesServedByUrlPath = this.getStaticResourcesServedByUrlPath();
        StaticResourceType staticResourceType = staticResource.getStaticResourceType();
        if (staticResourcesServedByUrlPath.containsKey(staticResource.getUrlPath())) {
            this.getStaticResourcesPathHandler().removeExactPath(staticResource.getUrlPath());
            this.getStaticResourcesPathHandler().removePrefixPath(staticResource.getUrlPath());
        }
        staticResourcesServedByUrlPath.put(staticResource.getUrlPath(), staticResource);
        if (staticResourceType == StaticResourceType.FILE) {
            File file = new File(staticResource.getResourcePath());
            if (!file.isFile() && !staticResource.isCanBeGenerated()) {
                throw new RuntimeException("The file doesn't exist and can't be generated so it can't be served : " + staticResource.getResourcePath());
            }
            ResponseCodeHandler next = staticResource.isCanBeGenerated() ? this.getSpincastFrontControllerHandler() : ResponseCodeHandler.HANDLE_404;
            ResourceHandler resourceHandler = new ResourceHandler((ResourceManager)new FileResourceManager(file, 1024L), (HttpHandler)next);
            GzipCheckerHandler gzipCheckerHandler = new GzipCheckerHandler((HttpHandler)resourceHandler, this.getSpincastUtils());
            CorsHandler corsHandler = new CorsHandler(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addExactPath(staticResource.getUrlPath(), (HttpHandler)corsHandler);
        } else if (staticResourceType == StaticResourceType.FILE_FROM_CLASSPATH) {
            String classpathPath = staticResource.getResourcePath();
            if (classpathPath == null) {
                classpathPath = "";
            } else if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            ResourceHandler resourceHandler = new ResourceHandler((ResourceManager)new FileClassPathResourceManager(classpathPath));
            GzipCheckerHandler gzipCheckerHandler = new GzipCheckerHandler((HttpHandler)resourceHandler, this.getSpincastUtils());
            CorsHandler corsHandler = new CorsHandler(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addExactPath(staticResource.getUrlPath(), (HttpHandler)corsHandler);
        } else if (staticResourceType == StaticResourceType.DIRECTORY) {
            File dir = new File(staticResource.getResourcePath());
            if (!dir.isDirectory() && !staticResource.isCanBeGenerated()) {
                throw new RuntimeException("The directory doesn't exist and can't be generated so it can't be served : " + staticResource.getResourcePath());
            }
            ResponseCodeHandler next = staticResource.isCanBeGenerated() ? this.getSpincastFrontControllerHandler() : ResponseCodeHandler.HANDLE_404;
            ResourceHandler resourceHandler = new ResourceHandler((ResourceManager)new FileResourceManager(dir, 1024L), (HttpHandler)next);
            GzipCheckerHandler gzipCheckerHandler = new GzipCheckerHandler((HttpHandler)resourceHandler, this.getSpincastUtils());
            CorsHandler corsHandler = new CorsHandler(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addPrefixPath(staticResource.getUrlPath(), (HttpHandler)corsHandler);
        } else if (staticResourceType == StaticResourceType.DIRECTORY_FROM_CLASSPATH) {
            String classpathPath = staticResource.getResourcePath();
            if (classpathPath == null) {
                classpathPath = "";
            } else if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            ResourceHandler resourceHandler = new ResourceHandler((ResourceManager)new ClassPathResourceManager(SpincastUndertowServer.class.getClassLoader(), classpathPath));
            GzipCheckerHandler gzipCheckerHandler = new GzipCheckerHandler((HttpHandler)resourceHandler, this.getSpincastUtils());
            CorsHandler corsHandler = new CorsHandler(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addPrefixPath(staticResource.getUrlPath(), (HttpHandler)corsHandler);
        } else {
            throw new RuntimeException("Unamanaged static resource stype : " + staticResourceType);
        }
    }

    public void removeStaticResourcesServed(StaticResourceType staticResourceType, String urlPath) {
        if (this.staticResourcesServedByUrlPath.containsKey(urlPath)) {
            this.removeStaticResource(staticResourceType, urlPath);
        }
    }

    public void removeAllStaticResourcesServed() {
        for (Map.Entry<String, IStaticResource<?>> entry : this.getStaticResourcesServedByUrlPath().entrySet()) {
            String urlPath = entry.getKey();
            IStaticResource<?> staticResource = entry.getValue();
            this.removeStaticResource(staticResource.getStaticResourceType(), urlPath);
        }
    }

    protected void removeStaticResource(StaticResourceType staticResourceType, String urlPath) {
        if (staticResourceType == StaticResourceType.FILE || staticResourceType == StaticResourceType.FILE_FROM_CLASSPATH) {
            this.getStaticResourcesPathHandler().removeExactPath(urlPath);
        } else if (staticResourceType == StaticResourceType.DIRECTORY || staticResourceType == StaticResourceType.DIRECTORY_FROM_CLASSPATH) {
            this.getStaticResourcesPathHandler().removePrefixPath(urlPath);
        } else {
            throw new RuntimeException("Unamanaged static resource stype : " + staticResourceType);
        }
    }

    public IStaticResource<?> getStaticResourceServed(String urlPath) {
        return this.getStaticResourcesServedByUrlPath().get(urlPath);
    }

    public Set<IStaticResource<?>> getStaticResourcesServed() {
        return new HashSet(this.getStaticResourcesServedByUrlPath().values());
    }

    public HttpMethod getHttpMethod(Object exchange) {
        HttpString httpString = ((HttpServerExchange)exchange).getRequestMethod();
        return HttpMethod.fromStringValue((String)httpString.toString());
    }

    protected HttpServerExchange castExchange(Object exchange) {
        return (HttpServerExchange)exchange;
    }

    public ContentTypeDefaults getContentTypeBestMatch(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        ContentTypeDefaults type = ContentTypeDefaults.TEXT;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        if (requestHeaders != null) {
            String bestMatch;
            String requestedWith = requestHeaders.getFirst("X-Requested-With");
            if ("XMLHttpRequest".equalsIgnoreCase(requestedWith)) {
                return ContentTypeDefaults.JSON;
            }
            String accept = requestHeaders.getFirst("Accept");
            if (accept != null && !StringUtils.isBlank((CharSequence)(bestMatch = MIMEParse.bestMatch((Collection)ContentTypeDefaults.getAllContentTypesVariations(), (String)accept))) && (type = ContentTypeDefaults.fromString((String)bestMatch)) == null) {
                this.logger.error("Not supposed : " + bestMatch);
                type = ContentTypeDefaults.TEXT;
            }
        }
        return type;
    }

    public String getFullUrl(Object exchangeObj) {
        try {
            HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
            String queryString = exchange.getQueryString();
            queryString = StringUtils.isBlank((CharSequence)queryString) ? "" : "?" + queryString;
            return exchange.getRequestURL() + queryString;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public void setResponseHeader(Object exchangeObj, String name, List<String> values) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HeaderMap responseHeaderMap = exchange.getResponseHeaders();
        responseHeaderMap.putAll(new HttpString(name), values);
    }

    public void setResponseHeaders(Object exchange, Map<String, List<String>> headers) {
        HeaderMap responseHeaderMap = ((HttpServerExchange)exchange).getResponseHeaders();
        responseHeaderMap.clear();
        if (headers == null || headers.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            responseHeaderMap.putAll(new HttpString(entry.getKey()), (Collection)entry.getValue());
        }
    }

    public Map<String, List<String>> getResponseHeaders(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (responseHeaders != null) {
            for (HeaderValues responseHeader : responseHeaders) {
                HttpString headerNameObj = responseHeader.getHeaderName();
                if (headerNameObj == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                for (String value : responseHeader) {
                    values.add(value);
                }
                headers.put(headerNameObj.toString(), values);
            }
        }
        return headers;
    }

    public void removeResponseHeader(Object exchange, String name) {
        HeaderMap responseHeaderMap = ((HttpServerExchange)exchange).getResponseHeaders();
        responseHeaderMap.remove(new HttpString(name));
    }

    public void setResponseStatusCode(Object exchange, int statusCode) {
        ((HttpServerExchange)exchange).setResponseCode(statusCode);
    }

    protected IoCallback getDoNothingCallback() {
        if (this.doNothingCallback == null) {
            this.doNothingCallback = new IoCallback(){

                public void onComplete(HttpServerExchange exchange, Sender sender) {
                    System.out.println();
                }

                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                    throw new RuntimeException(exception);
                }
            };
        }
        return this.doNothingCallback;
    }

    protected IoCallback getCloseExchangeCallback() {
        if (this.closeExchangeCallback == null) {
            this.closeExchangeCallback = new IoCallback(){

                public void onComplete(HttpServerExchange exchange, Sender sender) {
                    sender.close();
                    SpincastUndertowServer.this.end(exchange);
                }

                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                    throw new RuntimeException(exception);
                }
            };
        }
        return this.closeExchangeCallback;
    }

    public void flushBytes(Object exchange, byte[] bytes, boolean end) {
        Sender responseSender = ((HttpServerExchange)exchange).getResponseSender();
        IoCallback callback = end ? this.getCloseExchangeCallback() : this.getDoNothingCallback();
        responseSender.send(ByteBuffer.wrap(bytes), callback);
    }

    public void end(Object exchange) {
        try {
            ((HttpServerExchange)exchange).endExchange();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public boolean isResponseClosed(Object exchange) {
        return ((HttpServerExchange)exchange).isResponseComplete();
    }

    public boolean isResponseHeadersSent(Object exchange) {
        return ((HttpServerExchange)exchange).isResponseStarted();
    }

    public String getRequestScheme(Object exchange) {
        return ((HttpServerExchange)exchange).getRequestScheme();
    }

    public void addCookies(Object exchange, Map<String, ICookie> cookies) {
        if (cookies == null) {
            return;
        }
        Map undertowResponseCookiesMap = ((HttpServerExchange)exchange).getResponseCookies();
        for (ICookie cookie : cookies.values()) {
            String name = cookie.getName();
            String value = cookie.getValue();
            try {
                if (name != null) {
                    name = URLEncoder.encode(name, this.getCookieEncoding());
                }
                if (value != null) {
                    value = URLEncoder.encode(value, this.getCookieEncoding());
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
            CookieImpl undertowCookie = new CookieImpl(name);
            undertowCookie.setValue(value);
            undertowCookie.setDiscard(cookie.isDiscard());
            undertowCookie.setDomain(cookie.getDomain());
            undertowCookie.setExpires(cookie.getExpires());
            undertowCookie.setHttpOnly(cookie.isHttpOnly());
            undertowCookie.setPath(cookie.getPath());
            undertowCookie.setSecure(cookie.isSecure());
            undertowCookie.setVersion(cookie.getVersion());
            undertowResponseCookiesMap.put(name, undertowCookie);
        }
    }

    public Map<String, ICookie> getCookies(Object exchange) {
        HashMap<String, ICookie> cookies = new HashMap<String, ICookie>();
        Map undertowRequestCookies = ((HttpServerExchange)exchange).getRequestCookies();
        if (undertowRequestCookies != null) {
            for (Cookie undertowCookie : undertowRequestCookies.values()) {
                String name = undertowCookie.getName();
                String value = undertowCookie.getValue();
                try {
                    if (name != null) {
                        name = URLDecoder.decode(name, this.getCookieEncoding());
                    }
                    if (value != null) {
                        value = URLDecoder.decode(value, this.getCookieEncoding());
                    }
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize((Exception)ex);
                }
                ICookie spincastCookie = this.getCookieFactory().createCookie(name, value, undertowCookie.getPath(), undertowCookie.getDomain(), undertowCookie.getExpires(), undertowCookie.isSecure(), undertowCookie.isHttpOnly(), undertowCookie.isDiscard(), undertowCookie.getVersion());
                cookies.put(spincastCookie.getName(), spincastCookie);
            }
        }
        return cookies;
    }

    protected String getCookieEncoding() {
        return "UTF-8";
    }

    public Map<String, List<String>> getQueryStringParams(Object exchange) {
        HashMap<String, List<String>> queryStringParams = new HashMap<String, List<String>>();
        Map queryParameters = ((HttpServerExchange)exchange).getQueryParameters();
        if (queryParameters != null) {
            for (Map.Entry entry : queryParameters.entrySet()) {
                LinkedList list = new LinkedList((Collection)entry.getValue());
                queryStringParams.put((String)entry.getKey(), list);
            }
        }
        return queryStringParams;
    }

    public InputStream getRawInputStream(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        exchange.startBlocking();
        return exchange.getInputStream();
    }

    protected FormData getFormData(HttpServerExchange exchange) {
        try {
            FormDataParser formDataParser = this.getFormParserFactory().createParser(exchange);
            if (formDataParser == null) {
                return null;
            }
            if (!exchange.isBlocking()) {
                exchange.startBlocking();
            }
            FormData formData = formDataParser.parseBlocking();
            return formData;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public Map<String, List<String>> getFormDatas(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        FormData formData = this.getFormData(exchange);
        if (formData != null) {
            for (String key : formData) {
                Deque values = formData.get(key);
                if (values == null) continue;
                ArrayList<String> finalValues = new ArrayList<String>();
                for (FormData.FormValue formValue : values) {
                    String value;
                    if (formValue.isFile() || (value = formValue.getValue()) == null) continue;
                    finalValues.add(value);
                }
                postParams.put(key, finalValues);
            }
        }
        return postParams;
    }

    public Map<String, List<File>> getUploadedFiles(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<File>> uploadedFiles = new HashMap<String, List<File>>();
        FormData formData = this.getFormData(exchange);
        if (formData != null) {
            for (String key : formData) {
                Deque values = formData.get(key);
                if (values == null) continue;
                ArrayList<File> finalFiles = new ArrayList<File>();
                for (FormData.FormValue formValue : values) {
                    File file;
                    if (!formValue.isFile() || (file = formValue.getFile()) == null) continue;
                    finalFiles.add(file);
                }
                uploadedFiles.put(key, finalFiles);
            }
        }
        return uploadedFiles;
    }

    public boolean forceRequestSizeValidation(Object exchangeObj) {
        block3: {
            HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
            if (exchange.isRequestComplete()) {
                return true;
            }
            try {
                ByteBuffer b = ByteBuffer.allocate(200);
                exchange.getRequestChannel().read(b);
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                if (message == null || !message.contains(UNDERTOW_EXCEPTION_CODE_REQUEST_TOO_LARGE)) break block3;
                return false;
            }
        }
        return true;
    }

    public Map<String, List<String>> getRequestHeaders(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        if (requestHeaders != null) {
            for (HeaderValues requestHeader : requestHeaders) {
                HttpString headerNameObj = requestHeader.getHeaderName();
                if (headerNameObj == null) continue;
                String headerNameLowercased = headerNameObj.toString().toLowerCase();
                ArrayList<String> values = new ArrayList<String>();
                for (String value : requestHeader) {
                    values.add(value);
                }
                headers.put(headerNameLowercased, values);
            }
        }
        return headers;
    }

    protected class CorsHandler
    implements HttpHandler {
        private final HttpHandler nextHandler;
        private final IStaticResourceCorsConfig corsConfig;
        private Set<String> allowedOriginsLowercased;

        public CorsHandler(HttpHandler nextHandler, IStaticResourceCorsConfig corsConfig) {
            this.nextHandler = nextHandler;
            this.corsConfig = corsConfig;
        }

        protected HttpHandler getNextHandler() {
            return this.nextHandler;
        }

        protected IStaticResourceCorsConfig getCorsConfig() {
            return this.corsConfig;
        }

        protected Set<String> getAllowedOriginsLowercased() {
            if (this.allowedOriginsLowercased == null) {
                this.allowedOriginsLowercased = new HashSet<String>();
                HashSet allowedOrigins = this.getCorsConfig().getAllowedOrigins();
                if (allowedOrigins == null) {
                    allowedOrigins = new HashSet();
                }
                for (String allowedOrigin : allowedOrigins) {
                    if (allowedOrigin == null) continue;
                    this.allowedOriginsLowercased.add(allowedOrigin.toLowerCase().trim());
                }
            }
            return this.allowedOriginsLowercased;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            block11: {
                IStaticResourceCorsConfig corsConfig = this.getCorsConfig();
                if (corsConfig != null) {
                    HeaderValues originHeaderValues = exchange.getRequestHeaders().get("Origin");
                    if (originHeaderValues == null || originHeaderValues.size() == 0) {
                        SpincastUndertowServer.this.logger.debug("No 'Origin' header : no cors processing");
                    } else {
                        HttpString requestMethod;
                        String originHeader;
                        block10: {
                            String hostHeader;
                            originHeader = originHeaderValues.get(0);
                            HeaderValues hostHeaderValues = exchange.getRequestHeaders().get("Host");
                            if (hostHeaderValues != null && hostHeaderValues.size() > 0 && (hostHeader = hostHeaderValues.get(0)) != null) {
                                try {
                                    String originHost = new URI(originHeader).getHost();
                                    if (!hostHeader.equals(originHost)) break block10;
                                    break block11;
                                }
                                catch (Exception ex) {
                                    throw SpincastStatics.runtimize((Exception)ex);
                                }
                            }
                        }
                        if (!HTTPSTRING_GET.equals(requestMethod = exchange.getRequestMethod()) && !HTTPSTRING_HEAD.equals(requestMethod)) {
                            SpincastUndertowServer.this.logger.warn("Cors on static resources only available for GET and HEAD methods, not : " + requestMethod);
                        } else if (!this.isCorsOriginValid(exchange, corsConfig, originHeader)) {
                            SpincastUndertowServer.this.logger.info("Invalid origin for a cors request : " + originHeader);
                        } else {
                            this.corsAddAlloweOrigin(exchange, corsConfig, originHeader);
                            this.corsAddAllowCookies(exchange, corsConfig);
                            this.corsAddExtraHeadersAllowedToBeRead(exchange, corsConfig);
                        }
                    }
                }
            }
            this.getNextHandler().handleRequest(exchange);
        }

        protected boolean isCorsOriginValid(HttpServerExchange exchange, IStaticResourceCorsConfig corsConfig, String originHeader) {
            if (this.getAllowedOriginsLowercased().contains("*")) {
                return true;
            }
            return this.getAllowedOriginsLowercased().contains(originHeader.toLowerCase());
        }

        protected void corsAddAlloweOrigin(HttpServerExchange exchange, IStaticResourceCorsConfig corsConfig, String originHeader) {
            String allowedOriginsStr;
            boolean hasCookies;
            Set allowedOrigins = corsConfig.getAllowedOrigins();
            if (allowedOrigins == null || allowedOrigins.size() == 0) {
                return;
            }
            Map cookies = exchange.getRequestCookies();
            boolean bl = hasCookies = cookies != null && cookies.size() > 0;
            if (!hasCookies && allowedOrigins.contains("*")) {
                allowedOriginsStr = "*";
            } else {
                allowedOriginsStr = originHeader;
                exchange.getResponseHeaders().add(HTTPSTRING_VARY, "Origin");
            }
            exchange.getResponseHeaders().put(HTTPSTRING_ACCESS_CONTROL_ALLOW_ORIGIN, allowedOriginsStr);
        }

        protected void corsAddAllowCookies(HttpServerExchange exchange, IStaticResourceCorsConfig corsConfig) {
            if (!corsConfig.isAllowCookies()) {
                return;
            }
            exchange.getResponseHeaders().put(HTTPSTRING_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }

        protected void corsAddExtraHeadersAllowedToBeRead(HttpServerExchange exchange, IStaticResourceCorsConfig corsConfig) {
            Set extraHeadersAllowedToBeRead = corsConfig.getExtraHeadersAllowedToBeRead();
            String extraHeadersAllowedToBeReadStr = "";
            if (extraHeadersAllowedToBeRead != null && extraHeadersAllowedToBeRead.size() > 0) {
                extraHeadersAllowedToBeReadStr = StringUtils.join((Iterable)extraHeadersAllowedToBeRead, (String)",");
            }
            exchange.getResponseHeaders().put(HTTPSTRING_ACCESS_CONTROL_EXPOSE_HEADERS, extraHeadersAllowedToBeReadStr);
        }
    }
}

