/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.undertow.CacheBusterRemovalHandler;
import org.spincast.plugins.undertow.SpincastUndertowUtils;

public class CacheBusterRemovalHandlerDefault
implements CacheBusterRemovalHandler {
    public static final String EXCHANGE_VARIABLE_ORIGINAL_REQUEST_URL = CacheBusterRemovalHandlerDefault.class.getName() + "_originalRequestUrl";
    private final HttpHandler next;
    private final SpincastUtils spincastUtils;
    private final SpincastUndertowUtils spincastUndertowUtils;

    @AssistedInject
    public CacheBusterRemovalHandlerDefault(@Assisted HttpHandler next, SpincastUtils spincastUtils, SpincastUndertowUtils spincastUndertowUtils) {
        this.next = next;
        this.spincastUtils = spincastUtils;
        this.spincastUndertowUtils = spincastUndertowUtils;
    }

    protected HttpHandler getNext() {
        return this.next;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected SpincastUndertowUtils getSpincastUndertowUtils() {
        return this.spincastUndertowUtils;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.keepOriginalRequestUrlInformation(exchange);
        this.removeCacheBusterCode(exchange);
        this.getNext().handleRequest(exchange);
    }

    protected void keepOriginalRequestUrlInformation(HttpServerExchange exchange) {
        this.getSpincastUndertowUtils().getRequestCustomVariables(exchange).put(EXCHANGE_VARIABLE_ORIGINAL_REQUEST_URL, exchange.getRequestURL());
    }

    @Override
    public String getOrigninalRequestUrlWithPotentialCacheBusters(HttpServerExchange exchange) {
        return this.getSpincastUndertowUtils().getRequestCustomVariables(exchange).get(EXCHANGE_VARIABLE_ORIGINAL_REQUEST_URL);
    }

    protected void removeCacheBusterCode(HttpServerExchange exchange) {
        String requestPath = exchange.getRequestPath();
        String requestPathNoCacheBusterCodes = this.getSpincastUtils().removeCacheBusterCodes(requestPath);
        exchange.setRequestPath(requestPathNoCacheBusterCodes);
        exchange.setRelativePath(requestPathNoCacheBusterCodes);
        exchange.setRequestURI(requestPathNoCacheBusterCodes, false);
    }
}

