/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.URLResource;
import java.io.IOException;
import java.net.URL;
import org.spincast.plugins.undertow.FileClassPathResourceManager;

public class FileClassPathResourceManagerDefault
implements FileClassPathResourceManager {
    private final String filePath;

    @AssistedInject
    public FileClassPathResourceManagerDefault(@Assisted String filePath) {
        this.filePath = filePath;
    }

    protected String getFilePath() {
        return this.filePath;
    }

    public Resource getResource(String path) throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(this.getFilePath());
        if (resource == null) {
            return null;
        }
        return new URLResource(resource, resource.openConnection(), this.getFilePath());
    }

    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    public void close() throws IOException {
    }
}

