/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import org.spincast.core.utils.ISpincastUtils;

public class GzipCheckerHandler
implements HttpHandler {
    private final HttpHandler nextHandler;
    private final ISpincastUtils spincastUtils;
    private EncodingHandler gzipHandler;
    private final String specificTargetFilePath;

    public GzipCheckerHandler(HttpHandler nextHandler, ISpincastUtils spincastUtils, String specificTargetFilePath) {
        this.nextHandler = nextHandler;
        this.spincastUtils = spincastUtils;
        this.specificTargetFilePath = specificTargetFilePath;
    }

    protected HttpHandler getNextHandler() {
        return this.nextHandler;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected String getSpecificTargetFilePath() {
        return this.specificTargetFilePath;
    }

    protected EncodingHandler getGzipNoNextHandler() {
        if (this.gzipHandler == null) {
            this.gzipHandler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 50)).setNext(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                }
            });
        }
        return this.gzipHandler;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (!this.isContentTypeToSkipGziping(exchange)) {
            this.getGzipNoNextHandler().handleRequest(exchange);
        }
        this.getNextHandler().handleRequest(exchange);
    }

    protected boolean isContentTypeToSkipGziping(HttpServerExchange exchange) {
        String contentType = this.getResponseContentType(exchange);
        if (contentType != null) {
            return this.getSpincastUtils().isContentTypeToSkipGziping(contentType);
        }
        return false;
    }

    protected String getResponseContentType(HttpServerExchange exchange) {
        HeaderMap responseHeaderMap = exchange.getResponseHeaders();
        if (responseHeaderMap != null) {
            HeaderValues contentType = responseHeaderMap.get("Content-Type");
            if (contentType == null) {
                String mimeType;
                String specificTargetFilePath = this.getSpecificTargetFilePath();
                if (specificTargetFilePath != null && (mimeType = this.getSpincastUtils().getMimeTypeFromPath(specificTargetFilePath)) != null) {
                    return mimeType;
                }
                String path = exchange.getRequestPath();
                return this.getSpincastUtils().getMimeTypeFromPath(path);
            }
            return contentType.getHeaderName().toString();
        }
        return null;
    }
}

