/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.reflect.Type;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.server.IServer;
import org.spincast.plugins.undertow.CorsHandler;
import org.spincast.plugins.undertow.FileClassPathResourceManager;
import org.spincast.plugins.undertow.GzipCheckerHandler;
import org.spincast.plugins.undertow.ICorsHandler;
import org.spincast.plugins.undertow.ICorsHandlerFactory;
import org.spincast.plugins.undertow.IFileClassPathResourceManager;
import org.spincast.plugins.undertow.IFileClassPathResourceManagerFactory;
import org.spincast.plugins.undertow.IGzipCheckerHandler;
import org.spincast.plugins.undertow.IGzipCheckerHandlerFactory;
import org.spincast.plugins.undertow.ISSLContextManager;
import org.spincast.plugins.undertow.SSLContextManager;
import org.spincast.plugins.undertow.SpincastUndertowServer;

public class SpincastUndertowPluginGuiceModule
extends SpincastGuiceModuleBase {
    private final Type requestContextType;

    public SpincastUndertowPluginGuiceModule(Type requestContextType) {
        this.requestContextType = requestContextType;
    }

    protected Type getRequestContextType() {
        return this.requestContextType;
    }

    protected void configure() {
        this.bind(IServer.class).to(this.getSpincastUndertowServerClass()).in(Scopes.SINGLETON);
        this.bind(ISSLContextManager.class).to(this.getSSLContextManagerClass()).in(Scopes.SINGLETON);
        this.bindCorsHandlerFactory();
        this.bindGzipCheckerHandlerFactory();
        this.bindFileClassPathResourceManagerFactory();
    }

    protected Class<? extends IServer> getSpincastUndertowServerClass() {
        return SpincastUndertowServer.class;
    }

    protected Class<? extends ISSLContextManager> getSSLContextManagerClass() {
        return SSLContextManager.class;
    }

    protected void bindCorsHandlerFactory() {
        this.install(new FactoryModuleBuilder().implement(ICorsHandler.class, this.getCorsHandlerClass()).build(ICorsHandlerFactory.class));
    }

    protected Class<? extends ICorsHandler> getCorsHandlerClass() {
        return CorsHandler.class;
    }

    protected void bindGzipCheckerHandlerFactory() {
        this.install(new FactoryModuleBuilder().implement(IGzipCheckerHandler.class, this.getGzipCheckerHandlerClass()).build(IGzipCheckerHandlerFactory.class));
    }

    protected Class<? extends IGzipCheckerHandler> getGzipCheckerHandlerClass() {
        return GzipCheckerHandler.class;
    }

    protected void bindFileClassPathResourceManagerFactory() {
        this.install(new FactoryModuleBuilder().implement(IFileClassPathResourceManager.class, this.getFileClassPathResourceManagerClass()).build(IFileClassPathResourceManagerFactory.class));
    }

    protected Class<? extends IFileClassPathResourceManager> getFileClassPathResourceManagerClass() {
        return FileClassPathResourceManager.class;
    }
}

