/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.CorsFilter;
import org.spincast.core.filters.CorsFilterClient;
import org.spincast.core.filters.CorsFilterResponse;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.StaticResourceCorsConfig;
import org.spincast.plugins.undertow.CorsHandler;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class CorsHandlerDefault
implements CorsHandler {
    protected static final Logger logger = LoggerFactory.getLogger(CorsHandlerDefault.class);
    private final HttpHandler nextHandler;
    private final StaticResourceCorsConfig corsConfig;
    private final CorsFilter corsFilter;

    @AssistedInject
    public CorsHandlerDefault(@Assisted HttpHandler nextHandler, @Assisted @Nullable StaticResourceCorsConfig corsConfig, CorsFilter corsFilter) {
        this.nextHandler = nextHandler;
        this.corsConfig = corsConfig;
        this.corsFilter = corsFilter;
    }

    protected HttpHandler getNextHandler() {
        return this.nextHandler;
    }

    protected StaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    protected CorsFilter getCorsFilter() {
        return this.corsFilter;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HttpString httpString;
        HttpMethod httpMethod;
        String origin;
        StaticResourceCorsConfig corsConfig = this.getCorsConfig();
        if (corsConfig != null && (origin = exchange.getRequestHeaders().getFirst("Origin".toLowerCase())) != null && (httpMethod = HttpMethod.fromStringValue((String)(httpString = exchange.getRequestMethod()).toString())) != null && (HttpMethod.OPTIONS == httpMethod || HttpMethod.GET == httpMethod || HttpMethod.HEAD == httpMethod)) {
            CorsFilterClient corsFilterClient = this.createCorsFilterClient(exchange, corsConfig);
            CorsFilterResponse corsResult = this.getCorsFilter().apply(corsFilterClient);
            if (corsResult != CorsFilterResponse.NOT_CORS && corsResult != CorsFilterResponse.HEADERS_ALREADY_SENT) {
                if (corsResult == CorsFilterResponse.INVALID_CORS_REQUEST) {
                    return;
                }
                if (corsResult != CorsFilterResponse.SIMPLE) {
                    if (corsResult == CorsFilterResponse.PREFLIGHT) {
                        exchange.endExchange();
                        return;
                    }
                    throw new RuntimeException("Unmanaged cors result: " + corsResult);
                }
            }
        }
        this.getNextHandler().handleRequest(exchange);
    }

    protected CorsFilterClient createCorsFilterClient(final HttpServerExchange exchange, final StaticResourceCorsConfig corsConfig) {
        return new CorsFilterClient(){

            public void setStatusCode(int code) {
                exchange.setStatusCode(code);
            }

            public void resetEverything() {
                exchange.getResponseHeaders().clear();
            }

            public boolean requestContainsCookies() {
                Map requestCookies = exchange.getRequestCookies();
                return requestCookies != null && requestCookies.size() > 0;
            }

            public boolean isHeadersSent() {
                return exchange.isResponseStarted();
            }

            public HttpMethod getHttpMethod() {
                HttpString requestMethod = exchange.getRequestMethod();
                return HttpMethod.fromStringValue((String)requestMethod.toString());
            }

            public String getHeaderFirst(String name) {
                return exchange.getRequestHeaders().getFirst(name);
            }

            public void addHeaderValue(String name, String value) {
                exchange.getResponseHeaders().add(new HttpString(name), value);
            }

            public String getFullUrl() {
                Object queryString = exchange.getQueryString();
                queryString = StringUtils.isBlank((CharSequence)queryString) ? "" : "?" + (String)queryString;
                return exchange.getRequestURL() + (String)queryString;
            }

            public Set<String> getAllowedOrigins() {
                return corsConfig.getAllowedOrigins();
            }

            public Set<String> getExtraHeadersAllowedToBeRead() {
                return corsConfig.getExtraHeadersAllowedToBeRead();
            }

            public Set<String> getExtraHeadersAllowedToBeSent() {
                return corsConfig.getExtraHeadersAllowedToBeSent();
            }

            public boolean isAllowCookies() {
                return corsConfig.isAllowCookies();
            }

            public Set<HttpMethod> getAllowedMethods() {
                return CorsHandlerDefault.this.getStaticResourceCorsAllowedMethods();
            }

            public int getMaxAgeInSeconds() {
                return corsConfig.getMaxAgeInSeconds();
            }
        };
    }

    protected Set<HttpMethod> getStaticResourceCorsAllowedMethods() {
        HashSet allowedMethods = Sets.newHashSet((Object[])new HttpMethod[]{HttpMethod.OPTIONS, HttpMethod.GET, HttpMethod.HEAD});
        return allowedMethods;
    }
}

