/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.util.Date;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.core.routing.hotlinking.HotlinkingManager;
import org.spincast.core.routing.hotlinking.HotlinkingStategy;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.routing.utils.SpincastRoutingUtils;
import org.spincast.plugins.undertow.SpincastResourceHandler;
import org.spincast.shaded.org.apache.commons.lang3.time.DateUtils;

public class SpincastResourceHandlerDefault
extends ResourceHandler
implements SpincastResourceHandler {
    private final StaticResource<?> staticResource;
    private final SpincastUtils spincastUtils;
    private final SpincastConfig spincastConfig;
    private final SpincastRoutingUtils spincastRoutingUtils;
    private HttpHandler next;

    @AssistedInject
    public SpincastResourceHandlerDefault(@Assisted ResourceManager resourceManager, @Assisted StaticResource<?> staticResource, SpincastUtils spincastUtils, SpincastConfig spincastConfig, SpincastRoutingUtils spincastRoutingUtils) {
        this(resourceManager, staticResource, (HttpHandler)ResponseCodeHandler.HANDLE_404, spincastUtils, spincastConfig, spincastRoutingUtils);
    }

    @AssistedInject
    public SpincastResourceHandlerDefault(@Assisted ResourceManager resourceManager, @Assisted StaticResource<?> staticResource, @Assisted HttpHandler next, SpincastUtils spincastUtils, SpincastConfig spincastConfig, SpincastRoutingUtils spincastRoutingUtils) {
        super(resourceManager, next);
        this.next = next;
        this.staticResource = staticResource;
        this.spincastUtils = spincastUtils;
        this.spincastConfig = spincastConfig;
        this.spincastRoutingUtils = spincastRoutingUtils;
    }

    protected HttpHandler getNext() {
        return this.next;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected StaticResource<?> getStaticResource() {
        return this.staticResource;
    }

    protected SpincastRoutingUtils getSpincastRoutingUtils() {
        return this.spincastRoutingUtils;
    }

    public ResourceHandler setCacheTime(Integer cacheTime) {
        throw new RuntimeException("Use a constructor to specify the cache time.");
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        URI resourceUri;
        HotlinkingManager hotlinkingManager;
        Resource resource = this.getResourceManager().getResource(exchange.getRequestPath());
        if (resource == null) {
            this.getNext().handleRequest(exchange);
            return;
        }
        if (exchange.getRequestMethod().equals(Methods.GET) && this.getStaticResource().isHotlinkingProtected() && (hotlinkingManager = this.getStaticResource().getHotlinkingManager()).mustHotlinkingProtect((Object)exchange, resourceUri = new URI(exchange.getRequestURI()), exchange.getRequestHeaders().getFirst("Origin"), exchange.getRequestHeaders().getFirst("Referer"), this.getStaticResource())) {
            HotlinkingStategy hotlinkingStategy = hotlinkingManager.getHotlinkingStategy((Object)exchange, resourceUri, this.getStaticResource());
            if (hotlinkingStategy == HotlinkingStategy.FORBIDDEN) {
                exchange.setStatusCode(403);
                exchange.endExchange();
                return;
            }
            if (hotlinkingStategy == HotlinkingStategy.REDIRECT) {
                String redirectUrl = hotlinkingManager.getRedirectUrl((Object)exchange, resourceUri, this.getStaticResource());
                exchange.setStatusCode(302);
                exchange.getResponseHeaders().put(Headers.LOCATION, redirectUrl);
                exchange.endExchange();
                return;
            }
            throw new RuntimeException("The Hotlinking strategy \"" + hotlinkingStategy + "\" is not implemented in " + this.getClass().getName() + "!");
        }
        if (exchange.getRequestMethod().equals(Methods.GET) || exchange.getRequestMethod().equals(Methods.POST) || exchange.getRequestMethod().equals(Methods.HEAD)) {
            this.addContentTypeHeader(exchange);
            this.addCacheHeaders(exchange);
        }
        super.handleRequest(exchange);
    }

    protected void addContentTypeHeader(HttpServerExchange exchange) {
        try {
            Resource resource = this.getResourceManager().getResource(exchange.getRequestPath());
            if (resource != null && resource.isDirectory()) {
                return;
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        String resourcePath = null;
        if (this.getStaticResource().getStaticResourceType() == StaticResourceType.FILE || this.getStaticResource().getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH) {
            resourcePath = this.getStaticResource().getResourcePath();
        }
        String responseContentTypeHeader = exchange.getResponseHeaders().getFirst(Headers.CONTENT_TYPE);
        String contentType = this.getSpincastUtils().getMimeTypeFromMultipleSources(responseContentTypeHeader, resourcePath, exchange.getRequestPath());
        if (contentType == null) {
            contentType = ContentTypeDefaults.BINARY.getMainVariation();
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
    }

    protected void addCacheHeaders(HttpServerExchange exchange) {
        if (this.getStaticResource().getCacheConfig() != null) {
            int cacheSeconds = this.getStaticResource().getCacheConfig().getCacheSeconds();
            if (cacheSeconds > 0) {
                Object cacheControl = "";
                cacheControl = this.getStaticResource().getCacheConfig().isCachePrivate() ? "private" : "public";
                cacheControl = (String)cacheControl + ", max-age=" + cacheSeconds;
                Integer cacheSecondsCdn = this.getStaticResource().getCacheConfig().getCacheSecondsCdn();
                if (cacheSecondsCdn != null) {
                    if (cacheSecondsCdn < 0) {
                        cacheSecondsCdn = 0;
                    }
                    cacheControl = (String)cacheControl + ", s-maxage=" + cacheSecondsCdn;
                }
                exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, (String)cacheControl);
            }
            Date date = DateUtils.addSeconds((Date)new Date(), (int)cacheSeconds);
            String dateStr = org.spincast.shaded.org.apache.http.client.utils.DateUtils.formatDate((Date)date);
            exchange.getResponseHeaders().put(Headers.EXPIRES, dateStr);
        }
    }
}

