/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.URLResource;
import java.io.IOException;
import java.net.URL;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.undertow.SpincastClassPathDirResourceManager;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastClassPathDirResourceManagerDefault
implements SpincastClassPathDirResourceManager {
    private final String rootUrl;
    private final String dirPath;
    private final SpincastUtils spincastUtils;

    @AssistedInject
    public SpincastClassPathDirResourceManagerDefault(@Assisted(value="rootUrl") String rootUrl, @Assisted(value="dirPath") String dirPath, SpincastUtils spincastUtils) {
        if (StringUtils.isBlank((CharSequence)rootUrl)) {
            rootUrl = "/";
        } else if (!((String)(rootUrl = "/" + StringUtils.stripStart((String)rootUrl, (String)"/"))).endsWith("/")) {
            rootUrl = (String)rootUrl + "/";
        }
        this.rootUrl = rootUrl;
        if (StringUtils.isBlank((CharSequence)dirPath)) {
            dirPath = "";
        } else if (!((String)(dirPath = StringUtils.stripStart((String)dirPath, (String)"/"))).endsWith("/")) {
            dirPath = (String)dirPath + "/";
        }
        this.dirPath = dirPath;
        this.spincastUtils = spincastUtils;
    }

    protected String getRootUrl() {
        return this.rootUrl;
    }

    protected String getDirPath() {
        return this.dirPath;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    public Resource getResource(String path) throws IOException {
        Object pathToServe;
        if (!StringUtils.isBlank((CharSequence)path)) {
            String pathNoRoot = path;
            if (pathNoRoot.toLowerCase().startsWith(this.getRootUrl().toLowerCase())) {
                pathNoRoot = pathNoRoot.substring(this.getRootUrl().length());
            }
            if (StringUtils.isBlank((CharSequence)pathNoRoot) || pathNoRoot.equals("/")) {
                return null;
            }
            pathToServe = this.getDirPath() + StringUtils.stripStart((String)pathNoRoot, (String)"/");
        } else {
            pathToServe = this.getDirPath();
        }
        URL resourceUrl = this.getClass().getClassLoader().getResource((String)pathToServe);
        if (resourceUrl == null) {
            return null;
        }
        URLResource resource = new URLResource(resourceUrl, this.getDirPath());
        if (resource.isDirectory()) {
            return null;
        }
        return resource;
    }

    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    public void close() throws IOException {
    }
}

