/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import java.io.File;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastFileSystemDirResourceManager
extends FileResourceManager {
    private String baseUrl;
    private final File dir;

    public SpincastFileSystemDirResourceManager(String baseUrl, File dir) {
        this(baseUrl, dir, 1024L);
    }

    public SpincastFileSystemDirResourceManager(String baseUrl, File dir, long transferMinSize) {
        super(transferMinSize, true, false, new String[0]);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            baseUrl = "/";
        }
        this.baseUrl = baseUrl;
        if (dir == null) {
            throw new RuntimeException("The directory to serve can't be null...");
        }
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new RuntimeException("The file \"" + dir.getAbsolutePath() + "\" to serve exists and is not a directory!");
            }
        } else {
            boolean res = dir.mkdirs();
            if (!res) {
                throw new RuntimeException("Unable to create the directory to serve: " + dir.getAbsolutePath());
            }
        }
        this.dir = dir;
    }

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    protected File getDir() {
        return this.dir;
    }

    public Resource getResource(String path) {
        try {
            File fileToServe;
            if (StringUtils.isBlank((CharSequence)path) || path.trim().equals("/")) {
                return null;
            }
            String pathNoRoot = path;
            if (pathNoRoot.toLowerCase().startsWith(this.getBaseUrl().toLowerCase())) {
                pathNoRoot = pathNoRoot.substring(this.getBaseUrl().length());
            }
            if (!(fileToServe = new File(this.getDir(), pathNoRoot)).getCanonicalPath().startsWith(this.getDir().getCanonicalPath())) {
                throw new RuntimeException("Invalid file to serve");
            }
            if (!fileToServe.exists()) {
                return null;
            }
            return new FileResource(fileToServe, (FileResourceManager)this, fileToServe.getAbsolutePath());
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }
}

