/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.watermarker;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.watermarker.SpincastImageWatermarker;
import org.spincast.plugins.watermarker.SpincastWatermarkPosition;
import org.spincast.shaded.org.apache.commons.io.FilenameUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastImageWatermarkerDefault
implements SpincastImageWatermarker {
    private final String watermarkerId;
    private final String text;
    private final Color textColor;
    private final Color backgroundColor;
    private final Font textFont;
    private final String imageFilePath;
    private final boolean imageFileOnClasspath;
    private final Position position;
    private final Integer margin;
    private final float opacity;
    private final int percentageWidth;
    private final Integer borderWidth;
    private final Color borderColor;
    private final SpincastUtils spincastUtils;
    private final SpincastConfig spincastConfig;
    private BufferedImage watermarkOriginalImageBufferedImage;
    private File mainTempDir;
    private File watermarkImagesCacheDir;
    private Font defaultFont;

    @AssistedInject
    public SpincastImageWatermarkerDefault(@Assisted(value="text") @Nullable String text, @Assisted(value="textColor") @Nullable Color textColor, @Assisted(value="backgroundColor") @Nullable Color backgroundColor, @Assisted(value="textFont") @Nullable Font textFont, @Assisted(value="imageFilePath") @Nullable String imageFilePath, @Assisted(value="imageFileOnClasspath") boolean imageFileOnClasspath, @Assisted(value="position") @Nullable SpincastWatermarkPosition position, @Assisted(value="margin") @Nullable Integer margin, @Assisted(value="opacity") @Nullable Float opacity, @Assisted(value="percentageWidth") @Nullable Integer percentageWidth, @Assisted(value="borderWidth") @Nullable Integer borderWidth, @Assisted(value="borderColor") @Nullable Color borderColor, SpincastUtils spincastUtils, SpincastConfig spincastConfig) {
        if (text != null && imageFilePath != null) {
            throw new RuntimeException("Only the text OR the image can be specified, not both!");
        }
        this.text = text;
        this.imageFilePath = imageFilePath;
        this.imageFileOnClasspath = imageFileOnClasspath;
        this.watermarkerId = UUID.randomUUID().toString();
        this.textColor = textColor;
        this.textFont = textFont;
        if (percentageWidth == null) {
            percentageWidth = 50;
        }
        this.backgroundColor = backgroundColor;
        this.percentageWidth = percentageWidth;
        this.borderWidth = borderWidth;
        this.borderColor = borderColor;
        this.spincastUtils = spincastUtils;
        this.spincastConfig = spincastConfig;
        this.margin = margin;
        this.position = this.toThumbnailatorPosition(position, margin);
        if (opacity == null || opacity.floatValue() > 1.0f) {
            opacity = Float.valueOf(1.0f);
        } else if (opacity.floatValue() < 0.0f) {
            opacity = Float.valueOf(0.0f);
        }
        this.opacity = opacity.floatValue();
    }

    protected String getWatermarkerId() {
        return this.watermarkerId;
    }

    public String getText() {
        return this.text;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public boolean isImageFileOnClasspath() {
        return this.imageFileOnClasspath;
    }

    public Position getPosition() {
        return this.position;
    }

    public Integer getMargin() {
        return this.margin;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public int getPercentageWidth() {
        return this.percentageWidth;
    }

    public Integer getBorderWidth() {
        return this.borderWidth;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Position toThumbnailatorPosition(SpincastWatermarkPosition position, final Integer margin) {
        final Positions pos = Positions.valueOf((String)position.name());
        if (margin == null || margin <= 0) {
            return pos;
        }
        return new Position(){

            public Point calculate(int enclosingWidth, int enclosingHeight, int width, int height, int insetLeft, int insetRight, int insetTop, int insetBottom) {
                Point point = pos.calculate(enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom);
                double x = point.getX();
                double y = point.getY();
                y = pos == Positions.TOP_LEFT || pos == Positions.TOP_CENTER || pos == Positions.TOP_RIGHT ? (y += (double)margin.intValue()) : (y -= (double)margin.intValue());
                if (pos == Positions.TOP_LEFT || pos == Positions.BOTTOM_LEFT) {
                    x += (double)margin.intValue();
                } else if (pos == Positions.TOP_RIGHT || pos == Positions.BOTTOM_RIGHT) {
                    x -= (double)margin.intValue();
                }
                point.setLocation(x, y);
                return point;
            }
        };
    }

    protected File getMainTempDir() {
        if (this.mainTempDir == null) {
            boolean result;
            this.mainTempDir = new File(this.getSpincastConfig().getTempDir(), "spincastWatermarkerPlugin");
            if (!this.mainTempDir.isDirectory() && !(result = this.mainTempDir.mkdirs())) {
                throw new RuntimeException("Unable to create the directory " + this.mainTempDir.getAbsolutePath());
            }
        }
        return this.mainTempDir;
    }

    protected File getWatermarkImagesTempDir() {
        boolean result;
        File dir;
        if (this.watermarkImagesCacheDir == null && !(dir = (this.watermarkImagesCacheDir = new File(this.getMainTempDir().getAbsolutePath() + "/" + this.getWatermarkerId() + "/watermarkImagesCache"))).isDirectory() && !(result = dir.mkdirs())) {
            throw new RuntimeException("Unable to create the directory " + dir.getAbsolutePath());
        }
        return this.watermarkImagesCacheDir;
    }

    protected boolean isImageWatermark() {
        return this.getImageFilePath() != null;
    }

    protected Font getDefaultFont() {
        if (this.defaultFont == null) {
            Graphics g = new BufferedImage(10, 10, 1).getGraphics();
            this.defaultFont = g.getFont();
            g.dispose();
        }
        return this.defaultFont;
    }

    protected BufferedImage createTextWatermarkBaseImage() {
        try {
            Color fontColor;
            String text = this.getText();
            if (StringUtils.isBlank((CharSequence)text)) {
                text = this.getSpincastConfig().getPublicUrlBase();
            }
            if ((fontColor = this.getTextColor()) == null) {
                fontColor = Color.BLACK;
            }
            Color backgroundColor = this.getBackgroundColor();
            Font font = this.getTextFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            font = font.deriveFont(this.getFontSizeToCreateTextWatermarkBaseImage());
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D g = img.createGraphics();
            FontMetrics fm = g.getFontMetrics(font);
            int textWidth = fm.stringWidth(text);
            g.dispose();
            BufferedImage bufferedImage = new BufferedImage(textWidth + font.getSize() * 2, font.getSize() * 2, 2);
            g = (Graphics2D)bufferedImage.getGraphics();
            if (backgroundColor != null) {
                g.setPaint(backgroundColor);
            } else {
                g.setComposite(AlphaComposite.Clear);
            }
            g.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            g.setComposite(AlphaComposite.Src);
            g.setPaint(fontColor);
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.drawString(text, (float)font.getSize(), (float)Math.round((double)font.getSize() * 1.3));
            g.dispose();
            bufferedImage = this.addBorder(bufferedImage);
            return bufferedImage;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected float getFontSizeToCreateTextWatermarkBaseImage() {
        return 100.0f;
    }

    protected BufferedImage getWatermarkOriginalImage() {
        block10: {
            if (this.watermarkOriginalImageBufferedImage == null) {
                try {
                    if (this.isImageWatermark()) {
                        if (this.isImageFileOnClasspath()) {
                            InputStream is = this.getSpincastUtils().getClasspathInputStream(this.getImageFilePath());
                            if (is == null) {
                                throw new RuntimeException("Image not found on classpath: " + this.getImageFilePath());
                            }
                            try {
                                this.watermarkOriginalImageBufferedImage = ImageIO.read(is);
                                break block10;
                            }
                            finally {
                                SpincastStatics.closeQuietly((InputStream)is);
                            }
                        }
                        this.watermarkOriginalImageBufferedImage = ImageIO.read(new File(this.getImageFilePath()));
                        if (this.watermarkOriginalImageBufferedImage == null) {
                            throw new RuntimeException("Image not found on the file system: " + this.getImageFilePath());
                        }
                        break block10;
                    }
                    this.watermarkOriginalImageBufferedImage = this.createTextWatermarkBaseImage();
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize((Exception)ex);
                }
            }
        }
        return this.watermarkOriginalImageBufferedImage;
    }

    protected BufferedImage getWatermarkImageForWidth(int width) {
        try {
            String imageName = "watermarkImg" + width + ".png";
            File watermarkImageFile = new File(this.getWatermarkImagesTempDir(), imageName);
            if (!watermarkImageFile.isFile()) {
                BufferedImage bufferedImage = Thumbnails.of((BufferedImage[])new BufferedImage[]{this.getWatermarkOriginalImage()}).width(width).imageType(2).outputFormat("png").asBufferedImage();
                bufferedImage = this.addBorder(bufferedImage);
                ImageIO.write((RenderedImage)bufferedImage, "png", watermarkImageFile);
            }
            BufferedImage bufferedImageFinal = ImageIO.read(watermarkImageFile);
            return bufferedImageFinal;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected BufferedImage addBorder(BufferedImage watermarkImg) {
        if (this.getBorderWidth() == null || this.getBorderWidth() <= 0) {
            return watermarkImg;
        }
        Color borderColor = this.getBorderColor();
        if (borderColor == null) {
            borderColor = Color.BLACK;
        }
        BufferedImage imageWithBorder = new BufferedImage(watermarkImg.getWidth() + 2 * this.getBorderWidth(), watermarkImg.getHeight() + 2 * this.getBorderWidth(), watermarkImg.getType());
        Graphics2D g = (Graphics2D)imageWithBorder.getGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setPaint(borderColor);
        g.fillRect(0, 0, imageWithBorder.getWidth(), imageWithBorder.getHeight());
        g.drawImage((Image)watermarkImg, this.getBorderWidth(), (int)this.getBorderWidth(), null);
        g.dispose();
        return imageWithBorder;
    }

    protected int getTargetWatermarkImageWidth(BufferedImage originalImage) {
        try {
            Integer margin;
            int originalImageWidth = originalImage.getWidth();
            int watermarkWidth = Math.round((float)this.getPercentageWidth() / 100.0f * (float)originalImageWidth);
            watermarkWidth = Math.min(watermarkWidth, this.getWatermarkOriginalImage().getWidth());
            if (this.getBorderWidth() != null && this.getBorderWidth() > 0) {
                watermarkWidth -= 2 * this.getBorderWidth();
            }
            if ((margin = this.getMargin()) != null && margin > 0 && 3 * margin + watermarkWidth > originalImageWidth) {
                watermarkWidth = originalImageWidth - 3 * margin;
            }
            return watermarkWidth;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public void watermark(String originalImagePath, File targetFile) {
        this.watermark(originalImagePath, false, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermark(String originalImagePath, boolean onClasspath, File targetFile) {
        try {
            File fileOnFileSystem = new File(originalImagePath);
            if (!onClasspath && !fileOnFileSystem.isFile()) {
                throw new RuntimeException("Image not found on the file system: " + originalImagePath);
            }
            InputStream originalImageInputStream = onClasspath ? this.getSpincastUtils().getClasspathInputStream(originalImagePath) : new FileInputStream(fileOnFileSystem);
            try {
                if (originalImageInputStream == null) {
                    throw new RuntimeException("Image not found: " + originalImagePath);
                }
                BufferedImage originalImageBufferedImage = ImageIO.read(originalImageInputStream);
                int watermarkWidth = this.getTargetWatermarkImageWidth(originalImageBufferedImage);
                BufferedImage watermarkImg = this.getWatermarkImageForWidth(watermarkWidth);
                String outputType = this.getOutputType(targetFile);
                FileOutputStream os = new FileOutputStream(targetFile);
                try {
                    Thumbnails.of((BufferedImage[])new BufferedImage[]{originalImageBufferedImage}).imageType(2).watermark(this.getPosition(), watermarkImg, this.getOpacity()).scale(1.0).outputFormat(outputType).toOutputStream((OutputStream)os);
                }
                finally {
                    SpincastStatics.closeQuietly((OutputStream)os);
                }
            }
            finally {
                SpincastStatics.closeQuietly((InputStream)originalImageInputStream);
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected String getOutputType(File targetFile) {
        String extension = FilenameUtils.getExtension((String)targetFile.getName());
        if (!StringUtils.isBlank((CharSequence)extension)) {
            if (extension.equalsIgnoreCase("gif")) {
                return "gif";
            }
            if (extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg")) {
                return "jpg";
            }
        }
        return "png";
    }
}

