/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.config.ISpincastDictionary;
import org.spincast.core.controllers.IFrontController;
import org.spincast.core.controllers.SpincastFrontController;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.cookies.ICookiesRequestContextAddon;
import org.spincast.core.exchange.DefaultRequestContext;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.exchange.IRequestContextFactory;
import org.spincast.core.exchange.IRequestRequestContextAddon;
import org.spincast.core.exchange.IResponseRequestContextAddon;
import org.spincast.core.exchange.IVariablesRequestContextAddon;
import org.spincast.core.exchange.RequestContextType;
import org.spincast.core.filters.CorsFilter;
import org.spincast.core.filters.ICorsFilter;
import org.spincast.core.filters.ISpincastFilters;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.guice.SpincastRequestScope;
import org.spincast.core.guice.SpincastRequestScoped;
import org.spincast.core.json.IJsonArray;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.json.IJsonObjectFactory;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonObject;
import org.spincast.core.locale.ILocaleResolver;
import org.spincast.core.routing.DefaultRouteParamAliasesBinder;
import org.spincast.core.routing.IRouteBuilderFactory;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IRoutingRequestContextAddon;
import org.spincast.core.server.IServer;
import org.spincast.core.templating.ITemplatingEngine;
import org.spincast.core.templating.ITemplatingRequestContextAddon;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.xml.IXmlManager;

public class SpincastCoreGuiceModule
extends SpincastGuiceModuleBase {
    protected final Logger logger = LoggerFactory.getLogger(SpincastCoreGuiceModule.class);
    private Type requestContextType;
    private final String[] mainArgs;

    public SpincastCoreGuiceModule() {
        this(null);
    }

    public SpincastCoreGuiceModule(String[] mainArgs) {
        if (mainArgs == null) {
            mainArgs = new String[]{};
        }
        this.mainArgs = mainArgs;
    }

    protected String[] getMainArgs() {
        return this.mainArgs;
    }

    @Override
    protected void configure() {
        this.validateRequirements();
        this.bindMainArgs();
        this.bindRequestContextType();
        this.bindSpincastRequestScope();
        this.bindRequestContextInRequestScope();
        this.bindDefaultPredefinedRouteParamPatternsBinder();
        this.bindRequestContextFactory();
        this.bindFrontController();
        this.bindSpincastUtilsClass();
        this.bindSpincastFilters();
        this.bindJsonObjectFactory();
    }

    protected void validateRequirements() {
        this.requireBinding(IServer.class);
        this.requireBinding(this.parametrizeWithRequestContextInterface(IRouter.class));
        this.requireBinding(Key.get(new TypeLiteral<IRouter<?>>(){}));
        this.requireBinding(this.parametrizeWithRequestContextInterface(IRouteBuilderFactory.class));
        this.requireBinding(ITemplatingEngine.class);
        this.requireBinding(IJsonManager.class);
        this.requireBinding(IXmlManager.class);
        this.requireBinding(ISpincastConfig.class);
        this.requireBinding(ISpincastDictionary.class);
        this.requireBinding(ICookieFactory.class);
        this.requireBinding(ILocaleResolver.class);
        this.requireBinding(this.parametrizeWithRequestContextInterface(IRequestRequestContextAddon.class));
        this.requireBinding(this.parametrizeWithRequestContextInterface(IResponseRequestContextAddon.class));
        this.requireBinding(this.parametrizeWithRequestContextInterface(IRoutingRequestContextAddon.class));
        this.requireBinding(this.parametrizeWithRequestContextInterface(ICookiesRequestContextAddon.class));
        this.requireBinding(this.parametrizeWithRequestContextInterface(ITemplatingRequestContextAddon.class));
        this.requireBinding(this.parametrizeWithRequestContextInterface(IVariablesRequestContextAddon.class));
    }

    protected void bindMainArgs() {
        this.bind(new TypeLiteral<String[]>(){}).annotatedWith(MainArgs.class).toInstance(this.getMainArgs());
        this.bind(new TypeLiteral<List<String>>(){}).annotatedWith(MainArgs.class).toInstance(Arrays.asList(this.getMainArgs()));
    }

    protected void bindRequestContextType() {
        Type type = this.getRequestContextType();
        this.bind(Type.class).annotatedWith(RequestContextType.class).toInstance(type);
    }

    protected void bindSpincastRequestScope() {
        this.bindScope(SpincastRequestScoped.class, SpincastGuiceScopes.REQUEST);
        this.bind(SpincastRequestScope.class).toInstance(SpincastGuiceScopes.REQUEST);
    }

    protected void bindRequestContextInRequestScope() {
        Key<?> key = Key.get(this.getRequestContextType());
        this.bind(key).toProvider(SpincastRequestScope.getSeedErrorProvider(key)).in(SpincastGuiceScopes.REQUEST);
        TypeLiteral typeLiteral = new TypeLiteral<IRequestContext<?>>(){};
        this.bind(Key.get(typeLiteral)).toProvider(SpincastRequestScope.getSeedErrorProvider(Key.get(typeLiteral))).in(SpincastGuiceScopes.REQUEST);
    }

    @Override
    protected Type getRequestContextType() {
        if (this.requestContextType == null) {
            Key<IRequestContext<?>> key = Key.get(this.getRequestContextImplementationClass());
            TypeLiteral<IRequestContext> requestContextTypeLiteral = key.getTypeLiteral().getSupertype(IRequestContext.class);
            this.requestContextType = ((ParameterizedType)requestContextTypeLiteral.getType()).getActualTypeArguments()[0];
        }
        return this.requestContextType;
    }

    protected void bindSpincastFilters() {
        Key<SpincastFilters> key = this.getSpincastFiltersKey();
        try {
            key.getTypeLiteral().getSupertype(ISpincastFilters.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The Spincast Filters Key must implement " + ISpincastFilters.class.getName() + " : " + key);
        }
        this.bind(this.parametrizeWithRequestContextInterface(ISpincastFilters.class)).to(key).in(Scopes.SINGLETON);
        this.bind(ICorsFilter.class).to(this.getCorsFilterClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends ICorsFilter> getCorsFilterClass() {
        return CorsFilter.class;
    }

    protected Key<SpincastFilters> getSpincastFiltersKey() {
        return this.parametrizeWithRequestContextInterface(SpincastFilters.class);
    }

    protected void bindDefaultPredefinedRouteParamPatternsBinder() {
        this.bind(this.parametrizeWithRequestContextInterface(DefaultRouteParamAliasesBinder.class)).asEagerSingleton();
    }

    protected void bindRequestContextFactory() {
        Key<IRequestContext<?>> key = Key.get(this.getRequestContextImplementationClass());
        Key<IRequestContextFactory> requestContextFactoryKey = this.parametrizeWithRequestContextInterface(IRequestContextFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement((Class)this.getRequestContextType(), annotation, key.getTypeLiteral()).build(requestContextFactoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement((Class)this.getRequestContextType(), key.getTypeLiteral()).build(requestContextFactoryKey));
        }
    }

    protected void bindFrontController() {
        Key<?> key = this.getFrontControllerKey();
        try {
            key.getTypeLiteral().getSupertype(IFrontController.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The front controller Key must implement " + IFrontController.class.getName() + " : " + key);
        }
        this.bind(IFrontController.class).to(key).in(Scopes.SINGLETON);
    }

    protected void bindSpincastUtilsClass() {
        Key<?> key = this.getSpincastUtilsKey();
        try {
            key.getTypeLiteral().getSupertype(ISpincastUtils.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The Spincast Utils Key must implement " + ISpincastUtils.class.getName() + " : " + key);
        }
        this.bind(ISpincastUtils.class).to(key).in(Scopes.SINGLETON);
    }

    protected void bindJsonObjectFactory() {
        Key<?> jsonObjectKey = this.getJsonObjectKey();
        try {
            jsonObjectKey.getTypeLiteral().getSupertype(IJsonObject.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The json object Key must implement " + IJsonObject.class.getName() + " : " + jsonObjectKey);
        }
        Key<?> jsonArrayKey = this.getJsonArrayKey();
        try {
            jsonArrayKey.getTypeLiteral().getSupertype(IJsonArray.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The json array Key must implement " + IJsonArray.class.getName() + " : " + jsonArrayKey);
        }
        Annotation jsonObjectKeyAnnotation = jsonObjectKey.getAnnotation();
        Annotation jsonArrayKeyAnnotation = jsonArrayKey.getAnnotation();
        if (jsonObjectKeyAnnotation != null && jsonArrayKeyAnnotation != null) {
            this.install(new FactoryModuleBuilder().implement(IJsonObject.class, jsonObjectKeyAnnotation, jsonObjectKey.getTypeLiteral()).implement(IJsonArray.class, jsonArrayKeyAnnotation, jsonArrayKey.getTypeLiteral()).build(IJsonObjectFactory.class));
        } else if (jsonObjectKeyAnnotation != null) {
            this.install(new FactoryModuleBuilder().implement(IJsonObject.class, jsonObjectKeyAnnotation, jsonObjectKey.getTypeLiteral()).implement(IJsonArray.class, jsonArrayKey.getTypeLiteral()).build(IJsonObjectFactory.class));
        } else if (jsonArrayKeyAnnotation != null) {
            this.install(new FactoryModuleBuilder().implement(IJsonObject.class, jsonObjectKey.getTypeLiteral()).implement(IJsonArray.class, jsonArrayKeyAnnotation, jsonArrayKey.getTypeLiteral()).build(IJsonObjectFactory.class));
        } else {
            this.install(new FactoryModuleBuilder().implement(IJsonObject.class, jsonObjectKey.getTypeLiteral()).implement(IJsonArray.class, jsonArrayKey.getTypeLiteral()).build(IJsonObjectFactory.class));
        }
    }

    protected Class<? extends IRequestContext<?>> getRequestContextImplementationClass() {
        return DefaultRequestContext.class;
    }

    protected Key<?> getFrontControllerKey() {
        return this.parametrizeWithRequestContextInterface(SpincastFrontController.class);
    }

    protected Key<?> getSpincastUtilsKey() {
        return Key.get(SpincastUtils.class);
    }

    protected Key<?> getJsonObjectKey() {
        return Key.get(JsonObject.class);
    }

    protected Key<?> getJsonArrayKey() {
        return Key.get(JsonArray.class);
    }
}

