/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension.escaper;

import com.coverity.security.Escape;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.escaper.EscapingStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscapeFilter
implements Filter {
    private String defaultStrategy = "html";
    private final List<String> argumentNames = new ArrayList<String>();
    private final Map<String, EscapingStrategy> strategies = new HashMap<String, EscapingStrategy>();

    public EscapeFilter() {
        this.buildDefaultStrategies();
        this.argumentNames.add("strategy");
    }

    private void buildDefaultStrategies() {
        this.strategies.put("html", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.htmlText(input);
            }
        });
        this.strategies.put("js", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.jsString(input);
            }
        });
        this.strategies.put("css", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.cssString(input);
            }
        });
        this.strategies.put("html_attr", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.html(input);
            }
        });
        this.strategies.put("url_param", new EscapingStrategy(){

            @Override
            public String escape(String input) {
                return Escape.uriParam(input);
            }
        });
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object inputObject, Map<String, Object> args) {
        if (!(inputObject instanceof String)) {
            return inputObject;
        }
        String input = (String)inputObject;
        String strategy = this.defaultStrategy;
        if (args.get("strategy") != null) {
            strategy = (String)args.get("strategy");
        }
        if (!this.strategies.containsKey(strategy)) {
            throw new RuntimeException(String.format("Unknown escaping strategy [%s]", strategy));
        }
        input = this.strategies.get(strategy).escape(input);
        return input;
    }

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public void setDefaultStrategy(String defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
    }

    public void addEscapingStrategy(String name, EscapingStrategy strategy) {
        this.strategies.put(name, strategy);
    }
}

