/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.spincast.core.exchange.IDefaultRequestContext;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.guice.SpincastPluginGuiceModuleBase;
import org.spincast.core.routing.IRoute;
import org.spincast.core.routing.IRouteBuilder;
import org.spincast.core.routing.IRouteBuilderFactory;
import org.spincast.core.routing.IRouteHandlerMatch;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IRoutingRequestContextAddon;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceBuilder;
import org.spincast.core.routing.IStaticResourceBuilderFactory;
import org.spincast.core.routing.IStaticResourceCorsConfig;
import org.spincast.plugins.routing.DefaultRouter;
import org.spincast.plugins.routing.IDefaultRouter;
import org.spincast.plugins.routing.IRouteFactory;
import org.spincast.plugins.routing.IRouteHandlerMatchFactory;
import org.spincast.plugins.routing.ISpincastRouterConfig;
import org.spincast.plugins.routing.IStaticResourceCorsConfigFactory;
import org.spincast.plugins.routing.IStaticResourceFactory;
import org.spincast.plugins.routing.RouteBuilder;
import org.spincast.plugins.routing.RouteHandlerMatch;
import org.spincast.plugins.routing.SpincastRoute;
import org.spincast.plugins.routing.SpincastRouter;
import org.spincast.plugins.routing.SpincastRoutingRequestContextAddon;
import org.spincast.plugins.routing.StaticResource;
import org.spincast.plugins.routing.StaticResourceBuilder;
import org.spincast.plugins.routing.StaticResourceCorsConfig;

public class SpincastRoutingPluginGuiceModule
extends SpincastPluginGuiceModuleBase {
    public SpincastRoutingPluginGuiceModule(Type requestContextType) {
        super(requestContextType);
    }

    @Override
    protected void configure() {
        this.validateRequirements();
        this.bindRouter();
        this.bindRouteFactory();
        this.bindRouteBuilderFactory();
        this.bindRouteHandlerMatchFactory();
        this.bindStaticResourceFactory();
        this.bindStaticResourceBuilderFactory();
        this.bindStaticResourceCorsConfigFactory();
        this.bindRequestContextAddon();
    }

    protected void validateRequirements() {
        this.requireBinding(ISpincastRouterConfig.class);
    }

    protected Key<?> getRouterImplementationKey() {
        if (this.getRequestContextType().equals(IDefaultRequestContext.class)) {
            return Key.get(DefaultRouter.class);
        }
        return this.parameterizeWithRequestContextInterface(SpincastRouter.class);
    }

    protected Key<?> getRouteKey() {
        return this.parameterizeWithRequestContextInterface(SpincastRoute.class);
    }

    protected Key<?> getStaticResourceKey() {
        return this.parameterizeWithRequestContextInterface(StaticResource.class);
    }

    protected void bindRouter() {
        Key<?> key = this.getRouterImplementationKey();
        try {
            key.getTypeLiteral().getSupertype(IRouter.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The router Key must implement " + IRouter.class.getName() + " : " + key);
        }
        this.bind(key).in(Scopes.SINGLETON);
        this.bind(this.parameterizeWithRequestContextInterface(IRouter.class)).to(key).in(Scopes.SINGLETON);
        this.bind(IRouter.class).to(key).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<IRouter<?>>(){}).to(key).in(Scopes.SINGLETON);
        if (this.getRequestContextType().equals(IDefaultRequestContext.class) && IDefaultRouter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
            this.bind(IDefaultRouter.class).to(key).in(Scopes.SINGLETON);
        }
    }

    protected void bindRouteFactory() {
        Key<?> key = this.getRouteKey();
        try {
            key.getTypeLiteral().getSupertype(IRoute.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The route Key must implement " + IRoute.class.getName() + " : " + key);
        }
        Key<IRoute> routeKey = this.parameterizeWithRequestContextInterface(IRoute.class);
        Key<IRouteFactory> factoryKey = this.parameterizeWithRequestContextInterface(IRouteFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(routeKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(routeKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindRouteBuilderFactory() {
        Key<IRouteBuilder> interfaceKey = this.parameterizeWithRequestContextInterface(IRouteBuilder.class);
        Key<? extends IRouteBuilder> implementationKey = this.parameterizeWithRequestContextInterface(this.getRouteBuilderImplClass());
        Key<IRouteBuilderFactory> factoryKey = this.parameterizeWithRequestContextInterface(IRouteBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IRouteBuilder> getRouteBuilderImplClass() {
        return RouteBuilder.class;
    }

    protected void bindRouteHandlerMatchFactory() {
        Key<IRouteHandlerMatch> interfaceKey = this.parameterizeWithRequestContextInterface(IRouteHandlerMatch.class);
        Key<? extends IRouteHandlerMatch> implementationKey = this.parameterizeWithRequestContextInterface(this.getRouteHandlerMatchImplClass());
        Key<IRouteHandlerMatchFactory> factoryKey = this.parameterizeWithRequestContextInterface(IRouteHandlerMatchFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IRouteHandlerMatch> getRouteHandlerMatchImplClass() {
        return RouteHandlerMatch.class;
    }

    protected void bindStaticResourceFactory() {
        Key<?> key = this.getStaticResourceKey();
        try {
            key.getTypeLiteral().getSupertype(IStaticResource.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The static resource Key must implement " + IStaticResource.class.getName() + " : " + key);
        }
        Key<IStaticResource> staticResourceKey = this.parameterizeWithRequestContextInterface(IStaticResource.class);
        Key<IStaticResourceFactory> factoryKey = this.parameterizeWithRequestContextInterface(IStaticResourceFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(staticResourceKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(staticResourceKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindStaticResourceBuilderFactory() {
        Key<IStaticResourceBuilder> interfaceKey = this.parameterizeWithRequestContextInterface(IStaticResourceBuilder.class);
        Key<? extends IStaticResourceBuilder> implementationKey = this.parameterizeWithRequestContextInterface(this.getStaticResourceBuilderImplClass());
        Key<IStaticResourceBuilderFactory> factoryKey = this.parameterizeWithRequestContextInterface(IStaticResourceBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IStaticResourceBuilder> getStaticResourceBuilderImplClass() {
        return StaticResourceBuilder.class;
    }

    protected void bindStaticResourceCorsConfigFactory() {
        this.install(new FactoryModuleBuilder().implement(IStaticResourceCorsConfig.class, this.getStaticResourceCorsConfigImplClass()).build(IStaticResourceCorsConfigFactory.class));
    }

    protected Class<? extends IStaticResourceCorsConfig> getStaticResourceCorsConfigImplClass() {
        return StaticResourceCorsConfig.class;
    }

    protected void bindRequestContextAddon() {
        this.bind(this.parameterizeWithRequestContextInterface(IRoutingRequestContextAddon.class)).to(this.parameterizeWithRequestContextInterface(SpincastRoutingRequestContextAddon.class)).in(SpincastGuiceScopes.REQUEST);
    }
}

