/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.guice;

import com.google.inject.Key;
import com.google.inject.Scopes;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.defaults.guice.SpincastDefaultGuiceModule;
import org.spincast.plugins.routing.SpincastRoutingPluginGuiceModule;
import org.spincast.quickstart.App;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.config.IAppConfig;
import org.spincast.quickstart.controller.AppController;
import org.spincast.quickstart.controller.IAppController;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.quickstart.exchange.AppRouter;
import org.spincast.quickstart.exchange.IAppRouter;

public class AppModule
extends SpincastDefaultGuiceModule {
    public AppModule(String[] mainArgs) {
        super(mainArgs);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(AppConfig.class).in(Scopes.SINGLETON);
        this.bind(IAppConfig.class).to(AppConfig.class).in(Scopes.SINGLETON);
        this.bind(AppRouter.class).in(Scopes.SINGLETON);
        this.bind(IAppRouter.class).to(AppRouter.class).in(Scopes.SINGLETON);
        this.bind(IAppController.class).to(AppController.class).in(Scopes.SINGLETON);
        this.bind(App.class).in(Scopes.SINGLETON);
    }

    @Override
    protected Class<? extends IRequestContext<?>> getRequestContextImplementationClass() {
        return AppRequestContext.class;
    }

    @Override
    protected void bindConfigPlugin() {
        this.bind(ISpincastConfig.class).to(AppConfig.class).in(Scopes.SINGLETON);
    }

    @Override
    protected void installRoutingPlugin() {
        this.install(new SpincastRoutingPluginGuiceModule(this.getRequestContextType()){

            @Override
            protected Key<?> getRouterImplementationKey() {
                return Key.get(AppRouter.class);
            }
        });
    }
}

