/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class XmlRootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient LRUMap<ClassKey, QName> _rootNames = new LRUMap(40, 200);

    protected Object readResolve() {
        if (this._rootNames == null) {
            return new XmlRootNameLookup();
        }
        return this;
    }

    public QName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName findRootName(Class<?> rootType, MapperConfig<?> config) {
        QName name;
        ClassKey key = new ClassKey(rootType);
        LRUMap<ClassKey, QName> lRUMap = this._rootNames;
        synchronized (lRUMap) {
            name = this._rootNames.get(key);
        }
        if (name != null) {
            return name;
        }
        name = this._findRootName(rootType, config);
        lRUMap = this._rootNames;
        synchronized (lRUMap) {
            this._rootNames.put(key, name);
        }
        return name;
    }

    protected synchronized QName _findRootName(Class<?> rootType, MapperConfig<?> config) {
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        String localName = null;
        String ns = null;
        PropertyName root = intr.findRootName(ac);
        if (root != null) {
            localName = root.getSimpleName();
            ns = root.getNamespace();
        }
        if (localName == null || localName.length() == 0) {
            localName = StaxUtil.sanitizeXmlTypeName(rootType.getSimpleName());
            return new QName("", localName);
        }
        if (ns == null || ns.length() == 0) {
            ns = this.findNamespace(intr, ac);
        }
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, localName);
    }

    private String findNamespace(AnnotationIntrospector ai, AnnotatedClass ann) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            String ns;
            if (!(intr instanceof XmlAnnotationIntrospector) || (ns = ((XmlAnnotationIntrospector)((Object)intr)).findNamespace(ann)) == null) continue;
            return ns;
        }
        return null;
    }
}

