/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.Inject;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.controllers.IFrontController;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.undertow.ICorsHandler;
import org.spincast.plugins.undertow.ICorsHandlerFactory;
import org.spincast.plugins.undertow.IFileClassPathResourceManagerFactory;
import org.spincast.plugins.undertow.IGzipCheckerHandler;
import org.spincast.plugins.undertow.IGzipCheckerHandlerFactory;
import org.spincast.plugins.undertow.ISSLContextManager;
import org.spincast.plugins.undertow.ISpincastHttpAuthIdentityManager;
import org.spincast.plugins.undertow.ISpincastHttpAuthIdentityManagerFactory;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.commonjava.mimeparse.MIMEParse;

public class SpincastUndertowServer
implements IServer {
    protected final Logger logger = LoggerFactory.getLogger(SpincastUndertowServer.class);
    public static final String UNDERTOW_EXCEPTION_CODE_REQUEST_TOO_LARGE = "UT000020";
    private final ISpincastUtils spincastUtils;
    private final ISpincastConfig config;
    private final IFrontController frontController;
    private final ICookieFactory cookieFactory;
    private final ISSLContextManager sslContextManager;
    private final ICorsHandlerFactory corsHandlerFactory;
    private final IGzipCheckerHandlerFactory gzipCheckerHandlerFactory;
    private final IFileClassPathResourceManagerFactory fileClassPathResourceManagerFactory;
    private final ISpincastHttpAuthIdentityManagerFactory spincastHttpAuthIdentityManagerFactory;
    private Undertow undertowServer;
    private IoCallback doNothingCallback = null;
    private IoCallback closeExchangeCallback = null;
    private final Map<String, IStaticResource<?>> staticResourcesServedByUrlPath = new HashMap();
    private final Map<String, String> httpAuthActiveRealms = new HashMap<String, String>();
    private final Map<String, ISpincastHttpAuthIdentityManager> httpAuthIdentityManagersByRealmName = new HashMap<String, ISpincastHttpAuthIdentityManager>();
    private HttpHandler spincastFrontControllerHandler;
    private PathHandler staticResourcesPathHandler;
    private PathHandler httpAuthenticationHandler;
    private FormParserFactory formParserFactory;

    @Inject
    public SpincastUndertowServer(ISpincastConfig config, IFrontController frontController, ISpincastUtils spincastUtils, ICookieFactory cookieFactory, ISSLContextManager sslContextManager, ICorsHandlerFactory corsHandlerFactory, IGzipCheckerHandlerFactory gzipCheckerHandlerFactory, IFileClassPathResourceManagerFactory fileClassPathResourceManagerFactory, ISpincastHttpAuthIdentityManagerFactory spincastHttpAuthIdentityManagerFactory) {
        this.config = config;
        this.frontController = frontController;
        this.spincastUtils = spincastUtils;
        this.cookieFactory = cookieFactory;
        this.sslContextManager = sslContextManager;
        this.corsHandlerFactory = corsHandlerFactory;
        this.gzipCheckerHandlerFactory = gzipCheckerHandlerFactory;
        this.fileClassPathResourceManagerFactory = fileClassPathResourceManagerFactory;
        this.spincastHttpAuthIdentityManagerFactory = spincastHttpAuthIdentityManagerFactory;
    }

    protected ISpincastConfig getConfig() {
        return this.config;
    }

    protected IFrontController getFrontController() {
        return this.frontController;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ICookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected ISSLContextManager getSslContextManager() {
        return this.sslContextManager;
    }

    protected ICorsHandlerFactory getCorsHandlerFactory() {
        return this.corsHandlerFactory;
    }

    protected IGzipCheckerHandlerFactory getGzipCheckerHandlerFactory() {
        return this.gzipCheckerHandlerFactory;
    }

    protected IFileClassPathResourceManagerFactory getFileClassPathResourceManagerFactory() {
        return this.fileClassPathResourceManagerFactory;
    }

    protected ISpincastHttpAuthIdentityManagerFactory getSpincastHttpAuthIdentityManagerFactory() {
        return this.spincastHttpAuthIdentityManagerFactory;
    }

    protected Map<String, IStaticResource<?>> getStaticResourcesServedByUrlPath() {
        return this.staticResourcesServedByUrlPath;
    }

    protected Map<String, ISpincastHttpAuthIdentityManager> getHttpAuthIdentityManagersByRealmName() {
        return this.httpAuthIdentityManagersByRealmName;
    }

    protected Map<String, String> getHttpAuthActiveRealms() {
        return this.httpAuthActiveRealms;
    }

    @Override
    public Map<String, String> getHttpAuthenticationRealms() {
        return Collections.unmodifiableMap(this.getHttpAuthActiveRealms());
    }

    protected FormParserFactory getFormParserFactory() {
        if (this.formParserFactory == null) {
            this.formParserFactory = FormParserFactory.builder().build();
        }
        return this.formParserFactory;
    }

    @Override
    public void start() {
        this.undertowServer = this.getServerBuilder().build();
        int serverStartTryNbr = this.getServerStartTryNbr();
        for (int i = 0; i < serverStartTryNbr; ++i) {
            try {
                this.undertowServer.start();
                break;
            }
            catch (Exception ex) {
                if (ex instanceof BindException || ex.getCause() != null && ex.getCause() instanceof BindException) {
                    this.logger.warn("BindException while trying to start the server. Try " + i + " of " + serverStartTryNbr + "...");
                    if (i != serverStartTryNbr - 1) continue;
                    try {
                        Thread.sleep(this.getStartServerSleepMilliseconds());
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw ex;
            }
        }
        if (this.getConfig().getHttpServerPort() > 0) {
            this.logger.info("HTTP server started on host/ip \"" + this.getConfig().getServerHost() + "\", port " + this.getConfig().getHttpServerPort());
        }
        if (this.getConfig().getHttpsServerPort() > 0) {
            this.logger.info("HTTPS server started on host/ip \"" + this.getConfig().getServerHost() + "\", port " + this.getConfig().getHttpsServerPort());
        }
    }

    protected int getServerStartTryNbr() {
        return 5;
    }

    protected long getStartServerSleepMilliseconds() {
        return 500L;
    }

    protected Undertow.Builder getServerBuilder() {
        try {
            String serverHost = this.getConfig().getServerHost();
            int httpServerPort = this.getConfig().getHttpServerPort();
            int httpsServerPort = this.getConfig().getHttpsServerPort();
            if (httpServerPort <= 0 && httpsServerPort <= 0) {
                throw new RuntimeException("At least one of the HTTP or HTTPS port must be greater than 0 to start the server....");
            }
            Undertow.Builder builder = Undertow.builder().setHandler(this.getFinalHandler());
            if (httpServerPort > 0) {
                this.addHttpListener(builder, serverHost, httpServerPort);
            }
            if (httpsServerPort > 0) {
                this.addHttpsListener(builder, serverHost, httpsServerPort);
            }
            builder = this.addBuilderOptions(builder);
            return builder;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void addHttpListener(Undertow.Builder builder, String serverHost, int httpServerPort) {
        builder = builder.addHttpListener(httpServerPort, serverHost);
    }

    protected void addHttpsListener(Undertow.Builder builder, String serverHost, int httpsServerPort) {
        try {
            SSLContext sslContext = this.getSslContextManager().getSSLContext();
            builder = builder.addHttpsListener(httpsServerPort, serverHost, sslContext);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected Undertow.Builder addBuilderOptions(Undertow.Builder builder) {
        builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, this.getConfig().getServerMaxRequestBodyBytes());
        return builder;
    }

    protected HttpHandler getFinalHandler() {
        return this.getHttpAuthenticationHandler();
    }

    protected PathHandler getHttpAuthenticationHandler() {
        if (this.httpAuthenticationHandler == null) {
            this.httpAuthenticationHandler = new PathHandler(this.getHttpAuthHandlerNextHandler());
        }
        return this.httpAuthenticationHandler;
    }

    protected HttpHandler getHttpAuthHandlerNextHandler() {
        return this.getStaticResourcesPathHandler();
    }

    @Override
    public void createHttpAuthenticationRealm(String pathPrefix, String realmName) {
        if (this.getHttpAuthActiveRealms().containsKey(realmName)) {
            throw new RuntimeException("A HTTP authentication realm named '" + realmName + "' " + "already exists for path: " + pathPrefix);
        }
        ISpincastHttpAuthIdentityManager identityManager = this.getOrCreateHttpAuthIdentityManagersByRealmName(realmName);
        HttpHandler handler = new AuthenticationCallHandler(this.getHttpAuthHandlerNextHandler());
        handler = new AuthenticationConstraintHandler(handler);
        List<AuthenticationMechanism> mechanisms = Collections.singletonList(new BasicAuthenticationMechanism(this.getRealmNameToDisplay(pathPrefix, realmName)));
        handler = new AuthenticationMechanismsHandler(handler, mechanisms);
        handler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, handler);
        this.getHttpAuthIdentityManagersByRealmName().put(realmName, identityManager);
        this.getHttpAuthenticationHandler().addPrefixPath(pathPrefix, handler);
        this.getHttpAuthActiveRealms().put(realmName, pathPrefix);
    }

    protected String getRealmNameToDisplay(String pathPrefix, String realmName) {
        return realmName;
    }

    protected ISpincastHttpAuthIdentityManager getOrCreateHttpAuthIdentityManagersByRealmName(String realmName) {
        ISpincastHttpAuthIdentityManager identityManager = this.getHttpAuthIdentityManagersByRealmName().get(realmName);
        if (identityManager == null) {
            identityManager = this.getSpincastHttpAuthIdentityManagerFactory().create();
            this.getHttpAuthIdentityManagersByRealmName().put(realmName, identityManager);
        }
        return identityManager;
    }

    @Override
    public void addHttpAuthentication(String realmName, String username, String password) {
        ISpincastHttpAuthIdentityManager identityManager = this.getOrCreateHttpAuthIdentityManagersByRealmName(realmName);
        identityManager.addUser(username, password);
    }

    @Override
    public void removeHttpAuthentication(String username, String realmName) {
        ISpincastHttpAuthIdentityManager identityManager = this.getHttpAuthIdentityManagersByRealmName().get(realmName);
        if (identityManager != null) {
            identityManager.removeUser(username);
        }
    }

    @Override
    public void removeHttpAuthentication(String username) {
        for (ISpincastHttpAuthIdentityManager identityManager : this.getHttpAuthIdentityManagersByRealmName().values()) {
            identityManager.removeUser(username);
        }
    }

    protected HttpHandler getSpincastFrontControllerHandler() {
        if (this.spincastFrontControllerHandler == null) {
            this.spincastFrontControllerHandler = new HttpHandler(){

                @Override
                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    if (exchange.isInIoThread()) {
                        exchange.dispatch(this);
                        return;
                    }
                    SpincastUndertowServer.this.getFrontController().handle(exchange);
                }
            };
        }
        return this.spincastFrontControllerHandler;
    }

    @Override
    public void stop() {
        if (this.undertowServer != null) {
            try {
                this.undertowServer.stop();
            }
            catch (Exception ex) {
                this.logger.warn("Error stopping the Undertow server :\n" + SpincastStatics.getStackTrace(ex));
            }
        }
    }

    protected PathHandler getStaticResourcesPathHandler() {
        if (this.staticResourcesPathHandler == null) {
            this.staticResourcesPathHandler = new PathHandler(this.getSpincastFrontControllerHandler());
        }
        return this.staticResourcesPathHandler;
    }

    @Override
    public void addStaticResourceToServe(IStaticResource<?> staticResource) {
        Map<String, IStaticResource<?>> staticResourcesServedByUrlPath = this.getStaticResourcesServedByUrlPath();
        StaticResourceType staticResourceType = staticResource.getStaticResourceType();
        if (staticResourcesServedByUrlPath.containsKey(staticResource.getUrlPath())) {
            this.getStaticResourcesPathHandler().removeExactPath(staticResource.getUrlPath());
            this.getStaticResourcesPathHandler().removePrefixPath(staticResource.getUrlPath());
        }
        staticResourcesServedByUrlPath.put(staticResource.getUrlPath(), staticResource);
        if (staticResourceType == StaticResourceType.FILE) {
            File file = new File(staticResource.getResourcePath());
            if (!file.isFile() && !staticResource.isCanBeGenerated()) {
                throw new RuntimeException("The file doesn't exist and can't be generated so it can't be served : " + staticResource.getResourcePath());
            }
            HttpHandler next = staticResource.isCanBeGenerated() ? this.getSpincastFrontControllerHandler() : ResponseCodeHandler.HANDLE_404;
            ResourceHandler resourceHandler = new ResourceHandler(new FileResourceManager(file, 1024L), next);
            IGzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, file.getAbsolutePath());
            ICorsHandler corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addExactPath(staticResource.getUrlPath(), corsHandler);
        } else if (staticResourceType == StaticResourceType.FILE_FROM_CLASSPATH) {
            String classpathPath = staticResource.getResourcePath();
            if (classpathPath == null) {
                classpathPath = "";
            } else if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            ResourceHandler resourceHandler = new ResourceHandler(this.getFileClassPathResourceManagerFactory().create(classpathPath));
            IGzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, classpathPath);
            ICorsHandler corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addExactPath(staticResource.getUrlPath(), corsHandler);
        } else if (staticResourceType == StaticResourceType.DIRECTORY) {
            File dir = new File(staticResource.getResourcePath());
            if (!dir.isDirectory() && !staticResource.isCanBeGenerated()) {
                throw new RuntimeException("The directory doesn't exist and can't be generated so it can't be served : " + staticResource.getResourcePath());
            }
            HttpHandler next = staticResource.isCanBeGenerated() ? this.getSpincastFrontControllerHandler() : ResponseCodeHandler.HANDLE_404;
            ResourceHandler resourceHandler = new ResourceHandler(new FileResourceManager(dir, 1024L), next);
            IGzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, null);
            ICorsHandler corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addPrefixPath(staticResource.getUrlPath(), corsHandler);
        } else if (staticResourceType == StaticResourceType.DIRECTORY_FROM_CLASSPATH) {
            String classpathPath = staticResource.getResourcePath();
            if (classpathPath == null) {
                classpathPath = "";
            } else if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            ResourceHandler resourceHandler = new ResourceHandler(new ClassPathResourceManager(SpincastUndertowServer.class.getClassLoader(), classpathPath));
            IGzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, null);
            ICorsHandler corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addPrefixPath(staticResource.getUrlPath(), corsHandler);
        } else {
            throw new RuntimeException("Unamanaged static resource stype : " + (Object)((Object)staticResourceType));
        }
    }

    @Override
    public void removeStaticResourcesServed(StaticResourceType staticResourceType, String urlPath) {
        if (this.staticResourcesServedByUrlPath.containsKey(urlPath)) {
            this.removeStaticResource(staticResourceType, urlPath);
        }
    }

    @Override
    public void removeAllStaticResourcesServed() {
        for (Map.Entry<String, IStaticResource<?>> entry : this.getStaticResourcesServedByUrlPath().entrySet()) {
            String urlPath = entry.getKey();
            IStaticResource<?> staticResource = entry.getValue();
            this.removeStaticResource(staticResource.getStaticResourceType(), urlPath);
        }
    }

    protected void removeStaticResource(StaticResourceType staticResourceType, String urlPath) {
        if (staticResourceType == StaticResourceType.FILE || staticResourceType == StaticResourceType.FILE_FROM_CLASSPATH) {
            this.getStaticResourcesPathHandler().removeExactPath(urlPath);
        } else if (staticResourceType == StaticResourceType.DIRECTORY || staticResourceType == StaticResourceType.DIRECTORY_FROM_CLASSPATH) {
            this.getStaticResourcesPathHandler().removePrefixPath(urlPath);
        } else {
            throw new RuntimeException("Unamanaged static resource stype : " + (Object)((Object)staticResourceType));
        }
    }

    @Override
    public IStaticResource<?> getStaticResourceServed(String urlPath) {
        return this.getStaticResourcesServedByUrlPath().get(urlPath);
    }

    @Override
    public Set<IStaticResource<?>> getStaticResourcesServed() {
        return new HashSet(this.getStaticResourcesServedByUrlPath().values());
    }

    @Override
    public HttpMethod getHttpMethod(Object exchange) {
        HttpString httpString = ((HttpServerExchange)exchange).getRequestMethod();
        return HttpMethod.fromStringValue(httpString.toString());
    }

    protected HttpServerExchange castExchange(Object exchange) {
        return (HttpServerExchange)exchange;
    }

    @Override
    public ContentTypeDefaults getContentTypeBestMatch(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        ContentTypeDefaults type = ContentTypeDefaults.TEXT;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        if (requestHeaders != null) {
            String bestMatch;
            String requestedWith = requestHeaders.getFirst("X-Requested-With");
            if ("XMLHttpRequest".equalsIgnoreCase(requestedWith)) {
                return ContentTypeDefaults.JSON;
            }
            String accept = requestHeaders.getFirst("Accept");
            if (accept != null && !StringUtils.isBlank(bestMatch = MIMEParse.bestMatch(ContentTypeDefaults.getAllContentTypesVariations(), accept)) && (type = ContentTypeDefaults.fromString(bestMatch)) == null) {
                this.logger.error("Not supposed : " + bestMatch);
                type = ContentTypeDefaults.TEXT;
            }
        }
        return type;
    }

    @Override
    public String getFullUrl(Object exchangeObj) {
        try {
            HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
            String queryString = exchange.getQueryString();
            queryString = StringUtils.isBlank(queryString) ? "" : "?" + queryString;
            return exchange.getRequestURL() + queryString;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public void setResponseHeader(Object exchangeObj, String name, List<String> values) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HeaderMap responseHeaderMap = exchange.getResponseHeaders();
        responseHeaderMap.putAll(new HttpString(name), values);
    }

    @Override
    public void setResponseHeaders(Object exchange, Map<String, List<String>> headers) {
        HeaderMap responseHeaderMap = ((HttpServerExchange)exchange).getResponseHeaders();
        responseHeaderMap.clear();
        if (headers == null || headers.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            responseHeaderMap.putAll(new HttpString(entry.getKey()), (Collection<String>)entry.getValue());
        }
    }

    @Override
    public Map<String, List<String>> getResponseHeaders(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (responseHeaders != null) {
            for (HeaderValues responseHeader : responseHeaders) {
                HttpString headerNameObj = responseHeader.getHeaderName();
                if (headerNameObj == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                for (String value : responseHeader) {
                    values.add(value);
                }
                headers.put(headerNameObj.toString(), values);
            }
        }
        return headers;
    }

    @Override
    public void removeResponseHeader(Object exchange, String name) {
        HeaderMap responseHeaderMap = ((HttpServerExchange)exchange).getResponseHeaders();
        responseHeaderMap.remove(new HttpString(name));
    }

    @Override
    public void setResponseStatusCode(Object exchange, int statusCode) {
        ((HttpServerExchange)exchange).setResponseCode(statusCode);
    }

    protected IoCallback getDoNothingCallback() {
        if (this.doNothingCallback == null) {
            this.doNothingCallback = new IoCallback(){

                @Override
                public void onComplete(HttpServerExchange exchange, Sender sender) {
                    System.out.println();
                }

                @Override
                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                    throw new RuntimeException(exception);
                }
            };
        }
        return this.doNothingCallback;
    }

    protected IoCallback getCloseExchangeCallback() {
        if (this.closeExchangeCallback == null) {
            this.closeExchangeCallback = new IoCallback(){

                @Override
                public void onComplete(HttpServerExchange exchange, Sender sender) {
                    sender.close();
                    SpincastUndertowServer.this.end(exchange);
                }

                @Override
                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                    throw new RuntimeException(exception);
                }
            };
        }
        return this.closeExchangeCallback;
    }

    @Override
    public void flushBytes(Object exchange, byte[] bytes, boolean end) {
        Sender responseSender = ((HttpServerExchange)exchange).getResponseSender();
        IoCallback callback = end ? this.getCloseExchangeCallback() : this.getDoNothingCallback();
        responseSender.send(ByteBuffer.wrap(bytes), callback);
    }

    @Override
    public void end(Object exchange) {
        try {
            ((HttpServerExchange)exchange).endExchange();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public boolean isResponseClosed(Object exchange) {
        return ((HttpServerExchange)exchange).isResponseComplete();
    }

    @Override
    public boolean isResponseHeadersSent(Object exchange) {
        return ((HttpServerExchange)exchange).isResponseStarted();
    }

    @Override
    public String getRequestScheme(Object exchange) {
        return ((HttpServerExchange)exchange).getRequestScheme();
    }

    @Override
    public void addCookies(Object exchange, Map<String, ICookie> cookies) {
        if (cookies == null) {
            return;
        }
        Map<String, Cookie> undertowResponseCookiesMap = ((HttpServerExchange)exchange).getResponseCookies();
        for (ICookie cookie : cookies.values()) {
            String name = cookie.getName();
            String value = cookie.getValue();
            try {
                if (name != null) {
                    name = URLEncoder.encode(name, this.getCookieEncoding());
                }
                if (value != null) {
                    value = URLEncoder.encode(value, this.getCookieEncoding());
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
            CookieImpl undertowCookie = new CookieImpl(name);
            undertowCookie.setValue(value);
            undertowCookie.setDiscard(cookie.isDiscard());
            undertowCookie.setDomain(cookie.getDomain());
            undertowCookie.setExpires(cookie.getExpires());
            undertowCookie.setHttpOnly(cookie.isHttpOnly());
            undertowCookie.setPath(cookie.getPath());
            undertowCookie.setSecure(cookie.isSecure());
            undertowCookie.setVersion(cookie.getVersion());
            undertowResponseCookiesMap.put(name, undertowCookie);
        }
    }

    @Override
    public Map<String, ICookie> getCookies(Object exchange) {
        HashMap<String, ICookie> cookies = new HashMap<String, ICookie>();
        Map<String, Cookie> undertowRequestCookies = ((HttpServerExchange)exchange).getRequestCookies();
        if (undertowRequestCookies != null) {
            for (Cookie undertowCookie : undertowRequestCookies.values()) {
                String name = undertowCookie.getName();
                String value = undertowCookie.getValue();
                try {
                    if (name != null) {
                        name = URLDecoder.decode(name, this.getCookieEncoding());
                    }
                    if (value != null) {
                        value = URLDecoder.decode(value, this.getCookieEncoding());
                    }
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize(ex);
                }
                ICookie spincastCookie = this.getCookieFactory().createCookie(name, value, undertowCookie.getPath(), undertowCookie.getDomain(), undertowCookie.getExpires(), undertowCookie.isSecure(), undertowCookie.isHttpOnly(), undertowCookie.isDiscard(), undertowCookie.getVersion());
                cookies.put(spincastCookie.getName(), spincastCookie);
            }
        }
        return cookies;
    }

    protected String getCookieEncoding() {
        return "UTF-8";
    }

    @Override
    public Map<String, List<String>> getQueryStringParams(Object exchange) {
        HashMap<String, List<String>> queryStringParams = new HashMap<String, List<String>>();
        Map<String, Deque<String>> queryParameters = ((HttpServerExchange)exchange).getQueryParameters();
        if (queryParameters != null) {
            for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
                LinkedList list = new LinkedList(entry.getValue());
                queryStringParams.put(entry.getKey(), list);
            }
        }
        return queryStringParams;
    }

    @Override
    public InputStream getRawInputStream(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        exchange.startBlocking();
        return exchange.getInputStream();
    }

    protected FormData getFormData(HttpServerExchange exchange) {
        try {
            FormDataParser formDataParser = this.getFormParserFactory().createParser(exchange);
            if (formDataParser == null) {
                return null;
            }
            if (!exchange.isBlocking()) {
                exchange.startBlocking();
            }
            FormData formData = formDataParser.parseBlocking();
            return formData;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public Map<String, List<String>> getFormDatas(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        FormData formData = this.getFormData(exchange);
        if (formData != null) {
            for (String key : formData) {
                Deque<FormData.FormValue> values = formData.get(key);
                if (values == null) continue;
                ArrayList<String> finalValues = new ArrayList<String>();
                for (FormData.FormValue formValue : values) {
                    String value;
                    if (formValue.isFile() || (value = formValue.getValue()) == null) continue;
                    finalValues.add(value);
                }
                postParams.put(key, finalValues);
            }
        }
        return postParams;
    }

    @Override
    public Map<String, List<File>> getUploadedFiles(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<File>> uploadedFiles = new HashMap<String, List<File>>();
        FormData formData = this.getFormData(exchange);
        if (formData != null) {
            for (String key : formData) {
                Deque<FormData.FormValue> values = formData.get(key);
                if (values == null) continue;
                ArrayList<File> finalFiles = new ArrayList<File>();
                for (FormData.FormValue formValue : values) {
                    File file;
                    if (!formValue.isFile() || (file = formValue.getFile()) == null) continue;
                    finalFiles.add(file);
                }
                uploadedFiles.put(key, finalFiles);
            }
        }
        return uploadedFiles;
    }

    @Override
    public boolean forceRequestSizeValidation(Object exchangeObj) {
        block3: {
            HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
            if (exchange.isRequestComplete()) {
                return true;
            }
            try {
                ByteBuffer b = ByteBuffer.allocate(200);
                exchange.getRequestChannel().read(b);
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                if (message == null || !message.contains(UNDERTOW_EXCEPTION_CODE_REQUEST_TOO_LARGE)) break block3;
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<String, List<String>> getRequestHeaders(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        if (requestHeaders != null) {
            for (HeaderValues requestHeader : requestHeaders) {
                HttpString headerNameObj = requestHeader.getHeaderName();
                if (headerNameObj == null) continue;
                String headerNameLowercased = headerNameObj.toString().toLowerCase();
                ArrayList<String> values = new ArrayList<String>();
                for (String value : requestHeader) {
                    values.add(value);
                }
                headers.put(headerNameLowercased, values);
            }
        }
        return headers;
    }
}

