/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.controller;

import com.google.inject.Inject;
import java.util.HashMap;
import org.spincast.quickstart.config.IAppConfig;
import org.spincast.quickstart.controller.IAppController;
import org.spincast.quickstart.exchange.IAppRequestContext;

public class AppController
implements IAppController {
    private final IAppConfig appConfig;

    @Inject
    public AppController(IAppConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected IAppConfig getAppConfig() {
        return this.appConfig;
    }

    @Override
    public void indexPage(IAppRequestContext context) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("appName", this.getAppConfig().getAppName());
        variables.put("serverPort", this.getAppConfig().getHttpServerPort());
        context.response().sendHtmlTemplate("/templates/index.html", variables);
    }

    @Override
    public void notFound(IAppRequestContext context) {
        context.response().sendHtmlTemplate("/templates/notFound.html", null);
    }

    @Override
    public void exception(IAppRequestContext context) {
        context.response().sendHtmlTemplate("/templates/exception.html", null);
    }
}

