/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Inject;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IRouteHandlerMatch;
import org.spincast.core.routing.IRoutingRequestContextAddon;
import org.spincast.core.routing.IRoutingResult;

public class SpincastRoutingRequestContextAddon<R extends IRequestContext<R>>
implements IRoutingRequestContextAddon<R> {
    private final R requestContext;

    @Inject
    public SpincastRoutingRequestContextAddon(R requestContext) {
        this.requestContext = requestContext;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected IRouteHandlerMatch<R> getCurrentRouteMatch() {
        IRouteHandlerMatch match = (IRouteHandlerMatch)this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.ROUTE_HANDLER_MATCH);
        return match;
    }

    @Override
    public int getPosition() {
        return this.getCurrentRouteMatch().getPosition();
    }

    @Override
    public IRouteHandlerMatch<R> getCurrentRouteHandlerMatch() {
        return this.getCurrentRouteMatch();
    }

    @Override
    public IRoutingResult<R> getRoutingResult() {
        IRoutingResult routingResult = (IRoutingResult)this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.ROUTING_RESULT);
        return routingResult;
    }

    @Override
    public boolean isNotFoundRoute() {
        Boolean isNotFoundRoute = this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.IS_NOT_FOUND_ROUTE, Boolean.class);
        return isNotFoundRoute != null && isNotFoundRoute != false;
    }

    @Override
    public boolean isExceptionRoute() {
        Boolean isExceptionHandling = this.getRequestContext().variables().get(SpincastConstants.RequestScopedVariables.IS_EXCEPTION_HANDLING, Boolean.class);
        return isExceptionHandling != null && isExceptionHandling != false;
    }

    @Override
    public boolean isForwarded() {
        String forwardedUrl = this.getRequestContext().variables().getAsString(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_URL);
        return forwardedUrl != null;
    }
}

