/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.throwingproviders.CheckedProvideUtils;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.CheckedProviderMethod;
import com.google.inject.throwingproviders.CheckedProviderMethodsModule;
import com.google.inject.throwingproviders.CheckedProviderWithDependencies;
import com.google.inject.throwingproviders.ThrowingProvider;
import com.google.inject.util.Types;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ThrowingProviderBinder {
    private static final TypeLiteral<CheckedProvider<?>> CHECKED_PROVIDER_TYPE = new TypeLiteral<CheckedProvider<?>>(){};
    private static final TypeLiteral<CheckedProviderMethod<?>> CHECKED_PROVIDER_METHOD_TYPE = new TypeLiteral<CheckedProviderMethod<?>>(){};
    private final Binder binder;

    private ThrowingProviderBinder(Binder binder) {
        this.binder = binder;
    }

    public static ThrowingProviderBinder create(Binder binder) {
        return new ThrowingProviderBinder(binder.skipSources(ThrowingProviderBinder.class, SecondaryBinder.class));
    }

    public static Module forModule(Module module) {
        return CheckedProviderMethodsModule.forModule(module);
    }

    @Deprecated
    public <P extends CheckedProvider> SecondaryBinder<P, ?> bind(Class<P> interfaceType, Type clazz) {
        return new SecondaryBinder(interfaceType, clazz);
    }

    public <P extends CheckedProvider, T> SecondaryBinder<P, T> bind(Class<P> interfaceType, Class<T> clazz) {
        return new SecondaryBinder(interfaceType, clazz);
    }

    public <P extends CheckedProvider, T> SecondaryBinder<P, T> bind(Class<P> interfaceType, TypeLiteral<T> typeLiteral) {
        return new SecondaryBinder(interfaceType, typeLiteral.getType());
    }

    private static class NotSyntheticOrBridgePredicate
    implements Predicate<Method> {
        static NotSyntheticOrBridgePredicate INSTANCE = new NotSyntheticOrBridgePredicate();

        private NotSyntheticOrBridgePredicate() {
        }

        @Override
        public boolean apply(Method input) {
            return !input.isBridge() && !input.isSynthetic();
        }
    }

    private static class ResultException
    extends RuntimeException {
        ResultException(Exception cause) {
            super(cause);
        }
    }

    static class Result
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Object value;
        private final Exception exception;

        private Result(Object value, Exception exception) {
            this.value = value;
            this.exception = exception;
        }

        public static Result forValue(Object value) {
            return new Result(value, null);
        }

        public static Result forException(Exception e) {
            return new Result(null, e);
        }

        public Object getOrThrow() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }

    public class SecondaryBinder<P extends CheckedProvider, T> {
        private final Class<P> interfaceType;
        private final Type valueType;
        private final List<Class<? extends Throwable>> exceptionTypes;
        private final boolean valid;
        private Class<? extends Annotation> annotationType;
        private Annotation annotation;
        private Key<P> interfaceKey;
        private boolean scopeExceptions = true;

        public SecondaryBinder(Class<P> interfaceType, Type valueType) {
            this.interfaceType = Preconditions.checkNotNull(interfaceType, "interfaceType");
            this.valueType = Preconditions.checkNotNull(valueType, "valueType");
            if (this.checkInterface()) {
                this.exceptionTypes = this.getExceptionType(interfaceType);
                this.valid = true;
            } else {
                this.valid = false;
                this.exceptionTypes = ImmutableList.of();
            }
        }

        List<Class<? extends Throwable>> getExceptionTypes() {
            return this.exceptionTypes;
        }

        Key<P> getKey() {
            return this.interfaceKey;
        }

        public SecondaryBinder<P, T> annotatedWith(Class<? extends Annotation> annotationType) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException("Cannot set annotation twice");
            }
            this.annotationType = annotationType;
            return this;
        }

        public SecondaryBinder<P, T> annotatedWith(Annotation annotation) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException("Cannot set annotation twice");
            }
            this.annotation = annotation;
            return this;
        }

        public SecondaryBinder<P, T> scopeExceptions(boolean scopeExceptions) {
            this.scopeExceptions = scopeExceptions;
            return this;
        }

        public ScopedBindingBuilder to(P target) {
            Key<P> targetKey = Key.get(this.interfaceType, UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(target);
            return this.to(targetKey);
        }

        public ScopedBindingBuilder to(Class<? extends P> targetType) {
            return this.to(Key.get(targetType));
        }

        public ScopedBindingBuilder providing(Class<? extends T> cxtorClass) {
            return this.providing(TypeLiteral.get(cxtorClass));
        }

        public ScopedBindingBuilder providing(TypeLiteral<? extends T> cxtorLiteral) {
            Provider<? extends T> typeProvider;
            Key<? extends T> typeKey;
            Constructor<? extends T> cxtor = CheckedProvideUtils.findThrowingConstructor(cxtorLiteral, ThrowingProviderBinder.this.binder);
            if (cxtor != null) {
                CheckedProvideUtils.validateExceptions(ThrowingProviderBinder.this.binder, cxtorLiteral.getExceptionTypes(cxtor), this.exceptionTypes, this.interfaceType);
                typeKey = Key.get(cxtorLiteral, UniqueAnnotations.create());
                ThrowingProviderBinder.this.binder.bind(typeKey).toConstructor(cxtor).in(Scopes.NO_SCOPE);
                typeProvider = ThrowingProviderBinder.this.binder.getProvider(typeKey);
            } else {
                typeProvider = null;
                typeKey = null;
            }
            CheckedProviderWithDependencies checkedProvider = new CheckedProviderWithDependencies<T>(){

                @Override
                public T get() throws Exception {
                    try {
                        return typeProvider.get();
                    }
                    catch (ProvisionException pe) {
                        if (pe.getCause() instanceof Exception) {
                            throw (Exception)pe.getCause();
                        }
                        if (pe.getCause() instanceof Error) {
                            throw (Error)pe.getCause();
                        }
                        throw pe;
                    }
                }

                @Override
                public Set<Dependency<?>> getDependencies() {
                    return ImmutableSet.of(Dependency.get(typeKey));
                }
            };
            Key targetKey = Key.get(CHECKED_PROVIDER_TYPE, UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(checkedProvider);
            return this.toInternal(targetKey);
        }

        ScopedBindingBuilder toProviderMethod(CheckedProviderMethod<?> target) {
            Key targetKey = Key.get(CHECKED_PROVIDER_METHOD_TYPE, UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(target);
            return this.toInternal(targetKey);
        }

        public ScopedBindingBuilder to(Key<? extends P> targetKey) {
            Preconditions.checkNotNull(targetKey, "targetKey");
            return this.toInternal(targetKey);
        }

        private ScopedBindingBuilder toInternal(Key<? extends CheckedProvider<?>> targetKey) {
            final Key<Result> resultKey = Key.get(Result.class, UniqueAnnotations.create());
            final Provider<Result> resultProvider = ThrowingProviderBinder.this.binder.getProvider(resultKey);
            Provider<? extends CheckedProvider<?>> targetProvider = ThrowingProviderBinder.this.binder.getProvider(targetKey);
            this.interfaceKey = this.createKey();
            if (this.valid) {
                ThrowingProviderBinder.this.binder.bind(this.interfaceKey).toProvider(new ProviderWithDependencies<P>(){
                    private final P instance;
                    {
                        this.instance = (CheckedProvider)SecondaryBinder.this.interfaceType.cast(Proxy.newProxyInstance(SecondaryBinder.this.interfaceType.getClassLoader(), new Class[]{SecondaryBinder.this.interfaceType}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                Result result;
                                if (method.getDeclaringClass() == Object.class) {
                                    return method.invoke((Object)this, args);
                                }
                                if (SecondaryBinder.this.scopeExceptions) {
                                    return ((Result)resultProvider.get()).getOrThrow();
                                }
                                try {
                                    result = (Result)resultProvider.get();
                                }
                                catch (ProvisionException pe) {
                                    Throwable cause = pe.getCause();
                                    if (cause instanceof ResultException) {
                                        throw ((ResultException)cause).getCause();
                                    }
                                    throw pe;
                                }
                                return result.getOrThrow();
                            }
                        }));
                    }

                    @Override
                    public P get() {
                        return this.instance;
                    }

                    @Override
                    public Set<Dependency<?>> getDependencies() {
                        return ImmutableSet.of(Dependency.get(resultKey));
                    }
                });
            }
            return ThrowingProviderBinder.this.binder.bind(resultKey).toProvider((Provider<Result>)this.createResultProvider(targetKey, targetProvider));
        }

        private ProviderWithDependencies<Result> createResultProvider(final Key<? extends CheckedProvider<?>> targetKey, final Provider<? extends CheckedProvider<?>> targetProvider) {
            return new ProviderWithDependencies<Result>(){

                @Override
                public Result get() {
                    try {
                        return Result.forValue(((CheckedProvider)targetProvider.get()).get());
                    }
                    catch (Exception e) {
                        for (Class exceptionType : SecondaryBinder.this.exceptionTypes) {
                            if (!exceptionType.isInstance(e)) continue;
                            if (SecondaryBinder.this.scopeExceptions) {
                                return Result.forException(e);
                            }
                            throw new ResultException(e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Set<Dependency<?>> getDependencies() {
                    return ImmutableSet.of(Dependency.get(targetKey));
                }
            };
        }

        private List<Class<? extends Throwable>> getExceptionType(Class<P> interfaceType) {
            try {
                Method getMethod = interfaceType.getMethod("get", new Class[0]);
                List<TypeLiteral<?>> exceptionLiterals = TypeLiteral.get(interfaceType).getExceptionTypes(getMethod);
                ArrayList<Class<? extends Throwable>> results = Lists.newArrayList();
                for (TypeLiteral<?> exLiteral : exceptionLiterals) {
                    results.add(exLiteral.getRawType().asSubclass(Throwable.class));
                }
                return results;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Not allowed to inspect exception types", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No 'get'method available", e);
            }
        }

        private boolean checkInterface() {
            Type exceptionType;
            boolean tpMode;
            if (!this.checkArgument(this.interfaceType.isInterface(), "%s must be an interface", this.interfaceType.getName())) {
                return false;
            }
            if (!this.checkArgument(this.interfaceType.getGenericInterfaces().length == 1, "%s must extend CheckedProvider (and only CheckedProvider)", this.interfaceType)) {
                return false;
            }
            boolean bl = tpMode = this.interfaceType.getInterfaces()[0] == ThrowingProvider.class;
            if (!tpMode && !this.checkArgument(this.interfaceType.getInterfaces()[0] == CheckedProvider.class, "%s must extend CheckedProvider (and only CheckedProvider)", this.interfaceType)) {
                return false;
            }
            ParameterizedType genericThrowingProvider = (ParameterizedType)this.interfaceType.getGenericInterfaces()[0];
            if (this.interfaceType.getTypeParameters().length == 1) {
                String returnTypeName = this.interfaceType.getTypeParameters()[0].getName();
                Type returnType = genericThrowingProvider.getActualTypeArguments()[0];
                if (!this.checkArgument(returnType instanceof TypeVariable, "%s does not properly extend CheckedProvider, the first type parameter of CheckedProvider (%s) is not a generic type", this.interfaceType, returnType)) {
                    return false;
                }
                if (!this.checkArgument(returnTypeName.equals(((TypeVariable)returnType).getName()), "The generic type (%s) of %s does not match the generic type of CheckedProvider (%s)", returnTypeName, this.interfaceType, ((TypeVariable)returnType).getName())) {
                    return false;
                }
            } else {
                if (!this.checkArgument(this.interfaceType.getTypeParameters().length == 0, "%s has more than one generic type parameter: %s", this.interfaceType, Arrays.asList(this.interfaceType.getTypeParameters()))) {
                    return false;
                }
                if (!this.checkArgument(genericThrowingProvider.getActualTypeArguments()[0].equals(this.valueType), "%s expects the value type to be %s, but it was %s", this.interfaceType, genericThrowingProvider.getActualTypeArguments()[0], this.valueType)) {
                    return false;
                }
            }
            if (tpMode && !this.checkArgument((exceptionType = genericThrowingProvider.getActualTypeArguments()[1]) instanceof Class, "%s has the wrong Exception generic type (%s) when extending CheckedProvider", this.interfaceType, exceptionType)) {
                return false;
            }
            ImmutableList<Method> declaredMethods = FluentIterable.from(Arrays.asList(this.interfaceType.getDeclaredMethods())).filter(NotSyntheticOrBridgePredicate.INSTANCE).toList();
            if (declaredMethods.size() == 1) {
                Method method = (Method)declaredMethods.get(0);
                if (!this.checkArgument(method.getName().equals("get"), "%s may not declare any new methods, but declared %s", this.interfaceType, method)) {
                    return false;
                }
                if (!this.checkArgument(method.getParameterTypes().length == 0, "%s may not declare any new methods, but declared %s", this.interfaceType, method.toGenericString())) {
                    return false;
                }
            } else if (!this.checkArgument(declaredMethods.isEmpty(), "%s may not declare any new methods, but declared %s", this.interfaceType, Arrays.asList(this.interfaceType.getDeclaredMethods()))) {
                return false;
            }
            return true;
        }

        private boolean checkArgument(boolean condition, String messageFormat, Object ... args) {
            if (!condition) {
                ThrowingProviderBinder.this.binder.addError(messageFormat, args);
                return false;
            }
            return true;
        }

        private Key<P> createKey() {
            TypeLiteral<Object> typeLiteral;
            if (this.interfaceType.getTypeParameters().length == 1) {
                ParameterizedType type = Types.newParameterizedTypeWithOwner(this.interfaceType.getEnclosingClass(), this.interfaceType, this.valueType);
                typeLiteral = TypeLiteral.get(type);
            } else {
                typeLiteral = TypeLiteral.get(this.interfaceType);
            }
            if (this.annotation != null) {
                return Key.get(typeLiteral, this.annotation);
            }
            if (this.annotationType != null) {
                return Key.get(typeLiteral, this.annotationType);
            }
            return Key.get(typeLiteral);
        }
    }
}

