/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.lexer;

import java.util.regex.Pattern;

public final class Syntax {
    private final String delimiterCommentOpen;
    private final String delimiterCommentClose;
    private final String delimiterExecuteOpen;
    private final String delimiterExecuteClose;
    private final String delimiterPrintOpen;
    private final String delimiterPrintClose;
    private final String whitespaceTrim;
    private final Pattern regexPrintClose;
    private final Pattern regexExecuteClose;
    private final Pattern regexCommentClose;
    private final Pattern regexStartDelimiters;
    private final Pattern regexLeadingWhitespaceTrim;
    private final Pattern regexTrailingWhitespaceTrim;
    private final Pattern regexVerbatimStart;
    private final Pattern regexVerbatimEnd;
    private static final String POSSIBLE_NEW_LINE = "(\r\n|\n\r|\r|\n|\u0085|\u2028|\u2029)?";

    public Syntax(String delimiterCommentOpen, String delimiterCommentClose, String delimiterExecuteOpen, String delimiterExecuteClose, String delimiterPrintOpen, String delimiterPrintClose, String whitespaceTrim) {
        this.delimiterCommentClose = delimiterCommentClose;
        this.delimiterCommentOpen = delimiterCommentOpen;
        this.delimiterExecuteOpen = delimiterExecuteOpen;
        this.delimiterExecuteClose = delimiterExecuteClose;
        this.delimiterPrintOpen = delimiterPrintOpen;
        this.delimiterPrintClose = delimiterPrintClose;
        this.whitespaceTrim = whitespaceTrim;
        this.regexPrintClose = Pattern.compile("^\\s*" + Pattern.quote(whitespaceTrim) + "?" + Pattern.quote(delimiterPrintClose) + POSSIBLE_NEW_LINE);
        this.regexExecuteClose = Pattern.compile("^\\s*" + Pattern.quote(whitespaceTrim) + "?" + Pattern.quote(delimiterExecuteClose) + POSSIBLE_NEW_LINE);
        this.regexCommentClose = Pattern.compile(Pattern.quote(delimiterCommentClose) + POSSIBLE_NEW_LINE);
        this.regexStartDelimiters = Pattern.compile(Pattern.quote(delimiterPrintOpen) + "|" + Pattern.quote(delimiterExecuteOpen) + "|" + Pattern.quote(delimiterCommentOpen));
        this.regexVerbatimStart = Pattern.compile("^\\s*verbatim\\s*(" + Pattern.quote(whitespaceTrim) + ")?" + Pattern.quote(delimiterExecuteClose) + POSSIBLE_NEW_LINE);
        this.regexVerbatimEnd = Pattern.compile(Pattern.quote(delimiterExecuteOpen) + "(" + Pattern.quote(whitespaceTrim) + ")?" + "\\s*endverbatim\\s*(" + Pattern.quote(whitespaceTrim) + ")?" + Pattern.quote(delimiterExecuteClose) + POSSIBLE_NEW_LINE);
        this.regexLeadingWhitespaceTrim = Pattern.compile(Pattern.quote(whitespaceTrim) + "\\s+");
        this.regexTrailingWhitespaceTrim = Pattern.compile("^\\s*" + Pattern.quote(whitespaceTrim) + "(" + Pattern.quote(delimiterPrintClose) + "|" + Pattern.quote(delimiterExecuteClose) + "|" + Pattern.quote(delimiterCommentClose) + ")");
    }

    public String getCommentOpenDelimiter() {
        return this.delimiterCommentOpen;
    }

    public String getCommentCloseDelimiter() {
        return this.delimiterCommentClose;
    }

    public String getExecuteOpenDelimiter() {
        return this.delimiterExecuteOpen;
    }

    public String getExecuteCloseDelimiter() {
        return this.delimiterExecuteClose;
    }

    public String getPrintOpenDelimiter() {
        return this.delimiterPrintOpen;
    }

    public String getPrintCloseDelimiter() {
        return this.delimiterPrintClose;
    }

    public String getWhitespaceTrim() {
        return this.whitespaceTrim;
    }

    Pattern getRegexPrintClose() {
        return this.regexPrintClose;
    }

    Pattern getRegexExecuteClose() {
        return this.regexExecuteClose;
    }

    Pattern getRegexCommentClose() {
        return this.regexCommentClose;
    }

    Pattern getRegexStartDelimiters() {
        return this.regexStartDelimiters;
    }

    Pattern getRegexLeadingWhitespaceTrim() {
        return this.regexLeadingWhitespaceTrim;
    }

    Pattern getRegexTrailingWhitespaceTrim() {
        return this.regexTrailingWhitespaceTrim;
    }

    Pattern getRegexVerbatimEnd() {
        return this.regexVerbatimEnd;
    }

    Pattern getRegexVerbatimStart() {
        return this.regexVerbatimStart;
    }

    public static class Builder {
        private String delimiterCommentOpen = "{#";
        private String delimiterCommentClose = "#}";
        private String delimiterExecuteOpen = "{%";
        private String delimiterExecuteClose = "%}";
        private String delimiterPrintOpen = "{{";
        private String delimiterPrintClose = "}}";
        private String whitespaceTrim = "-";

        public String getCommentOpenDelimiter() {
            return this.delimiterCommentOpen;
        }

        public void setCommentOpenDelimiter(String commentOpenDelimiter) {
            this.delimiterCommentOpen = commentOpenDelimiter;
        }

        public String getCommentCloseDelimiter() {
            return this.delimiterCommentClose;
        }

        public void setCommentCloseDelimiter(String commentCloseDelimiter) {
            this.delimiterCommentClose = commentCloseDelimiter;
        }

        public String getExecuteOpenDelimiter() {
            return this.delimiterExecuteOpen;
        }

        public void setExecuteOpenDelimiter(String executeOpenDelimiter) {
            this.delimiterExecuteOpen = executeOpenDelimiter;
        }

        public String getExecuteCloseDelimiter() {
            return this.delimiterExecuteClose;
        }

        public void setExecuteCloseDelimiter(String executeCloseDelimiter) {
            this.delimiterExecuteClose = executeCloseDelimiter;
        }

        public String getPrintOpenDelimiter() {
            return this.delimiterPrintOpen;
        }

        public void setPrintOpenDelimiter(String printOpenDelimiter) {
            this.delimiterPrintOpen = printOpenDelimiter;
        }

        public String getPrintCloseDelimiter() {
            return this.delimiterPrintClose;
        }

        public void setPrintCloseDelimiter(String printCloseDelimiter) {
            this.delimiterPrintClose = printCloseDelimiter;
        }

        public String getWhitespaceTrim() {
            return this.whitespaceTrim;
        }

        public void setWhitespaceTrim(String whitespaceTrim) {
            this.whitespaceTrim = whitespaceTrim;
        }

        public Syntax build() {
            return new Syntax(this.delimiterCommentOpen, this.delimiterCommentClose, this.delimiterExecuteOpen, this.delimiterExecuteClose, this.delimiterPrintOpen, this.delimiterPrintClose, this.whitespaceTrim);
        }
    }
}

