/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.request;

import com.google.inject.Inject;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.exchange.IRequestRequestContextAddon;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.IXmlManager;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.NameValuePair;
import org.spincast.shaded.org.apache.http.client.utils.URLEncodedUtils;

public class SpincastRequestRequestContextAddon<R extends IRequestContext<?>>
implements IRequestRequestContextAddon<R> {
    private String fullUrlRaw = null;
    private String fullUrl = null;
    private String requestPath = null;
    private String queryStringRaw = "";
    private String queryString = "";
    private Map<String, List<String>> queryStringParams;
    private Map<String, List<String>> formDatas;
    private Map<String, List<File>> uploadedFiles;
    private Map<String, List<String>> headers;
    private final R requestContext;
    private final IServer server;
    private final IJsonManager jsonManager;
    private final IXmlManager xmlManager;
    private final ISpincastUtils spincastUtils;
    private final ISpincastConfig spincastConfig;

    @Inject
    public SpincastRequestRequestContextAddon(R requestContext, IServer server, IJsonManager jsonManager, IXmlManager xmlManager, ISpincastUtils spincastUtils, ISpincastConfig spincastConfig) {
        this.requestContext = requestContext;
        this.server = server;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.spincastUtils = spincastUtils;
        this.spincastConfig = spincastConfig;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected IJsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected IXmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.getServer().getHttpMethod(this.getExchange());
    }

    @Override
    public ContentTypeDefaults getContentTypeBestMatch() {
        return this.getServer().getContentTypeBestMatch(this.getExchange());
    }

    @Override
    public boolean isJsonShouldBeReturn() {
        return ContentTypeDefaults.JSON == this.getContentTypeBestMatch();
    }

    @Override
    public boolean isHTMLShouldBeReturn() {
        return ContentTypeDefaults.HTML == this.getContentTypeBestMatch();
    }

    @Override
    public boolean isXMLShouldBeReturn() {
        return ContentTypeDefaults.XML == this.getContentTypeBestMatch();
    }

    @Override
    public boolean isPlainTextShouldBeReturn() {
        return ContentTypeDefaults.TEXT == this.getContentTypeBestMatch();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            Map<String, List<String>> headersServer = this.getServer().getRequestHeaders(this.getExchange());
            Map<String, List<String>> headersFinal = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (headersServer == null) {
                headersServer = Collections.emptyMap();
            } else {
                for (Map.Entry<String, List<String>> entry : headersServer.entrySet()) {
                    if (entry.getValue() == null) {
                        headersFinal.put(entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    headersFinal.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
                }
                headersFinal = Collections.unmodifiableMap(headersFinal);
            }
            this.headers = headersFinal;
        }
        return this.headers;
    }

    @Override
    public List<String> getHeader(String name) {
        if (StringUtils.isBlank(name)) {
            return new LinkedList<String>();
        }
        List<String> values = this.getHeaders().get(name);
        if (values == null) {
            values = new LinkedList<String>();
        }
        return values;
    }

    @Override
    public String getHeaderFirst(String name) {
        List<String> values = this.getHeader(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    protected void validateUrlInfoCache() {
        String url = this.getRequestContext().variables().getAsString(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_URL);
        if (url == null) {
            if (this.fullUrlRaw != null) {
                return;
            }
            url = this.getServer().getFullUrl(this.getExchange());
        }
        if (!url.equals(this.fullUrlRaw)) {
            this.fullUrlRaw = url;
            try {
                this.fullUrl = URLDecoder.decode(url, "UTF-8");
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
            this.parseUrl();
        }
    }

    protected void parseUrl() {
        this.parseRequestPath();
        this.parseQueryString();
        this.parseQueryStringParams();
    }

    protected void parseRequestPath() {
        try {
            URL url = new URL(this.fullUrlRaw);
            this.requestPath = url.getPath();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void parseQueryString() {
        try {
            URL url = new URL(this.fullUrlRaw);
            String qs = url.getQuery();
            if (qs == null) {
                qs = "";
            }
            this.queryStringRaw = qs;
            this.queryString = URLDecoder.decode(qs, "UTF-8");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    public void parseQueryStringParams() {
        try {
            List<NameValuePair> params;
            HashMap<String, ArrayList<String>> paramsFinal = new HashMap<String, ArrayList<String>>();
            String qs = this.queryStringRaw;
            if (qs == null) {
                this.parseQueryString();
                qs = this.queryStringRaw;
            }
            if ((params = URLEncodedUtils.parse(qs, Charset.forName("UTF-8"))) != null) {
                for (NameValuePair nameValuePair : params) {
                    String name = nameValuePair.getName();
                    ArrayList<String> values = (ArrayList<String>)paramsFinal.get(name);
                    if (values == null) {
                        values = new ArrayList<String>();
                        paramsFinal.put(name, values);
                    }
                    values.add(nameValuePair.getValue());
                }
            }
            HashMap mapWithInmutableLists = new HashMap();
            for (Map.Entry entry : paramsFinal.entrySet()) {
                mapWithInmutableLists.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
            }
            this.queryStringParams = Collections.unmodifiableMap(mapWithInmutableLists);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public String getFullUrl() {
        this.validateUrlInfoCache();
        return this.fullUrl;
    }

    @Override
    public String getOriginalFullUrl() {
        return this.getServer().getFullUrl(this.getExchange());
    }

    @Override
    public String getRequestPath() {
        this.validateUrlInfoCache();
        return this.requestPath;
    }

    @Override
    public String getQueryString() {
        this.validateUrlInfoCache();
        return this.queryString;
    }

    @Override
    public Map<String, List<String>> getQueryStringParams() {
        this.validateUrlInfoCache();
        return this.queryStringParams;
    }

    @Override
    public List<String> getQueryStringParam(String name) {
        List<String> values = this.getQueryStringParams().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    @Override
    public String getQueryStringParamFirst(String name) {
        List<String> values = this.getQueryStringParam(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Map<String, String> getPathParams() {
        Map<String, String> pathParams = this.getRequestContext().routing().getCurrentRouteHandlerMatch().getParameters();
        pathParams = pathParams == null ? Collections.emptyMap() : Collections.unmodifiableMap(pathParams);
        return pathParams;
    }

    @Override
    public String getPathParam(String name) {
        return this.getPathParams().get(name);
    }

    @Override
    public InputStream getBodyAsInputStream() {
        return this.getServer().getRawInputStream(this.getExchange());
    }

    @Override
    public String getBodyAsString() {
        return this.getBodyAsString("UTF-8");
    }

    @Override
    public String getBodyAsString(String encoding) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return "";
            }
            return IOUtils.toString(inputStream, encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public byte[] getBodyAsByteArray() {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return new byte[0];
            }
            return IOUtils.toByteArray(inputStream);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public IJsonObject getJsonBodyAsJsonObject() {
        IJsonObject obj = this.getJsonBody(IJsonObject.class);
        return obj;
    }

    @Override
    public Map<String, Object> getJsonBodyAsMap() {
        Map obj = this.getJsonBody(Map.class);
        return obj;
    }

    @Override
    public <T> T getJsonBody(Class<T> clazz) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return null;
            }
            return this.getJsonManager().fromJsonInputStream(inputStream, clazz);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public IJsonObject getXmlBodyAsJsonObject() {
        IJsonObject obj = this.getXmlBody(IJsonObject.class);
        return obj;
    }

    @Override
    public Map<String, Object> getXmlBodyAsMap() {
        Map obj = this.getXmlBody(Map.class);
        return obj;
    }

    @Override
    public <T> T getXmlBody(Class<T> clazz) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return null;
            }
            return this.getXmlManager().fromXmlInputStream(inputStream, clazz);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public Map<String, List<String>> getFormDatas() {
        if (this.formDatas == null) {
            Map<String, List<String>> formDatasServer = this.getServer().getFormDatas(this.getExchange());
            Map<String, List<String>> formDatasFinal = new HashMap<String, List<String>>();
            if (formDatasServer == null) {
                formDatasServer = Collections.emptyMap();
            } else {
                for (Map.Entry<String, List<String>> entry : formDatasServer.entrySet()) {
                    if (entry.getValue() == null) {
                        formDatasFinal.put(entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    formDatasFinal.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
                }
                formDatasFinal = Collections.unmodifiableMap(formDatasFinal);
            }
            this.formDatas = formDatasFinal;
        }
        return this.formDatas;
    }

    @Override
    public List<String> getFormData(String name) {
        List<String> values = this.getFormDatas().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    @Override
    public String getFormDataFirst(String name) {
        List<String> values = this.getFormData(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Map<String, List<File>> getUploadedFiles() {
        if (this.uploadedFiles == null) {
            Map<String, List<File>> uploadedFilesServer = this.getServer().getUploadedFiles(this.getExchange());
            Map<String, List<File>> uploadedFilesFinal = new HashMap<String, List<File>>();
            if (uploadedFilesServer == null) {
                uploadedFilesServer = Collections.emptyMap();
            } else {
                for (Map.Entry<String, List<File>> entry : uploadedFilesServer.entrySet()) {
                    if (entry.getValue() == null) {
                        uploadedFilesFinal.put(entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    uploadedFilesFinal.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
                }
                uploadedFilesFinal = Collections.unmodifiableMap(uploadedFilesFinal);
            }
            this.uploadedFiles = uploadedFilesFinal;
        }
        return this.uploadedFiles;
    }

    @Override
    public List<File> getUploadedFiles(String name) {
        List<File> files = this.getUploadedFiles().get(name);
        if (files == null) {
            files = Collections.emptyList();
        }
        return files;
    }

    @Override
    public File getUploadedFileFirst(String name) {
        List<File> files = this.getUploadedFiles(name);
        if (files.size() > 0) {
            return files.get(0);
        }
        return null;
    }

    @Override
    public Locale getLocaleBestMatch() {
        String header = this.getHeaderFirst("Accept-Language");
        Locale locale = this.getSpincastUtils().getLocaleBestMatchFromAcceptLanguageHeader(header);
        if (locale == null) {
            locale = this.getSpincastConfig().getDefaultLocale();
        }
        return locale;
    }

    @Override
    public String getContentType() {
        String contentType = this.getHeaderFirst("Content-Type");
        return contentType;
    }
}

