/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.spincast.core.exchange.IDefaultRequestContext;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.guice.SpincastPluginGuiceModuleBase;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IRoute;
import org.spincast.core.routing.IRouteBuilder;
import org.spincast.core.routing.IRouteBuilderFactory;
import org.spincast.core.routing.IRouteHandlerMatch;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IRoutingRequestContextAddon;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceBuilder;
import org.spincast.core.routing.IStaticResourceBuilderFactory;
import org.spincast.core.routing.IStaticResourceCorsConfig;
import org.spincast.core.websocket.IDefaultWebsocketContext;
import org.spincast.core.websocket.IWebsocketRoute;
import org.spincast.core.websocket.IWebsocketRouteBuilder;
import org.spincast.core.websocket.IWebsocketRouteBuilderFactory;
import org.spincast.core.websocket.IWebsocketRouteHandlerFactory;
import org.spincast.core.websocket.WebsocketRouteHandler;
import org.spincast.plugins.routing.DefaultRouter;
import org.spincast.plugins.routing.IDefaultRouter;
import org.spincast.plugins.routing.IRouteFactory;
import org.spincast.plugins.routing.IRouteHandlerMatchFactory;
import org.spincast.plugins.routing.ISpincastRouterConfig;
import org.spincast.plugins.routing.IStaticResourceCorsConfigFactory;
import org.spincast.plugins.routing.IStaticResourceFactory;
import org.spincast.plugins.routing.IWebsocketRouteFactory;
import org.spincast.plugins.routing.RouteBuilder;
import org.spincast.plugins.routing.RouteHandlerMatch;
import org.spincast.plugins.routing.SpincastRoute;
import org.spincast.plugins.routing.SpincastRouter;
import org.spincast.plugins.routing.SpincastRoutingRequestContextAddon;
import org.spincast.plugins.routing.SpincastWebsocketRoute;
import org.spincast.plugins.routing.StaticResource;
import org.spincast.plugins.routing.StaticResourceBuilder;
import org.spincast.plugins.routing.StaticResourceCorsConfig;
import org.spincast.plugins.routing.WebsocketRouteBuilder;

public class SpincastRoutingPluginGuiceModule
extends SpincastPluginGuiceModuleBase {
    public SpincastRoutingPluginGuiceModule(Type requestContextType, Type websocketContextType) {
        super(requestContextType, websocketContextType);
    }

    @Override
    protected void configure() {
        this.validateRequirements();
        this.bindRouter();
        this.bindRouteFactory();
        this.bindRouteBuilderFactory();
        this.bindRouteHandlerMatchFactory();
        this.bindStaticResourceFactory();
        this.bindStaticResourceBuilderFactory();
        this.bindStaticResourceCorsConfigFactory();
        this.bindRequestContextAddon();
        this.bindWebsocketRouteFactory();
        this.bindWebsocketRouteBuilderFactory();
        this.bindWebsocketRouteHandlerFactory();
    }

    protected void validateRequirements() {
        this.requireBinding(ISpincastRouterConfig.class);
    }

    protected Key<?> getRouterImplementationKey() {
        if (this.getRequestContextType().equals(IDefaultRequestContext.class) && this.getWebsocketContextType().equals(IDefaultWebsocketContext.class)) {
            return Key.get(DefaultRouter.class);
        }
        return this.parameterizeWithContextInterfaces(SpincastRouter.class);
    }

    protected Key<?> getRouteKey() {
        return this.parameterizeWithContextInterfaces(SpincastRoute.class);
    }

    protected Key<?> getWebsocketRouteKey() {
        return this.parameterizeWithContextInterfaces(SpincastWebsocketRoute.class);
    }

    protected Key<?> getStaticResourceKey() {
        return this.parameterizeWithContextInterfaces(StaticResource.class);
    }

    protected void bindRouter() {
        Key<?> key = this.getRouterImplementationKey();
        try {
            key.getTypeLiteral().getSupertype(IRouter.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The router Key must implement " + IRouter.class.getName() + " : " + key);
        }
        this.bind(key).in(Scopes.SINGLETON);
        this.bind(this.parameterizeWithContextInterfaces(IRouter.class)).to(key).in(Scopes.SINGLETON);
        this.bind(IRouter.class).to(key).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<IRouter<?, ?>>(){}).to(key).in(Scopes.SINGLETON);
        if (this.getRequestContextType().equals(IDefaultRequestContext.class) && IDefaultRouter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
            this.bind(IDefaultRouter.class).to(key).in(Scopes.SINGLETON);
        }
    }

    protected void bindRouteFactory() {
        Key<?> key = this.getRouteKey();
        try {
            key.getTypeLiteral().getSupertype(IRoute.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The route Key must implement " + IRoute.class.getName() + " : " + key);
        }
        Key<IRoute> routeKey = this.parameterizeWithRequestContext(IRoute.class);
        Key<IRouteFactory> factoryKey = this.parameterizeWithRequestContext(IRouteFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(routeKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(routeKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindWebsocketRouteFactory() {
        Key<?> key = this.getWebsocketRouteKey();
        try {
            key.getTypeLiteral().getSupertype(IWebsocketRoute.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The websocket route Key must implement " + IWebsocketRoute.class.getName() + " : " + key);
        }
        Key<IWebsocketRoute> routeKey = this.parameterizeWithContextInterfaces(IWebsocketRoute.class);
        Key<IWebsocketRouteFactory> factoryKey = this.parameterizeWithContextInterfaces(IWebsocketRouteFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(routeKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(routeKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindRouteBuilderFactory() {
        Key<IRouteBuilder> interfaceKey = this.parameterizeWithRequestContext(IRouteBuilder.class);
        Key<? extends IRouteBuilder> implementationKey = this.parameterizeWithContextInterfaces(this.getRouteBuilderImplClass());
        Key<IRouteBuilderFactory> factoryKey = this.parameterizeWithContextInterfaces(IRouteBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IRouteBuilder> getRouteBuilderImplClass() {
        return RouteBuilder.class;
    }

    protected void bindWebsocketRouteBuilderFactory() {
        Key<IWebsocketRouteBuilder> interfaceKey = this.parameterizeWithContextInterfaces(IWebsocketRouteBuilder.class);
        Key<? extends IWebsocketRouteBuilder> implementationKey = this.parameterizeWithContextInterfaces(this.getWebsocketRouteBuilderImplClass());
        Key<IWebsocketRouteBuilderFactory> factoryKey = this.parameterizeWithContextInterfaces(IWebsocketRouteBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IWebsocketRouteBuilder> getWebsocketRouteBuilderImplClass() {
        return WebsocketRouteBuilder.class;
    }

    protected void bindWebsocketRouteHandlerFactory() {
        Key<IHandler> interfaceKey = this.parameterizeWithRequestContext(IHandler.class);
        Key<? extends IHandler> implementationKey = this.parameterizeWithContextInterfaces(this.getWebsocketRouteHandlerImplClass());
        Key<IWebsocketRouteHandlerFactory> factoryKey = this.parameterizeWithContextInterfaces(IWebsocketRouteHandlerFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IHandler> getWebsocketRouteHandlerImplClass() {
        return WebsocketRouteHandler.class;
    }

    protected void bindRouteHandlerMatchFactory() {
        Key<IRouteHandlerMatch> interfaceKey = this.parameterizeWithRequestContext(IRouteHandlerMatch.class);
        Key<? extends IRouteHandlerMatch> implementationKey = this.parameterizeWithRequestContext(this.getRouteHandlerMatchImplClass());
        Key<IRouteHandlerMatchFactory> factoryKey = this.parameterizeWithRequestContext(IRouteHandlerMatchFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IRouteHandlerMatch> getRouteHandlerMatchImplClass() {
        return RouteHandlerMatch.class;
    }

    protected void bindStaticResourceFactory() {
        Key<?> key = this.getStaticResourceKey();
        try {
            key.getTypeLiteral().getSupertype(IStaticResource.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The static resource Key must implement " + IStaticResource.class.getName() + " : " + key);
        }
        Key<IStaticResource> staticResourceKey = this.parameterizeWithRequestContext(IStaticResource.class);
        Key<IStaticResourceFactory> factoryKey = this.parameterizeWithRequestContext(IStaticResourceFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(staticResourceKey.getTypeLiteral(), annotation, key.getTypeLiteral()).build(factoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(staticResourceKey, key.getTypeLiteral()).build(factoryKey));
        }
    }

    protected void bindStaticResourceBuilderFactory() {
        Key<IStaticResourceBuilder> interfaceKey = this.parameterizeWithRequestContext(IStaticResourceBuilder.class);
        Key<? extends IStaticResourceBuilder> implementationKey = this.parameterizeWithContextInterfaces(this.getStaticResourceBuilderImplClass());
        Key<IStaticResourceBuilderFactory> factoryKey = this.parameterizeWithContextInterfaces(IStaticResourceBuilderFactory.class);
        this.install(new FactoryModuleBuilder().implement(interfaceKey, implementationKey.getTypeLiteral()).build(factoryKey));
    }

    protected Class<? extends IStaticResourceBuilder> getStaticResourceBuilderImplClass() {
        return StaticResourceBuilder.class;
    }

    protected void bindStaticResourceCorsConfigFactory() {
        this.install(new FactoryModuleBuilder().implement(IStaticResourceCorsConfig.class, this.getStaticResourceCorsConfigImplClass()).build(IStaticResourceCorsConfigFactory.class));
    }

    protected Class<? extends IStaticResourceCorsConfig> getStaticResourceCorsConfigImplClass() {
        return StaticResourceCorsConfig.class;
    }

    protected void bindRequestContextAddon() {
        this.bind(this.parameterizeWithRequestContext(IRoutingRequestContextAddon.class)).to(this.parameterizeWithContextInterfaces(SpincastRoutingRequestContextAddon.class)).in(SpincastGuiceScopes.REQUEST);
    }
}

