/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.AssistedInject;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spincast.plugins.undertow.ISpincastHttpAuthIdentityManager;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.auth.BasicUserPrincipal;

public class SpincastHttpAuthIdentityManager
implements ISpincastHttpAuthIdentityManager {
    private final Map<String, PasswordCredential> credentials = new HashMap<String, PasswordCredential>();
    private final Map<PasswordCredential, Account> accounts = new HashMap<PasswordCredential, Account>();

    @AssistedInject
    public SpincastHttpAuthIdentityManager() {
    }

    protected Map<String, PasswordCredential> getCredentials() {
        return this.credentials;
    }

    protected Map<PasswordCredential, Account> getAccounts() {
        return this.accounts;
    }

    @Override
    public void addUser(String username, String password) {
        if (StringUtils.isBlank(username)) {
            throw new RuntimeException("The username can't be empty");
        }
        if (StringUtils.isBlank(password)) {
            throw new RuntimeException("The password can't be empty");
        }
        PasswordCredential passwordCredential = new PasswordCredential(password.toCharArray());
        this.getCredentials().put(username, passwordCredential);
        this.getAccounts().put(passwordCredential, this.createAccount(username));
    }

    protected Account createAccount(final String username) {
        return new Account(){

            @Override
            public Set<String> getRoles() {
                return Collections.emptySet();
            }

            @Override
            public Principal getPrincipal() {
                return new BasicUserPrincipal(username);
            }
        };
    }

    @Override
    public void removeUser(String username) {
        PasswordCredential credential = this.getCredentials().get(username);
        if (credential == null) {
            return;
        }
        this.getCredentials().remove(username);
        this.getAccounts().remove(credential);
    }

    @Override
    public void removeAllUsers() {
        this.getCredentials().clear();
        this.getAccounts().clear();
    }

    @Override
    public Account verify(Account account) {
        return account;
    }

    @Override
    public Account verify(Credential credential) {
        if (!(credential instanceof PasswordCredential)) {
            return null;
        }
        Account account = this.getAccounts().get(credential);
        return account;
    }

    @Override
    public Account verify(String username, Credential credential) {
        if (!this.getCredentials().containsKey(username)) {
            return null;
        }
        if (!(credential instanceof PasswordCredential)) {
            return null;
        }
        PasswordCredential savedCredential = this.getCredentials().get(username);
        if (!Arrays.equals(savedCredential.getPassword(), ((PasswordCredential)credential).getPassword())) {
            return null;
        }
        return this.getAccounts().get(savedCredential);
    }
}

