/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.reflect.Type;
import org.spincast.core.guice.SpincastPluginGuiceModuleBase;
import org.spincast.core.server.IServer;
import org.spincast.plugins.undertow.CorsHandler;
import org.spincast.plugins.undertow.FileClassPathResourceManager;
import org.spincast.plugins.undertow.GzipCheckerHandler;
import org.spincast.plugins.undertow.ICorsHandler;
import org.spincast.plugins.undertow.ICorsHandlerFactory;
import org.spincast.plugins.undertow.IFileClassPathResourceManager;
import org.spincast.plugins.undertow.IFileClassPathResourceManagerFactory;
import org.spincast.plugins.undertow.IGzipCheckerHandler;
import org.spincast.plugins.undertow.IGzipCheckerHandlerFactory;
import org.spincast.plugins.undertow.ISpincastHttpAuthIdentityManager;
import org.spincast.plugins.undertow.ISpincastHttpAuthIdentityManagerFactory;
import org.spincast.plugins.undertow.ISpincastUndertowUtils;
import org.spincast.plugins.undertow.IUndertowWebsocketEndpointWriter;
import org.spincast.plugins.undertow.IUndertowWebsocketEndpointWriterFactory;
import org.spincast.plugins.undertow.IWebsocketEndpoint;
import org.spincast.plugins.undertow.IWebsocketEndpointFactory;
import org.spincast.plugins.undertow.SpincastHttpAuthIdentityManager;
import org.spincast.plugins.undertow.SpincastUndertowServer;
import org.spincast.plugins.undertow.SpincastUndertowUtils;
import org.spincast.plugins.undertow.SpincastUndertowWebsocketEndpointWriter;
import org.spincast.plugins.undertow.SpincastWebsocketEndpoint;

public class SpincastUndertowPluginGuiceModule
extends SpincastPluginGuiceModuleBase {
    public SpincastUndertowPluginGuiceModule(Type requestContextType, Type websocketContextType) {
        super(requestContextType, websocketContextType);
    }

    @Override
    protected void configure() {
        this.bind(IServer.class).to(this.getSpincastUndertowServerClass()).in(Scopes.SINGLETON);
        this.bindSpincastUndertowUtils();
        this.bindCorsHandlerFactory();
        this.bindGzipCheckerHandlerFactory();
        this.bindFileClassPathResourceManagerFactory();
        this.bindHttpAuthIdentityManagerFactory();
        this.bindUndertowWebsocketEndpointWriterFactory();
        this.bindWebsocketEndpointFactory();
    }

    protected void bindSpincastUndertowUtils() {
        this.bind(ISpincastUndertowUtils.class).to(this.getSpincastUndertowUtilsClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends ISpincastUndertowUtils> getSpincastUndertowUtilsClass() {
        return SpincastUndertowUtils.class;
    }

    protected Class<? extends IServer> getSpincastUndertowServerClass() {
        return SpincastUndertowServer.class;
    }

    protected void bindCorsHandlerFactory() {
        this.install(new FactoryModuleBuilder().implement(ICorsHandler.class, this.getCorsHandlerClass()).build(ICorsHandlerFactory.class));
    }

    protected Class<? extends ICorsHandler> getCorsHandlerClass() {
        return CorsHandler.class;
    }

    protected void bindGzipCheckerHandlerFactory() {
        this.install(new FactoryModuleBuilder().implement(IGzipCheckerHandler.class, this.getGzipCheckerHandlerClass()).build(IGzipCheckerHandlerFactory.class));
    }

    protected Class<? extends IGzipCheckerHandler> getGzipCheckerHandlerClass() {
        return GzipCheckerHandler.class;
    }

    protected void bindFileClassPathResourceManagerFactory() {
        this.install(new FactoryModuleBuilder().implement(IFileClassPathResourceManager.class, this.getFileClassPathResourceManagerClass()).build(IFileClassPathResourceManagerFactory.class));
    }

    protected Class<? extends IFileClassPathResourceManager> getFileClassPathResourceManagerClass() {
        return FileClassPathResourceManager.class;
    }

    protected void bindHttpAuthIdentityManagerFactory() {
        this.install(new FactoryModuleBuilder().implement(ISpincastHttpAuthIdentityManager.class, this.getSpincastHttpAuthIdentityManagerClass()).build(ISpincastHttpAuthIdentityManagerFactory.class));
    }

    protected Class<? extends ISpincastHttpAuthIdentityManager> getSpincastHttpAuthIdentityManagerClass() {
        return SpincastHttpAuthIdentityManager.class;
    }

    protected void bindUndertowWebsocketEndpointWriterFactory() {
        this.install(new FactoryModuleBuilder().implement(IUndertowWebsocketEndpointWriter.class, this.getUndertowWebsocketEndpointWriterClass()).build(IUndertowWebsocketEndpointWriterFactory.class));
    }

    protected Class<? extends IUndertowWebsocketEndpointWriter> getUndertowWebsocketEndpointWriterClass() {
        return SpincastUndertowWebsocketEndpointWriter.class;
    }

    protected void bindWebsocketEndpointFactory() {
        this.install(new FactoryModuleBuilder().implement(IWebsocketEndpoint.class, this.getWebsocketEndpointClass()).build(IWebsocketEndpointFactory.class));
    }

    protected Class<? extends IWebsocketEndpoint> getWebsocketEndpointClass() {
        return SpincastWebsocketEndpoint.class;
    }
}

