/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.websocket;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.server.IServer;
import org.spincast.core.websocket.IWebsocketContext;
import org.spincast.core.websocket.IWebsocketContextFactory;
import org.spincast.core.websocket.IWebsocketController;
import org.spincast.core.websocket.IWebsocketEndpointHandler;
import org.spincast.core.websocket.IWebsocketEndpointManager;
import org.spincast.core.websocket.IWebsocketPeerManager;

public class WebsocketEndpointHandler<R extends IRequestContext<?>, W extends IWebsocketContext<?>>
implements IWebsocketEndpointHandler {
    protected final Logger logger = LoggerFactory.getLogger(WebsocketEndpointHandler.class);
    private final IServer server;
    private final String endpointId;
    private final IWebsocketController<R, W> controller;
    private IWebsocketEndpointManager endpointManager;
    private final IWebsocketContextFactory<W> websocketContextFactory;
    private final Map<String, W> peerContextesMap = new HashMap<String, W>();

    @AssistedInject
    public WebsocketEndpointHandler(@Assisted(value="endpointId") String endpointId, @Assisted IWebsocketController<R, W> controller, IWebsocketContextFactory<W> websocketContextFactory, IServer server) {
        this.endpointId = endpointId;
        this.controller = controller;
        this.websocketContextFactory = websocketContextFactory;
        this.server = server;
    }

    protected String getEndpointId() {
        return this.endpointId;
    }

    protected IWebsocketController<R, W> getController() {
        return this.controller;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected IWebsocketEndpointManager getEndpointManager() {
        if (this.endpointManager == null) {
            this.endpointManager = this.getServer().getWebsocketEndpointManager(this.getEndpointId());
        }
        return this.endpointManager;
    }

    protected IWebsocketContextFactory<W> getWebsocketContextFactory() {
        return this.websocketContextFactory;
    }

    protected Map<String, W> getPeerContextesMap() {
        return this.peerContextesMap;
    }

    protected W getWebsocketPeerContext(String peerId) {
        IWebsocketContext peerContext = (IWebsocketContext)this.getPeerContextesMap().get(peerId);
        if (peerContext == null) {
            if (this.getEndpointManager() == null) {
                throw new RuntimeException("The endpoint manager is null, we can't create a Websocket context.");
            }
            IWebsocketPeerManager peerWriter = this.createWebsocketPeerManager(peerId);
            peerContext = this.getWebsocketContextFactory().create(this.getEndpointId(), peerId, peerWriter);
            this.getPeerContextesMap().put(peerId, peerContext);
        }
        return (W)peerContext;
    }

    @Override
    public void onPeerConnected(String peerId) {
        this.getController().onPeerConnected(this.getWebsocketPeerContext(peerId));
    }

    @Override
    public void onPeerMessage(String peerId, String message) {
        if (this.getEndpointManager() == null) {
            this.logger.error("The Websocket manager is null! Skipping message from peer '" + peerId + "': " + message);
            return;
        }
        this.getController().onPeerMessage(this.getWebsocketPeerContext(peerId), message);
    }

    @Override
    public void onPeerMessage(String peerId, byte[] message) {
        if (this.getEndpointManager() == null) {
            this.logger.error("The Websocket manager is null! Skipping bytes message from peer '" + peerId);
            return;
        }
        this.getController().onPeerMessage(this.getWebsocketPeerContext(peerId), message);
    }

    @Override
    public void onEndpointClosed() {
        this.getController().onEndpointClosed(this.getEndpointId());
    }

    @Override
    public void onPeerClosed(String peerId) {
        try {
            this.getController().onPeerClosed(this.getWebsocketPeerContext(peerId));
        }
        finally {
            this.getPeerContextesMap().remove(peerId);
        }
    }

    protected IWebsocketPeerManager createWebsocketPeerManager(final String peerId) {
        final IWebsocketEndpointManager endpointManager = this.getEndpointManager();
        return new IWebsocketPeerManager(){

            @Override
            public void sendMessage(String message) {
                endpointManager.sendMessage(peerId, message);
            }

            @Override
            public void sendMessage(byte[] bytes) {
                endpointManager.sendMessage(peerId, bytes);
            }

            @Override
            public void closeConnection() {
                try {
                    endpointManager.closePeer(peerId);
                }
                finally {
                    WebsocketEndpointHandler.this.getPeerContextesMap().remove(peerId);
                }
            }
        };
    }
}

