/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.websocket.IWebsocketEndpointHandler;
import org.spincast.plugins.undertow.IClosedEventSentCallback;
import org.spincast.plugins.undertow.ISpincastUndertowUtils;
import org.spincast.plugins.undertow.IUndertowWebsocketEndpointWriter;
import org.spincast.plugins.undertow.IUndertowWebsocketEndpointWriterFactory;
import org.spincast.plugins.undertow.IWebsocketEndpoint;
import org.spincast.plugins.undertow.IWebsocketPeersWriteCallback;
import org.spincast.plugins.undertow.config.ISpincastUndertowConfig;

public class SpincastWebsocketEndpoint
implements IWebsocketEndpoint {
    protected final Logger logger = LoggerFactory.getLogger(SpincastWebsocketEndpoint.class);
    public static final String EXCHANGE_VARIABLE_PEER_ID = SpincastWebsocketEndpoint.class.getName() + "_peerId";
    private final IUndertowWebsocketEndpointWriterFactory undertowWebsocketEndpointWriterFactory;
    private final String endpointId;
    private final Map<String, WebSocketChannel> webSocketChannelByPeerId = new ConcurrentHashMap<String, WebSocketChannel>();
    private final IWebsocketEndpointHandler eventsHandler;
    private final ISpincastUndertowConfig spincastUndertowConfig;
    private final ISpincastUndertowUtils spincastUndertowUtils;
    private IUndertowWebsocketEndpointWriter websocketWriter;
    private volatile Thread pingSenderThread = null;
    private volatile boolean endpointIsClosed = false;
    private WebSocketProtocolHandshakeHandler webSocketProtocolHandshakeHandler;
    private ExecutorService threadExecutorForAppEvents;
    private final Map<String, Object> peerIdCreationLocks = new ConcurrentHashMap<String, Object>();
    private final Object peerIdCreationLocksCreationLock = new Object();

    @AssistedInject
    public SpincastWebsocketEndpoint(@Assisted String endpointId, @Assisted IWebsocketEndpointHandler eventsHandler, IUndertowWebsocketEndpointWriterFactory undertowWebsocketEndpointWriterFactory, ISpincastUndertowConfig spincastUndertowConfig, ISpincastUndertowUtils spincastUndertowUtils) {
        this.endpointId = endpointId;
        this.eventsHandler = eventsHandler;
        this.undertowWebsocketEndpointWriterFactory = undertowWebsocketEndpointWriterFactory;
        this.spincastUndertowConfig = spincastUndertowConfig;
        this.spincastUndertowUtils = spincastUndertowUtils;
    }

    @Inject
    protected void init() {
        if (this.getSpincastUndertowConfig().isWebsocketAutomaticPing()) {
            this.startSendingPings();
        }
    }

    protected Map<String, WebSocketChannel> getWebSocketChannelByPeerId() {
        return this.webSocketChannelByPeerId;
    }

    protected IWebsocketEndpointHandler getEventsHandler() {
        return this.eventsHandler;
    }

    protected IUndertowWebsocketEndpointWriterFactory getUndertowWebsocketEndpointWriterFactory() {
        return this.undertowWebsocketEndpointWriterFactory;
    }

    protected ISpincastUndertowConfig getSpincastUndertowConfig() {
        return this.spincastUndertowConfig;
    }

    protected ISpincastUndertowUtils getSpincastUndertowUtils() {
        return this.spincastUndertowUtils;
    }

    protected IUndertowWebsocketEndpointWriter getUndertowWebsocketWriter() {
        if (this.websocketWriter == null) {
            this.websocketWriter = this.getUndertowWebsocketEndpointWriterFactory().create(this.getWebSocketChannelByPeerId());
        }
        return this.websocketWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getNewPeerIdLock(String peerId) {
        Object lock = this.peerIdCreationLocks.get(peerId);
        if (lock == null) {
            Object object = this.peerIdCreationLocksCreationLock;
            synchronized (object) {
                lock = this.peerIdCreationLocks.get(peerId);
                if (lock == null) {
                    lock = new Object();
                    this.peerIdCreationLocks.put(peerId, lock);
                }
            }
        }
        return lock;
    }

    @Override
    public String getEndpointId() {
        return this.endpointId;
    }

    @Override
    public Set<String> getPeersIds() {
        return Collections.unmodifiableSet(this.getWebSocketChannelByPeerId().keySet());
    }

    @Override
    public void closePeer(String peerId) {
        this.closePeer(peerId, this.getSpincastUndertowConfig().getWebsocketDefaultClosingCode(), this.getSpincastUndertowConfig().getWebsocketDefaultClosingReason());
    }

    @Override
    public void closePeer(final String peerId, int closingCode, String closingReason) {
        this.validateWebsocketClosingCode(closingCode);
        try {
            IClosedEventSentCallback callback = new IClosedEventSentCallback(){

                @Override
                public void done() {
                    SpincastWebsocketEndpoint.this.removePeerChannelAndSendPeerClosedAppEvent(peerId);
                }
            };
            this.getUndertowWebsocketWriter().sendClosingConnection(closingCode, closingReason, Sets.newHashSet(peerId), callback);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void removePeerChannelAndSendPeerClosedAppEvent(String peerId) {
        try {
            WebSocketChannel webSocketChannel = this.getWebSocketChannelByPeerId().get(peerId);
            if (webSocketChannel != null) {
                if (webSocketChannel.isOpen()) {
                    webSocketChannel.close();
                }
                this.getWebSocketChannelByPeerId().remove(peerId);
                Set<WebSocketChannel> peerConnections = this.getWebSocketProtocolHandshakeHandler().getPeerConnections();
                if (peerConnections != null) {
                    peerConnections.remove(webSocketChannel);
                }
            }
            this.sendPeerClosedAppEvent(peerId);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void managePeersWriteConnectionClosed(Set<String> peerIds) {
        if (peerIds == null || peerIds.size() == 0) {
            return;
        }
        for (String peerId : peerIds) {
            this.removePeerChannelAndSendPeerClosedAppEvent(peerId);
        }
    }

    @Override
    public void closeEndpoint() {
        int closingCode = this.getSpincastUndertowConfig().getWebsocketDefaultClosingCode();
        String closingReason = this.getSpincastUndertowConfig().getWebsocketDefaultClosingReason();
        this.closeEndpoint(closingCode, closingReason);
    }

    @Override
    public synchronized void closeEndpoint(int closingCode, String closingReason) {
        this.validateWebsocketClosingCode(closingCode);
        if (closingReason == null) {
            closingReason = "";
        }
        if (this.endpointIsClosed) {
            this.logger.info("Endpoint '" + this.getEndpointId() + "' is already closed...");
            return;
        }
        this.endpointIsClosed = true;
        IClosedEventSentCallback callback = new IClosedEventSentCallback(){

            @Override
            public void done() {
                for (String peerId : SpincastWebsocketEndpoint.this.getWebSocketChannelByPeerId().keySet()) {
                    try {
                        SpincastWebsocketEndpoint.this.removePeerChannelAndSendPeerClosedAppEvent(peerId);
                    }
                    catch (Exception ex) {
                        SpincastWebsocketEndpoint.this.logger.error("Error closing peer '" + peerId + "' on endpoint '" + SpincastWebsocketEndpoint.this.getEndpointId() + "': " + ex.getMessage());
                    }
                }
                SpincastWebsocketEndpoint.this.getEventsHandler().onEndpointClosed();
            }
        };
        this.getUndertowWebsocketWriter().sendClosingConnection(closingCode, closingReason, this.getWebSocketChannelByPeerId().keySet(), callback);
    }

    protected void validateWebsocketClosingCode(int closingCode) {
        if (!CloseMessage.isValid(closingCode)) {
            throw new RuntimeException("The Websocket endpoint closing code '" + closingCode + "' is not valid. " + "Please look at http://tools.ietf.org/html/rfc6455#section-7.4");
        }
    }

    protected void startSendingPings() {
        this.pingSenderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(SpincastWebsocketEndpoint.this.getSpincastUndertowConfig().getWebsocketAutomaticPingIntervalSeconds() * 1000);
                    }
                    catch (Exception ex) {
                        SpincastWebsocketEndpoint.this.logger.warn("Exception sleeping the thread: " + ex.getMessage());
                    }
                    if (SpincastWebsocketEndpoint.this.endpointIsClosed || SpincastWebsocketEndpoint.this.pingSenderThread == null || SpincastWebsocketEndpoint.this.pingSenderThread != Thread.currentThread()) break;
                    SpincastWebsocketEndpoint.this.getUndertowWebsocketWriter().sendPings(new IWebsocketPeersWriteCallback(){

                        @Override
                        public void connectionClosed(Set<String> peerids) {
                            SpincastWebsocketEndpoint.this.managePeersWriteConnectionClosed(peerids);
                        }
                    });
                }
            }
        });
        this.pingSenderThread.start();
    }

    protected void stopSendingPings() {
        this.pingSenderThread = null;
    }

    @Override
    public void sendMessage(String message) {
        this.sendMessage(this.getPeersIds(), message);
    }

    @Override
    public void sendMessage(String peerId, String message) {
        this.sendMessage(Sets.newHashSet(peerId), message);
    }

    @Override
    public void sendMessageExcept(String peerId, String message) {
        HashSet<String> peerIds = new HashSet<String>(this.getPeersIds());
        peerIds.remove(peerId);
        this.sendMessage(peerIds, message);
    }

    @Override
    public void sendMessageExcept(Set<String> peerIdsToRemove, String message) {
        HashSet<String> peerIds = new HashSet<String>(this.getPeersIds());
        peerIds.removeAll(peerIdsToRemove);
        this.sendMessage(peerIds, message);
    }

    @Override
    public void sendMessage(Set<String> peerIds, String message) {
        if (this.endpointIsClosed) {
            this.logger.warn("Endpoint '" + this.getEndpointId() + "' is closed...");
            return;
        }
        this.getUndertowWebsocketWriter().sendMessage(peerIds, message, new IWebsocketPeersWriteCallback(){

            @Override
            public void connectionClosed(Set<String> peerIds) {
                SpincastWebsocketEndpoint.this.managePeersWriteConnectionClosed(peerIds);
            }
        });
    }

    @Override
    public void sendMessage(byte[] message) {
        this.sendMessage(this.getPeersIds(), message);
    }

    @Override
    public void sendMessage(String peerId, byte[] message) {
        this.sendMessage(Sets.newHashSet(peerId), message);
    }

    @Override
    public void sendMessageExcept(String peerId, byte[] message) {
        HashSet<String> peerIds = new HashSet<String>(this.getPeersIds());
        peerIds.remove(peerId);
        this.sendMessage(peerIds, message);
    }

    @Override
    public void sendMessageExcept(Set<String> peerIdsToRemove, byte[] message) {
        HashSet<String> peerIds = new HashSet<String>(this.getPeersIds());
        peerIds.removeAll(peerIdsToRemove);
        this.sendMessage(peerIds, message);
    }

    @Override
    public void sendMessage(Set<String> peerIds, byte[] message) {
        if (this.endpointIsClosed) {
            this.logger.warn("Endpoint '" + this.getEndpointId() + "' is closed...");
            return;
        }
        this.getUndertowWebsocketWriter().sendMessage(peerIds, message, new IWebsocketPeersWriteCallback(){

            @Override
            public void connectionClosed(Set<String> peerIds) {
                SpincastWebsocketEndpoint.this.managePeersWriteConnectionClosed(peerIds);
            }
        });
    }

    @Override
    public void handleConnectionRequest(HttpServerExchange exchange, String peerId) {
        if (this.endpointIsClosed) {
            this.logger.warn("Endpoint '" + this.getEndpointId() + "' is closed...");
            return;
        }
        try {
            if (this.getWebSocketChannelByPeerId().containsKey(peerId)) {
                throw new RuntimeException("The Websocket endpoint '" + this.endpointId + "' is already used by a peer with " + "id '" + peerId + "'! Close the existing peer if you want to reuse this id.");
            }
            this.getSpincastUndertowUtils().getRequestCustomVariables(exchange).put(EXCHANGE_VARIABLE_PEER_ID, peerId);
            this.getWebSocketProtocolHandshakeHandler().handleRequest(exchange);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected WebSocketProtocolHandshakeHandler getWebSocketProtocolHandshakeHandler() {
        if (this.webSocketProtocolHandshakeHandler == null) {
            this.webSocketProtocolHandshakeHandler = new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                    final String peerId = SpincastWebsocketEndpoint.this.getSpincastUndertowUtils().getRequestCustomVariables(exchange).get(EXCHANGE_VARIABLE_PEER_ID);
                    if (SpincastWebsocketEndpoint.this.endpointIsClosed) {
                        SpincastWebsocketEndpoint.this.logger.warn("The endpoint is closed, the peer '" + peerId + "' onConnect() won't be handled.");
                        return;
                    }
                    boolean peerIdAlreadyUsed = false;
                    if (!SpincastWebsocketEndpoint.this.getWebSocketChannelByPeerId().containsKey(peerId)) {
                        Object newPeerIdLock;
                        Object object = newPeerIdLock = SpincastWebsocketEndpoint.this.getNewPeerIdLock(peerId);
                        synchronized (object) {
                            if (!SpincastWebsocketEndpoint.this.getWebSocketChannelByPeerId().containsKey(peerId)) {
                                SpincastWebsocketEndpoint.this.getWebSocketChannelByPeerId().put(peerId, channel);
                            } else {
                                peerIdAlreadyUsed = true;
                            }
                        }
                    } else {
                        peerIdAlreadyUsed = true;
                    }
                    if (peerIdAlreadyUsed) {
                        SpincastWebsocketEndpoint.this.logger.warn("The Websocket endpoint '" + SpincastWebsocketEndpoint.this.getEndpointId() + "' is already used by a peer with " + "id '" + peerId + "'! The new connection will be closed.");
                        try {
                            WebSockets.sendClose(1011, "Duplicate peer id", channel, null);
                            if (channel.isOpen()) {
                                channel.close();
                            }
                        }
                        catch (Exception ex) {
                            SpincastWebsocketEndpoint.this.logger.error("Error closing the duplicate '" + peerId + "' peer's Websocket connection: " + ex.getMessage());
                        }
                        return;
                    }
                    channel.getReceiveSetter().set(new AbstractReceiveListener(){

                        @Override
                        protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage bufferedTextMessage) throws IOException {
                            String message = bufferedTextMessage.getData();
                            if (SpincastWebsocketEndpoint.this.endpointIsClosed) {
                                SpincastWebsocketEndpoint.this.logger.warn("The endpoint is closed, the received message from peer '" + peerId + "' won't be handled: " + message);
                                return;
                            }
                            SpincastWebsocketEndpoint.this.sendOnStringMessageAppEvent(peerId, message);
                        }

                        @Override
                        protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                            if (SpincastWebsocketEndpoint.this.endpointIsClosed) {
                                SpincastWebsocketEndpoint.this.logger.warn("The endpoint is closed, the received bytes message from peer '" + peerId + "' won't be handled");
                                return;
                            }
                            ByteBuffer[] byteBuffersArray = message.getData().getResource();
                            ByteBuffer byteBuffer = WebSockets.mergeBuffers(byteBuffersArray);
                            SpincastWebsocketEndpoint.this.sendOnBytesMessageAppEvent(peerId, byteBuffer.array());
                        }

                        @Override
                        protected void onCloseMessage(CloseMessage cm, WebSocketChannel channel) {
                            if (SpincastWebsocketEndpoint.this.endpointIsClosed) {
                                return;
                            }
                            try {
                                SpincastWebsocketEndpoint.this.removePeerChannelAndSendPeerClosedAppEvent(peerId);
                            }
                            catch (Exception ex) {
                                SpincastWebsocketEndpoint.this.logger.error("Error closing peer '" + peerId + "' on endpoint '" + SpincastWebsocketEndpoint.this.getEndpointId() + "': " + ex.getMessage());
                            }
                        }
                    });
                    channel.resumeReceives();
                    SpincastWebsocketEndpoint.this.sendOnPeerConnectedAppEvent(peerId);
                }
            });
        }
        return this.webSocketProtocolHandshakeHandler;
    }

    protected void sendOnPeerConnectedAppEvent(final String peerId) {
        if (this.endpointIsClosed) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SpincastWebsocketEndpoint.this.getEventsHandler().onPeerConnected(peerId);
            }
        };
        this.sendAppEventInNewThread(runnable);
    }

    protected void sendOnStringMessageAppEvent(final String peerId, final String message) {
        if (this.endpointIsClosed) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SpincastWebsocketEndpoint.this.getEventsHandler().onPeerMessage(peerId, message);
            }
        };
        this.sendAppEventInNewThread(runnable);
    }

    protected void sendOnBytesMessageAppEvent(final String peerId, final byte[] message) {
        if (this.endpointIsClosed) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SpincastWebsocketEndpoint.this.getEventsHandler().onPeerMessage(peerId, message);
            }
        };
        this.sendAppEventInNewThread(runnable);
    }

    protected void sendPeerClosedAppEvent(final String peerId) {
        if (this.endpointIsClosed) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SpincastWebsocketEndpoint.this.getEventsHandler().onPeerClosed(peerId);
            }
        };
        this.sendAppEventInNewThread(runnable);
    }

    protected void sendAppEventInNewThread(final Runnable runnable) {
        try {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    runnable.run();
                    return null;
                }
            };
            HashSet<11> callables = new HashSet<11>();
            callables.add(callable);
            this.getThreadExecutorForAppEvents().invokeAll(callables, this.getThreadExecutorForAppEventsTimeoutAmount(), this.getThreadExecutorForAppEventsTimeoutTimeUnit());
        }
        catch (InterruptedException ex) {
            this.logger.error("A Thread used for sending a Websocket event to the application took too long (max " + this.getThreadExecutorForAppEventsTimeoutAmount() + " " + this.getThreadExecutorForAppEventsTimeoutTimeUnit().toString() + ")" + "on endpoint " + this.getEndpointId() + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("A Thread used for sending a Websocket event to the application thrown an exception on endpoint " + this.getEndpointId() + ": " + ex.getMessage());
        }
    }

    protected int getThreadExecutorForAppEventsTimeoutAmount() {
        return this.getSpincastUndertowConfig().getWebsocketThreadExecutorForAppEventsTimeoutAmount();
    }

    protected TimeUnit getThreadExecutorForAppEventsTimeoutTimeUnit() {
        return this.getSpincastUndertowConfig().getWebsocketThreadExecutorForAppEventsTimeoutTimeUnit();
    }

    protected ExecutorService getThreadExecutorForAppEvents() {
        if (this.threadExecutorForAppEvents == null) {
            ThreadFactory threadFactory = this.getThreadExecutorForAppEventsThreadThreadFactory();
            this.threadExecutorForAppEvents = threadFactory != null ? Executors.newFixedThreadPool(this.getThreadExecutorForAppEventsThreadNumber(), threadFactory) : Executors.newFixedThreadPool(this.getThreadExecutorForAppEventsThreadNumber());
        }
        return this.threadExecutorForAppEvents;
    }

    protected int getThreadExecutorForAppEventsThreadNumber() {
        return this.getSpincastUndertowConfig().getWebsocketThreadExecutorForAppEventsThreadNumber();
    }

    protected ThreadFactory getThreadExecutorForAppEventsThreadThreadFactory() {
        return this.getSpincastUndertowConfig().getWebsocketThreadExecutorForAppEventsThreadFactory();
    }
}

