/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.controllers;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.config.ISpincastDictionary;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.controllers.IFrontController;
import org.spincast.core.exceptions.ForwardRouteException;
import org.spincast.core.exceptions.ICustomStatusCodeException;
import org.spincast.core.exceptions.IPublicException;
import org.spincast.core.exceptions.IResponseResetableException;
import org.spincast.core.exceptions.NotFoundException;
import org.spincast.core.exceptions.RedirectException;
import org.spincast.core.exceptions.SkipRemainingHandlersException;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.exchange.IRequestContextFactory;
import org.spincast.core.exchange.RequestContextType;
import org.spincast.core.guice.SpincastRequestScope;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IRouteHandlerMatch;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IRoutingResult;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.websocket.IWebsocketContext;
import org.spincast.core.xml.IXmlManager;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastFrontController<R extends IRequestContext<R>, W extends IWebsocketContext<?>>
implements IFrontController {
    protected final Logger logger = LoggerFactory.getLogger(SpincastFrontController.class);
    private final IRouter<R, W> router;
    private final ISpincastConfig spincastConfig;
    private final ISpincastDictionary spincastDictionary;
    private final IServer server;
    private final IRequestContextFactory<R> requestCreationFactory;
    private final SpincastRequestScope spincastRequestScope;
    private final Type requestContextType;
    private final IJsonManager jsonManager;
    private final IXmlManager xmlManager;

    @Inject
    public SpincastFrontController(IRouter<R, W> router, ISpincastConfig spincastConfig, ISpincastDictionary spincastDictionary, IServer server, IRequestContextFactory<R> requestCreationFactory, SpincastRequestScope spincastRequestScope, @RequestContextType Type requestContextType, IJsonManager jsonManager, IXmlManager xmlManager) {
        this.router = router;
        this.spincastConfig = spincastConfig;
        this.spincastDictionary = spincastDictionary;
        this.server = server;
        this.requestCreationFactory = requestCreationFactory;
        this.spincastRequestScope = spincastRequestScope;
        this.requestContextType = requestContextType;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
    }

    protected IRouter<R, W> getRouter() {
        return this.router;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected ISpincastDictionary getSpincastDictionary() {
        return this.spincastDictionary;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected IRequestContextFactory<R> getRequestContextFactory() {
        return this.requestCreationFactory;
    }

    protected SpincastRequestScope getSpincastRequestScope() {
        return this.spincastRequestScope;
    }

    protected Type getRequestContextType() {
        return this.requestContextType;
    }

    protected IJsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected IXmlManager getXmlManager() {
        return this.xmlManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Object exchange) {
        this.getSpincastRequestScope().enter();
        IRequestContext requestContext = null;
        IRoutingResult routingResult = null;
        try {
            exchange = this.validateExchange(exchange);
            requestContext = this.getRequestContextFactory().createRequestContext(exchange);
            this.addDependenciesInCustomRequestScope(requestContext);
            routingResult = this.findRouteMatch(requestContext);
            if (routingResult == null) {
                routingResult = this.prepareNotFoundRouting(exchange, requestContext);
            }
            try {
                this.callRouteHandlers(requestContext, routingResult);
            }
            catch (NotFoundException notFoundException) {
                if (notFoundException.isResetResponse()) {
                    this.resetResponse(requestContext);
                }
                routingResult = this.prepareNotFoundRouting(exchange, requestContext);
                requestContext.variables().add(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE, notFoundException.getMessage());
                this.callRouteHandlers(requestContext, routingResult);
            }
        }
        catch (Throwable ex) {
            try {
                if (requestContext == null) {
                    throw ex;
                }
                requestContext.variables().add(SpincastConstants.RequestScopedVariables.IS_EXCEPTION_HANDLING, true);
                requestContext.variables().add(SpincastConstants.RequestScopedVariables.IS_NOT_FOUND_ROUTE, false);
                requestContext.variables().add(SpincastConstants.RequestScopedVariables.EXCEPTION, ex);
                if (!(ex instanceof IResponseResetableException) || ((IResponseResetableException)((Object)ex)).isResetResponse()) {
                    this.resetResponse(requestContext);
                }
                if (ex instanceof ICustomStatusCodeException) {
                    requestContext.response().setStatusCode(((ICustomStatusCodeException)((Object)ex)).getStatusCode());
                } else {
                    requestContext.response().setStatusCode(500);
                }
                this.customExceptionHandling(ex, requestContext, routingResult);
            }
            catch (Throwable ex2) {
                try {
                    this.defaultExceptionHandling(exchange, ex2);
                }
                catch (Throwable ex3) {
                    this.lastResortExceptionHandling(ex, ex3);
                }
            }
        }
        finally {
            try {
                this.getSpincastRequestScope().exit();
            }
            catch (Throwable ex) {
                try {
                    this.logger.error("Error while exiting custom Guice scope : " + SpincastStatics.getStackTrace(ex));
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected IRoutingResult<R> prepareNotFoundRouting(Object exchange, R requestContext) {
        return this.prepareNotFoundRouting(exchange, requestContext, false);
    }

    protected IRoutingResult<R> prepareNotFoundRouting(Object exchange, R requestContext, boolean alreadyTried) {
        IRoutingResult<R> routingResult = this.getRouter().route(requestContext, RoutingType.NOT_FOUND);
        if (routingResult == null) {
            if (alreadyTried) {
                throw new RuntimeException("The method prepareNotFoundRouting was already tried, we called addDefaultNotFoundRoute() but there's still no Not Found route!! Full url: " + this.getServer().getFullUrlOriginal(exchange));
            }
            this.addDefaultNotFoundRoute();
            return this.prepareNotFoundRouting(exchange, requestContext, true);
        }
        requestContext.variables().add(SpincastConstants.RequestScopedVariables.IS_NOT_FOUND_ROUTE, true);
        requestContext.response().setStatusCode(404);
        return routingResult;
    }

    protected void addDefaultNotFoundRoute() {
        this.getRouter().ALL("/*{path}").notFound().save(this.getDefaultNotFoundHandler());
    }

    protected IHandler<R> getDefaultNotFoundHandler() {
        IHandler handler = new IHandler<R>(){

            @Override
            public void handle(R context) {
                String message = SpincastFrontController.this.getDefaultNotFoundHandlerNotFoundMessage();
                String customMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
                if (!StringUtils.isBlank(customMessage)) {
                    message = customMessage;
                }
                context.response().setStatusCode(404);
                if (context.request().isJsonShouldBeReturn()) {
                    context.response().sendJson(SpincastFrontController.this.getNotFoundJsonContent(message));
                } else if (context.request().isXMLShouldBeReturn()) {
                    context.response().sendXml(SpincastFrontController.this.getNotFoundXmlContent(message));
                } else if (context.request().isHTMLShouldBeReturn()) {
                    String html = SpincastFrontController.this.getNotFoundHtmlContent(message);
                    context.response().sendHtml(html);
                } else {
                    if (!context.request().isPlainTextShouldBeReturn()) {
                        SpincastFrontController.this.logger.error("Format not managed here!: " + (Object)((Object)context.request().getContentTypeBestMatch()));
                    }
                    context.response().sendPlainText(SpincastFrontController.this.getNotFoundPlainTextContent(message));
                }
            }
        };
        return handler;
    }

    protected String getNotFoundHtmlContent(String message) {
        return "<pre>" + message + "</pre>";
    }

    protected String getNotFoundJsonContent(String message) {
        IJsonObject jsonObj = this.getJsonManager().create();
        jsonObj.put("error", message);
        return jsonObj.toJsonString();
    }

    protected String getNotFoundXmlContent(String message) {
        IJsonObject jsonObj = this.getJsonManager().create();
        jsonObj.put("error", message);
        return this.getXmlManager().toXml(jsonObj);
    }

    protected String getNotFoundPlainTextContent(String message) {
        return message;
    }

    protected String getDefaultNotFoundHandlerNotFoundMessage() {
        return this.getSpincastDictionary().route_notFound_default_message();
    }

    protected void resetResponse(R requestContext) {
        if (requestContext != null && !requestContext.response().isHeadersSent()) {
            requestContext.response().resetEverything();
        }
    }

    protected void customExceptionHandling(Throwable ex, R requestContext, IRoutingResult<R> originalRoutingResult) throws Throwable {
        try {
            IRoutingResult<R> exceptionRoutingResult = this.getRouter().route(requestContext, RoutingType.EXCEPTION);
            if (exceptionRoutingResult != null) {
                requestContext.variables().add(SpincastConstants.RequestScopedVariables.ROUTING_RESULT, exceptionRoutingResult);
                requestContext.variables().add(SpincastConstants.RequestScopedVariables.ORIGINAL_ROUTING_RESULT, originalRoutingResult);
                this.callRouteHandlers(requestContext, exceptionRoutingResult);
                return;
            }
        }
        catch (Throwable ex2) {
            try {
                this.logger.error("An exception occured while using the custom exception handler. The original exception will be thrown again so it can be managed by the default exception handler. The exception which occured is : " + SpincastStatics.getStackTrace(ex2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw ex;
    }

    protected void addDependenciesInCustomRequestScope(R requestContext) {
        this.addRequestContextInCustomRequestScope(requestContext);
    }

    protected void addRequestContextInCustomRequestScope(R requestContext) {
        Key<Object> key = Key.get(new TypeLiteral<IRequestContext<?>>(){});
        this.getSpincastRequestScope().seed(key, requestContext);
        key = Key.get(this.getRequestContextType());
        this.getSpincastRequestScope().seed(key, requestContext);
    }

    protected void callRouteHandlers(R requestContext, IRoutingResult<R> routingResult) throws Exception {
        requestContext.variables().add(SpincastConstants.RequestScopedVariables.ROUTING_RESULT, routingResult);
        for (IRouteHandlerMatch<R> routeHandlerMatch : routingResult.getRouteHandlerMatches()) {
            requestContext.variables().add(SpincastConstants.RequestScopedVariables.ROUTE_HANDLER_MATCH, routeHandlerMatch);
            IHandler<R> handlerMethod = routeHandlerMatch.getHandler();
            try {
                handlerMethod.handle(requestContext);
            }
            catch (ForwardRouteException ex) {
                this.manageForwardRouteException(ex, requestContext, routingResult);
                return;
            }
            catch (RedirectException ex) {
                this.manageRedirectException(ex, requestContext, routingResult);
                break;
            }
            catch (SkipRemainingHandlersException ex) {
                break;
            }
        }
        if (!requestContext.response().isClosed()) {
            requestContext.response().end();
        }
    }

    protected void manageRedirectException(RedirectException ex, R context, IRoutingResult<R> routingResult) {
        if (!context.response().isHeadersSent()) {
            context.response().resetEverything();
        }
        context.response().redirect(ex.getNewUrl(), ex.isRedirectPermanently());
        context.response().flush(true);
    }

    protected void manageForwardRouteException(ForwardRouteException ex, R context, IRoutingResult<R> originalRoutingResult) throws Exception {
        Integer nbrTimeForwarded = context.variables().get(SpincastConstants.RequestScopedVariables.ROUTE_FORWARDED_NBR, Integer.class);
        if (nbrTimeForwarded == null) {
            nbrTimeForwarded = 1;
        } else {
            Integer n = nbrTimeForwarded;
            Integer n2 = nbrTimeForwarded = Integer.valueOf(nbrTimeForwarded + 1);
        }
        if (nbrTimeForwarded > this.getSpincastConfig().getRouteForwardingMaxNumber()) {
            throw new RuntimeException("The maximum number of request forwarding has been reached : " + this.getSpincastConfig().getRouteForwardingMaxNumber() + "." + "This route won't be called : " + ex.getNewRoute());
        }
        context.variables().add(SpincastConstants.RequestScopedVariables.ROUTE_FORWARDED_NBR, nbrTimeForwarded);
        if (ex.isResetResponse()) {
            if (!context.response().isHeadersSent()) {
                context.response().resetEverything();
            } else {
                this.logger.warn("The response headers have already been sent, we can't reset the response...");
            }
        }
        context = this.createForwardedRequestContext(context, ex.getNewRoute());
        IRoutingResult<R> routingResult = this.getRouter().route(context);
        if (routingResult == null) {
            this.logger.warn("A route forwarding was asked but the requested route doesn't have any match : " + ex.getNewRoute());
            throw new NotFoundException(false);
        }
        context.variables().add(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_EXCEPTION_MESSAGE, ex.getMessage());
        this.callRouteHandlers(context, routingResult);
    }

    protected R createForwardedRequestContext(R context, String fullUrlOrRelativePathAndQueryString) {
        try {
            if (fullUrlOrRelativePathAndQueryString == null) {
                fullUrlOrRelativePathAndQueryString = "/";
            } else if ((fullUrlOrRelativePathAndQueryString = fullUrlOrRelativePathAndQueryString.trim()).startsWith("//")) {
                fullUrlOrRelativePathAndQueryString = fullUrlOrRelativePathAndQueryString.substring(1);
            }
            String newFullUrl = fullUrlOrRelativePathAndQueryString;
            URI uri = new URI(fullUrlOrRelativePathAndQueryString);
            if (!uri.isAbsolute()) {
                if (!fullUrlOrRelativePathAndQueryString.startsWith("/")) {
                    fullUrlOrRelativePathAndQueryString = "/" + fullUrlOrRelativePathAndQueryString;
                }
                String oldFullUrlStr = context.request().getFullUrl();
                URL oldFullUrl = new URL(oldFullUrlStr);
                newFullUrl = oldFullUrl.getProtocol() + "://" + oldFullUrl.getHost() + ":" + oldFullUrl.getPort() + fullUrlOrRelativePathAndQueryString;
            }
            context.variables().add(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_URL, newFullUrl);
            return context;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected Object validateExchange(Object exchange) {
        Objects.requireNonNull(exchange, "The exchange object can't be NULL.");
        return exchange;
    }

    protected IRoutingResult<R> findRouteMatch(R requestContext) {
        return this.getRouter().route(requestContext);
    }

    protected void defaultExceptionHandling(Object exchange, Throwable ex) throws Throwable {
        if (ex instanceof IPublicException) {
            this.defaultPublicExceptionHandling(exchange, (IPublicException)((Object)ex));
        } else {
            this.defaultPrivateExceptionHandling(exchange, ex);
        }
    }

    protected void defaultPublicExceptionHandling(Object exchange, IPublicException publicException) throws Throwable {
        if (this.getServer().isResponseHeadersSent(exchange)) {
            this.logger.info("Can't sent proper public error response, headers are already sent :\n" + SpincastStatics.getStackTrace((Throwable)((Object)publicException)));
            return;
        }
        String errorMessage = ((Throwable)((Object)publicException)).getMessage();
        if (this.getSpincastConfig().isDebugEnabled()) {
            errorMessage = errorMessage + "\n\nDebug info :\n\n" + SpincastStatics.getStackTrace((Throwable)((Object)publicException));
        }
        this.sendErrorUsingBestMatchContentType(exchange, errorMessage, publicException.getStatusCode());
    }

    protected void defaultPrivateExceptionHandling(Object exchange, Throwable exception) throws Throwable {
        this.logger.error(SpincastStatics.getStackTrace(exception));
        if (this.getServer().isResponseHeadersSent(exchange)) {
            this.logger.info("Can't sent proper error response, headers are already sent :\n" + SpincastStatics.getStackTrace(exception));
            return;
        }
        String errorMessage = this.getSpincastDictionary().exception_default_message();
        if (this.getSpincastConfig().isDebugEnabled()) {
            errorMessage = errorMessage + "\n\nDebug info :\n\n" + SpincastStatics.getStackTrace(exception);
        }
        int statusCode = 500;
        if (exception instanceof ICustomStatusCodeException) {
            statusCode = ((ICustomStatusCodeException)((Object)exception)).getStatusCode();
        }
        this.sendErrorUsingBestMatchContentType(exchange, errorMessage, statusCode);
    }

    protected void sendErrorUsingBestMatchContentType(Object exchange, String errorMessage, Integer statusCode) throws Throwable {
        ContentTypeDefaults type;
        if (statusCode == null) {
            statusCode = 500;
        }
        if ((type = this.getResponseContentTypeToUse(exchange)) == ContentTypeDefaults.JSON) {
            errorMessage = this.getInternalErrorJsonContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset()));
        } else if (type == ContentTypeDefaults.XML) {
            errorMessage = this.getInternalErrorXmlContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.XML.getMainVariationWithUtf8Charset()));
        } else if (type == ContentTypeDefaults.HTML) {
            errorMessage = this.getInternalErrorHtmlContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset()));
        } else if (type == ContentTypeDefaults.TEXT) {
            errorMessage = this.getInternalErrorTextContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset()));
        } else {
            throw new RuntimeException("Not implemented : " + (Object)((Object)type));
        }
        byte[] errorMessageBytes = errorMessage.getBytes(this.getDefaultExceptionHandlingCharset());
        this.getServer().setResponseStatusCode(exchange, statusCode);
        this.getServer().setResponseHeader(exchange, "Content-Length", Arrays.asList("" + errorMessageBytes.length));
        this.getServer().flushBytes(exchange, errorMessageBytes, true);
    }

    protected String getDefaultExceptionHandlingCharset() {
        return "UTF-8";
    }

    protected String getInternalErrorJsonContent(String errorMessage) {
        IJsonObject jsonObject = this.getJsonManager().create();
        jsonObject.put("error", errorMessage);
        return jsonObject.toJsonString();
    }

    protected String getInternalErrorXmlContent(String errorMessage) {
        IJsonObject jsonObject = this.getJsonManager().create();
        jsonObject.put("error", errorMessage);
        return this.getXmlManager().toXml(jsonObject);
    }

    protected String getInternalErrorHtmlContent(String errorMessage) {
        return "<pre>" + errorMessage + "</pre>";
    }

    protected String getInternalErrorTextContent(String errorMessage) {
        return errorMessage;
    }

    protected ContentTypeDefaults getResponseContentTypeToUse(Object exchange) {
        try {
            return this.getServer().getContentTypeBestMatch(exchange);
        }
        catch (Exception ex) {
            return ContentTypeDefaults.TEXT;
        }
    }

    protected void lastResortExceptionHandling(Throwable originalException, Throwable defaultHandlingException) {
        try {
            this.logger.error("Error while trying to use the default exception handling : " + defaultHandlingException.getMessage() + ".\n" + "The original exception was : " + SpincastStatics.getStackTrace(originalException));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new RuntimeException("An error occured.");
    }
}

