/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.pebble;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.cache.BaseTagCacheKey;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.loader.StringLoader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.templating.ITemplatingEngine;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.pebble.ISpincastPebbleTemplatingEngineConfig;

public class SpincastPebbleTemplatingEngine
implements ITemplatingEngine {
    private final ISpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig;
    private final ISpincastConfig spincastConfig;
    private PebbleEngine pebbleEngineString;
    private PebbleEngine pebbleEngineTemplateClasspath;
    private PebbleEngine pebbleEngineTemplateFileSystem;

    @Inject
    public SpincastPebbleTemplatingEngine(ISpincastConfig spincastConfig, ISpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig) {
        this.spincastConfig = spincastConfig;
        this.spincastPebbleTemplatingEngineConfig = spincastPebbleTemplatingEngineConfig;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected ISpincastPebbleTemplatingEngineConfig getSpincastPebbleTemplatingEngineConfig() {
        return this.spincastPebbleTemplatingEngineConfig;
    }

    protected PebbleEngine getPebbleEngineString() {
        if (this.pebbleEngineString == null) {
            PebbleEngine.Builder builder = new PebbleEngine.Builder().loader(new StringLoader());
            this.addCommonLoaderFeatures(builder);
            this.pebbleEngineString = builder.build();
        }
        return this.pebbleEngineString;
    }

    protected PebbleEngine getPebbleEngineTemplateClasspath() {
        if (this.pebbleEngineTemplateClasspath == null) {
            PebbleEngine.Builder builder = new PebbleEngine.Builder().loader(this.getClasspathTemplateLoader());
            this.addCommonLoaderFeatures(builder);
            this.pebbleEngineTemplateClasspath = builder.build();
        }
        return this.pebbleEngineTemplateClasspath;
    }

    protected PebbleEngine getPebbleEngineTemplateFileSystem() {
        if (this.pebbleEngineTemplateFileSystem == null) {
            PebbleEngine.Builder builder = new PebbleEngine.Builder().loader(this.getFileSystemTemplateLoader());
            this.addCommonLoaderFeatures(builder);
            this.pebbleEngineTemplateFileSystem = builder.build();
        }
        return this.pebbleEngineTemplateFileSystem;
    }

    protected void addCommonLoaderFeatures(PebbleEngine.Builder builder) {
        builder.strictVariables(this.getSpincastPebbleTemplatingEngineConfig().isStrictVariablesEnabled());
        int templateCacheItemNbr = this.getSpincastPebbleTemplatingEngineConfig().getTemplateCacheItemNbr();
        if (templateCacheItemNbr < 0) {
            templateCacheItemNbr = 0;
        }
        Cache<Object, PebbleTemplate> cache = CacheBuilder.newBuilder().maximumSize(templateCacheItemNbr).build();
        builder.templateCache(cache);
        int tagCacheItemNbr = this.getSpincastPebbleTemplatingEngineConfig().getTagCacheTypeItemNbr();
        if (tagCacheItemNbr < 0) {
            tagCacheItemNbr = 0;
        }
        Cache<BaseTagCacheKey, Object> tagCache = CacheBuilder.newBuilder().maximumSize(templateCacheItemNbr).build();
        builder.tagCache(tagCache);
        Extension extension = this.getSpincastPebbleTemplatingEngineConfig().getExtension();
        if (extension != null) {
            builder.extension(extension);
        }
    }

    protected Loader<String> getClasspathTemplateLoader() {
        ClasspathLoader classpathLoader = new ClasspathLoader(SpincastPebbleTemplatingEngine.class.getClassLoader());
        return classpathLoader;
    }

    protected Loader<String> getFileSystemTemplateLoader() {
        FileLoader fileSystemLoader = new FileLoader();
        return fileSystemLoader;
    }

    @Override
    public String evaluate(String content, Map<String, Object> params) {
        return this.evaluate(content, params, null);
    }

    @Override
    public String evaluate(String content, Map<String, Object> params, Locale locale) {
        return this.parse(content, params, false, false, locale);
    }

    @Override
    public String evaluate(String content, IJsonObject jsonObject) {
        return this.evaluate(content, jsonObject.getUnderlyingMap(), null);
    }

    @Override
    public String evaluate(String content, IJsonObject jsonObject, Locale locale) {
        return this.evaluate(content, jsonObject.getUnderlyingMap(), locale);
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params) {
        return this.fromTemplate(templatePath, params, null);
    }

    @Override
    public String fromTemplate(String templatePath, IJsonObject jsonObject) {
        return this.fromTemplate(templatePath, jsonObject.getUnderlyingMap(), null);
    }

    @Override
    public String fromTemplate(String templatePath, IJsonObject jsonObject, Locale locale) {
        return this.fromTemplate(templatePath, jsonObject.getUnderlyingMap(), locale);
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params, Locale locale) {
        return this.parse(templatePath, params, true, true, locale);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params) {
        return this.parse(templatePath, params, true, isClasspathPath, null);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params, Locale locale) {
        return this.parse(templatePath, params, true, isClasspathPath, locale);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, IJsonObject jsonObject) {
        return this.parse(templatePath, jsonObject.getUnderlyingMap(), true, isClasspathPath, null);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, IJsonObject jsonObject, Locale locale) {
        return this.parse(templatePath, jsonObject.getUnderlyingMap(), true, isClasspathPath, locale);
    }

    protected String parse(String htmlOrPath, Map<String, Object> params, boolean isTemplate, boolean isClasspathPath, Locale locale) {
        try {
            PebbleEngine pebbleEngine;
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            if (locale == null) {
                locale = this.getSpincastConfig().getDefaultLocale();
            }
            if (isTemplate) {
                if (isClasspathPath) {
                    pebbleEngine = this.getPebbleEngineTemplateClasspath();
                    if (htmlOrPath != null && htmlOrPath.startsWith("/")) {
                        htmlOrPath = htmlOrPath.substring(1);
                    }
                } else {
                    pebbleEngine = this.getPebbleEngineTemplateFileSystem();
                }
            } else {
                pebbleEngine = this.getPebbleEngineString();
            }
            PebbleTemplate template = pebbleEngine.getTemplate(htmlOrPath);
            StringWriter writer = new StringWriter();
            template.evaluate(writer, params, locale);
            String result = ((Object)writer).toString();
            return result;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public String createPlaceholder(String variable) {
        return "{{" + variable + "}}";
    }
}

