/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.request;

import com.google.inject.Inject;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.exchange.IRequestRequestContextAddon;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.IETag;
import org.spincast.core.routing.IETagFactory;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.IXmlManager;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.NameValuePair;
import org.spincast.shaded.org.apache.http.client.utils.DateUtils;
import org.spincast.shaded.org.apache.http.client.utils.URLEncodedUtils;

public class SpincastRequestRequestContextAddon<R extends IRequestContext<?>>
implements IRequestRequestContextAddon<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastRequestRequestContextAddon.class);
    private String fullUrlOriginalWithCacheBustersNonDecoded = null;
    private String fullUrlOriginalNoCacheBustersNonDecoded = null;
    private String fullUrlProxiedWithCacheBustersNonDecoded = null;
    private String fullUrlProxiedNoCacheBustersNonDecoded = null;
    private String fullUrlWithCacheBustersNonDecoded = null;
    private String fullUrlWithCacheBustersDecoded = null;
    private String fullUrlNoCacheBustersDecoded = null;
    private String requestPathNoCacheBusters = null;
    private String requestPathWithCacheBusters = null;
    private String queryStringNonDecoded = "";
    private String queryStringDecoded = "";
    private List<IETag> ifMatchETags = null;
    private Object ifMatchETagsLock = new Object();
    private List<IETag> ifNoneMatchETags = null;
    private Object ifNoneMatchETagsLock = new Object();
    private Date ifModifiedSinceDate = null;
    private Object ifModifiedSinceDateLock = new Object();
    private Date ifUnmodifiedSinceDate = null;
    private Object ifUnmodifiedSinceDateLock = new Object();
    private Map<String, List<String>> queryStringParams;
    private Map<String, List<String>> formDatas;
    private Map<String, List<File>> uploadedFiles;
    private Map<String, List<String>> headers;
    private final R requestContext;
    private final IServer server;
    private final IJsonManager jsonManager;
    private final IXmlManager xmlManager;
    private final ISpincastUtils spincastUtils;
    private final ISpincastConfig spincastConfig;
    private final IETagFactory etagFactory;

    @Inject
    public SpincastRequestRequestContextAddon(R requestContext, IServer server, IJsonManager jsonManager, IXmlManager xmlManager, ISpincastUtils spincastUtils, ISpincastConfig spincastConfig, IETagFactory etagFactory) {
        this.requestContext = requestContext;
        this.server = server;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.spincastUtils = spincastUtils;
        this.spincastConfig = spincastConfig;
        this.etagFactory = etagFactory;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected IJsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected IXmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected IETagFactory getEtagFactory() {
        return this.etagFactory;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.getServer().getHttpMethod(this.getExchange());
    }

    @Override
    public ContentTypeDefaults getContentTypeBestMatch() {
        return this.getServer().getContentTypeBestMatch(this.getExchange());
    }

    @Override
    public boolean isJsonShouldBeReturn() {
        return ContentTypeDefaults.JSON == this.getContentTypeBestMatch();
    }

    @Override
    public boolean isHTMLShouldBeReturn() {
        return ContentTypeDefaults.HTML == this.getContentTypeBestMatch();
    }

    @Override
    public boolean isXMLShouldBeReturn() {
        return ContentTypeDefaults.XML == this.getContentTypeBestMatch();
    }

    @Override
    public boolean isPlainTextShouldBeReturn() {
        return ContentTypeDefaults.TEXT == this.getContentTypeBestMatch();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            Map<String, List<String>> headersServer = this.getServer().getRequestHeaders(this.getExchange());
            Map<String, List<String>> headersFinal = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (headersServer == null) {
                headersServer = Collections.emptyMap();
            } else {
                for (Map.Entry<String, List<String>> entry : headersServer.entrySet()) {
                    if (entry.getValue() == null) {
                        headersFinal.put(entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    headersFinal.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
                }
                headersFinal = Collections.unmodifiableMap(headersFinal);
            }
            this.headers = headersFinal;
        }
        return this.headers;
    }

    @Override
    public List<String> getHeader(String name) {
        if (StringUtils.isBlank(name)) {
            return new LinkedList<String>();
        }
        List<String> values = this.getHeaders().get(name);
        if (values == null) {
            values = new LinkedList<String>();
        }
        return values;
    }

    @Override
    public String getHeaderFirst(String name) {
        List<String> values = this.getHeader(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    protected String getFullUrlOriginalNoCacheBustersNonDecoded() {
        if (this.fullUrlOriginalNoCacheBustersNonDecoded == null) {
            this.fullUrlOriginalNoCacheBustersNonDecoded = this.getServer().getFullUrlOriginal(this.getExchange(), false);
        }
        return this.fullUrlOriginalNoCacheBustersNonDecoded;
    }

    protected String getFullUrlOriginalWithCacheBustersNonDecoded() {
        if (this.fullUrlOriginalWithCacheBustersNonDecoded == null) {
            this.fullUrlOriginalWithCacheBustersNonDecoded = this.getServer().getFullUrlOriginal(this.getExchange(), true);
        }
        return this.fullUrlOriginalWithCacheBustersNonDecoded;
    }

    protected String getFullUrlProxiedNoCacheBustersNonDecoded() {
        if (this.fullUrlProxiedNoCacheBustersNonDecoded == null) {
            this.fullUrlProxiedNoCacheBustersNonDecoded = this.getServer().getFullUrlProxied(this.getExchange(), false);
        }
        return this.fullUrlProxiedNoCacheBustersNonDecoded;
    }

    protected String getFullUrlProxiedWithCacheBustersNonDecoded() {
        if (this.fullUrlProxiedWithCacheBustersNonDecoded == null) {
            this.fullUrlProxiedWithCacheBustersNonDecoded = this.getServer().getFullUrlProxied(this.getExchange(), true);
        }
        return this.fullUrlProxiedWithCacheBustersNonDecoded;
    }

    @Override
    public String getFullUrlOriginal() {
        return this.getFullUrlOriginal(false);
    }

    @Override
    public String getFullUrlOriginal(boolean keepCacheBusters) {
        if (keepCacheBusters) {
            return this.getFullUrlOriginalWithCacheBustersNonDecoded();
        }
        return this.getFullUrlOriginalNoCacheBustersNonDecoded();
    }

    @Override
    public String getFullUrlProxied() {
        return this.getFullUrlProxied(false);
    }

    @Override
    public String getFullUrlProxied(boolean keepCacheBusters) {
        if (keepCacheBusters) {
            return this.getFullUrlProxiedWithCacheBustersNonDecoded();
        }
        return this.getFullUrlProxiedNoCacheBustersNonDecoded();
    }

    @Override
    public String getFullUrl() {
        return this.getFullUrl(false);
    }

    @Override
    public String getFullUrl(boolean keepCacheBusters) {
        this.validateFullUrlInfoCache();
        if (keepCacheBusters) {
            return this.fullUrlWithCacheBustersDecoded;
        }
        return this.fullUrlNoCacheBustersDecoded;
    }

    protected void validateFullUrlInfoCache() {
        try {
            String forwardUrl = this.getRequestContext().variables().getAsString(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_URL);
            String urlToUse = forwardUrl != null ? forwardUrl : this.getFullUrlOriginalWithCacheBustersNonDecoded();
            if (this.fullUrlWithCacheBustersNonDecoded != null && this.fullUrlWithCacheBustersNonDecoded.equals(urlToUse)) {
                return;
            }
            this.fullUrlWithCacheBustersNonDecoded = urlToUse;
            this.fullUrlWithCacheBustersDecoded = URLDecoder.decode(urlToUse, "UTF-8");
            this.fullUrlNoCacheBustersDecoded = this.getSpincastUtils().removeCacheBusterCodes(this.fullUrlWithCacheBustersDecoded);
            this.parseUrl();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void parseUrl() {
        this.parseRequestPath();
        this.parseQueryString();
        this.parseQueryStringParams();
    }

    protected void parseRequestPath() {
        try {
            URL url = new URL(this.fullUrlWithCacheBustersDecoded);
            this.requestPathWithCacheBusters = url.getPath();
            url = new URL(this.fullUrlNoCacheBustersDecoded);
            this.requestPathNoCacheBusters = url.getPath();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void parseQueryString() {
        try {
            URL url = new URL(this.fullUrlWithCacheBustersNonDecoded);
            String qs = url.getQuery();
            if (qs == null) {
                qs = "";
            }
            this.queryStringNonDecoded = qs;
            this.queryStringDecoded = URLDecoder.decode(qs, "UTF-8");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    public void parseQueryStringParams() {
        try {
            List<NameValuePair> params;
            HashMap<String, ArrayList<String>> paramsFinal = new HashMap<String, ArrayList<String>>();
            String qs = this.queryStringNonDecoded;
            if (qs == null) {
                this.parseQueryString();
                qs = this.queryStringNonDecoded;
            }
            if ((params = URLEncodedUtils.parse(qs, Charset.forName("UTF-8"))) != null) {
                for (NameValuePair nameValuePair : params) {
                    String name = nameValuePair.getName();
                    ArrayList<String> values = (ArrayList<String>)paramsFinal.get(name);
                    if (values == null) {
                        values = new ArrayList<String>();
                        paramsFinal.put(name, values);
                    }
                    values.add(nameValuePair.getValue());
                }
            }
            HashMap mapWithInmutableLists = new HashMap();
            for (Map.Entry entry : paramsFinal.entrySet()) {
                mapWithInmutableLists.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
            }
            this.queryStringParams = Collections.unmodifiableMap(mapWithInmutableLists);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public String getRequestPath() {
        return this.getRequestPath(false);
    }

    @Override
    public String getRequestPath(boolean keepCacheBusters) {
        this.validateFullUrlInfoCache();
        if (keepCacheBusters) {
            return this.requestPathWithCacheBusters;
        }
        return this.requestPathNoCacheBusters;
    }

    @Override
    public String getQueryString(boolean withQuestionMark) {
        this.validateFullUrlInfoCache();
        if (StringUtils.isBlank(this.queryStringDecoded)) {
            return "";
        }
        return (withQuestionMark ? "?" : "") + this.queryStringDecoded;
    }

    @Override
    public Map<String, List<String>> getQueryStringParams() {
        this.validateFullUrlInfoCache();
        return this.queryStringParams;
    }

    @Override
    public List<String> getQueryStringParam(String name) {
        List<String> values = this.getQueryStringParams().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    @Override
    public String getQueryStringParamFirst(String name) {
        List<String> values = this.getQueryStringParam(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Map<String, String> getPathParams() {
        Map<String, String> pathParams = this.getRequestContext().routing().getCurrentRouteHandlerMatch().getPathParams();
        pathParams = pathParams == null ? Collections.emptyMap() : Collections.unmodifiableMap(pathParams);
        return pathParams;
    }

    @Override
    public String getPathParam(String name) {
        return this.getPathParams().get(name);
    }

    @Override
    public InputStream getBodyAsInputStream() {
        return this.getServer().getRawInputStream(this.getExchange());
    }

    @Override
    public String getBodyAsString() {
        return this.getBodyAsString("UTF-8");
    }

    @Override
    public String getBodyAsString(String encoding) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return "";
            }
            return IOUtils.toString(inputStream, encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public byte[] getBodyAsByteArray() {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return new byte[0];
            }
            return IOUtils.toByteArray(inputStream);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public IJsonObject getJsonBodyAsJsonObject() {
        IJsonObject obj = this.getJsonBody(IJsonObject.class);
        return obj;
    }

    @Override
    public Map<String, Object> getJsonBodyAsMap() {
        Map obj = this.getJsonBody(Map.class);
        return obj;
    }

    @Override
    public <T> T getJsonBody(Class<T> clazz) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return null;
            }
            return this.getJsonManager().fromJsonInputStream(inputStream, clazz);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public IJsonObject getXmlBodyAsJsonObject() {
        IJsonObject obj = this.getXmlBody(IJsonObject.class);
        return obj;
    }

    @Override
    public Map<String, Object> getXmlBodyAsMap() {
        Map obj = this.getXmlBody(Map.class);
        return obj;
    }

    @Override
    public <T> T getXmlBody(Class<T> clazz) {
        try {
            InputStream inputStream = this.getBodyAsInputStream();
            if (inputStream == null) {
                return null;
            }
            return this.getXmlManager().fromXmlInputStream(inputStream, clazz);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public Map<String, List<String>> getFormDatas() {
        if (this.formDatas == null) {
            Map<String, List<String>> formDatasServer = this.getServer().getFormDatas(this.getExchange());
            Map<String, List<String>> formDatasFinal = new HashMap<String, List<String>>();
            if (formDatasServer == null) {
                formDatasServer = Collections.emptyMap();
            } else {
                for (Map.Entry<String, List<String>> entry : formDatasServer.entrySet()) {
                    if (entry.getValue() == null) {
                        formDatasFinal.put(entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    formDatasFinal.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
                }
                formDatasFinal = Collections.unmodifiableMap(formDatasFinal);
            }
            this.formDatas = formDatasFinal;
        }
        return this.formDatas;
    }

    @Override
    public List<String> getFormData(String name) {
        List<String> values = this.getFormDatas().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    @Override
    public String getFormDataFirst(String name) {
        List<String> values = this.getFormData(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Map<String, List<File>> getUploadedFiles() {
        if (this.uploadedFiles == null) {
            Map<String, List<File>> uploadedFilesServer = this.getServer().getUploadedFiles(this.getExchange());
            Map<String, List<File>> uploadedFilesFinal = new HashMap<String, List<File>>();
            if (uploadedFilesServer == null) {
                uploadedFilesServer = Collections.emptyMap();
            } else {
                for (Map.Entry<String, List<File>> entry : uploadedFilesServer.entrySet()) {
                    if (entry.getValue() == null) {
                        uploadedFilesFinal.put(entry.getKey(), Collections.emptyList());
                        continue;
                    }
                    uploadedFilesFinal.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
                }
                uploadedFilesFinal = Collections.unmodifiableMap(uploadedFilesFinal);
            }
            this.uploadedFiles = uploadedFilesFinal;
        }
        return this.uploadedFiles;
    }

    @Override
    public List<File> getUploadedFiles(String name) {
        List<File> files = this.getUploadedFiles().get(name);
        if (files == null) {
            files = Collections.emptyList();
        }
        return files;
    }

    @Override
    public File getUploadedFileFirst(String name) {
        List<File> files = this.getUploadedFiles(name);
        if (files.size() > 0) {
            return files.get(0);
        }
        return null;
    }

    @Override
    public Locale getLocaleBestMatch() {
        String header = this.getHeaderFirst("Accept-Language");
        Locale locale = this.getSpincastUtils().getLocaleBestMatchFromAcceptLanguageHeader(header);
        if (locale == null) {
            locale = this.getSpincastConfig().getDefaultLocale();
        }
        return locale;
    }

    @Override
    public String getContentType() {
        String contentType = this.getHeaderFirst("Content-Type");
        return contentType;
    }

    @Override
    public boolean isHttps() {
        return this.getFullUrl().trim().toLowerCase().startsWith("https://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IETag> getEtagsFromIfMatchHeader() {
        if (this.ifMatchETags == null) {
            Object object = this.ifMatchETagsLock;
            synchronized (object) {
                if (this.ifMatchETags == null) {
                    this.ifMatchETags = this.parseETagHeader("If-Match");
                }
            }
        }
        return this.ifMatchETags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IETag> getEtagsFromIfNoneMatchHeader() {
        if (this.ifNoneMatchETags == null) {
            Object object = this.ifNoneMatchETagsLock;
            synchronized (object) {
                if (this.ifNoneMatchETags == null) {
                    this.ifNoneMatchETags = this.parseETagHeader("If-None-Match");
                }
            }
        }
        return this.ifNoneMatchETags;
    }

    protected List<IETag> parseETagHeader(String headerName) {
        ArrayList<IETag> etags = new ArrayList<IETag>();
        List<String> eTagHeaders = this.getHeader(headerName);
        if (eTagHeaders != null) {
            for (String eTagHeader : eTagHeaders) {
                String[] tokens;
                for (String eTagStr : tokens = eTagHeader.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1)) {
                    try {
                        IETag eTag = this.getEtagFactory().deserializeHeaderValue(eTagStr);
                        etags.add(eTag);
                    }
                    catch (Exception ex) {
                        this.logger.info("Invalid " + headerName + " ETag header value received: " + eTagStr);
                    }
                }
            }
        }
        return etags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDateFromIfModifiedSinceHeader() {
        if (this.ifModifiedSinceDate == null) {
            Object object = this.ifModifiedSinceDateLock;
            synchronized (object) {
                if (this.ifModifiedSinceDate == null) {
                    this.ifModifiedSinceDate = this.parseDateHeader("If-Modified-Since");
                }
            }
        }
        return this.ifModifiedSinceDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDateFromIfUnmodifiedSinceHeader() {
        if (this.ifUnmodifiedSinceDate == null) {
            Object object = this.ifUnmodifiedSinceDateLock;
            synchronized (object) {
                if (this.ifUnmodifiedSinceDate == null) {
                    this.ifUnmodifiedSinceDate = this.parseDateHeader("If-Unmodified-Since");
                }
            }
        }
        return this.ifUnmodifiedSinceDate;
    }

    protected Date parseDateHeader(String headerName) {
        String value = this.getHeaderFirst(headerName);
        if (value == null) {
            return null;
        }
        try {
            Date date = DateUtils.parseDate(value);
            return date;
        }
        catch (Exception ex) {
            this.logger.info("Invalid '" + headerName + "' date received: " + value);
            return null;
        }
    }
}

