/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Date;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.undertow.ISpincastResourceHandler;
import org.spincast.shaded.org.apache.commons.lang3.time.DateUtils;

public class SpincastResourceHandler
extends ResourceHandler
implements ISpincastResourceHandler {
    private final IStaticResource<?> staticResource;
    private final ISpincastUtils spincastUtils;
    private HttpHandler next;

    @AssistedInject
    public SpincastResourceHandler(@Assisted ResourceManager resourceManager, @Assisted IStaticResource<?> staticResource, ISpincastUtils spincastUtils) {
        this(resourceManager, staticResource, ResponseCodeHandler.HANDLE_404, spincastUtils);
    }

    @AssistedInject
    public SpincastResourceHandler(@Assisted ResourceManager resourceManager, @Assisted IStaticResource<?> staticResource, @Assisted HttpHandler next, ISpincastUtils spincastUtils) {
        super(resourceManager, next);
        this.next = next;
        this.staticResource = staticResource;
        this.spincastUtils = spincastUtils;
    }

    protected HttpHandler getNext() {
        return this.next;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected IStaticResource<?> getStaticResource() {
        return this.staticResource;
    }

    @Override
    public ResourceHandler setCacheTime(Integer cacheTime) {
        throw new RuntimeException("Use a constructor to specify the cache time.");
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRequestMethod().equals(Methods.GET) || exchange.getRequestMethod().equals(Methods.POST) || exchange.getRequestMethod().equals(Methods.HEAD)) {
            this.addContentTypeHeader(exchange);
            this.addCacheHeaders(exchange);
        }
        super.handleRequest(exchange);
    }

    protected void addContentTypeHeader(HttpServerExchange exchange) {
        try {
            Resource resource = this.getResourceManager().getResource(exchange.getRelativePath());
            if (resource != null && resource.isDirectory()) {
                return;
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
        String resourcePath = null;
        if (this.getStaticResource().getStaticResourceType() == StaticResourceType.FILE || this.getStaticResource().getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH) {
            resourcePath = this.getStaticResource().getResourcePath();
        }
        String responseContentTypeHeader = exchange.getResponseHeaders().getFirst(Headers.CONTENT_TYPE);
        String contentType = this.getSpincastUtils().getMimeTypeFromMultipleSources(responseContentTypeHeader, resourcePath, exchange.getRequestPath());
        if (contentType == null) {
            contentType = ContentTypeDefaults.BINARY.getMainVariation();
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
    }

    protected void addCacheHeaders(HttpServerExchange exchange) {
        if (this.getStaticResource().getCacheConfig() != null) {
            int cacheSeconds = this.getStaticResource().getCacheConfig().getCacheSeconds();
            if (cacheSeconds > 0) {
                String cacheControl = "";
                cacheControl = this.getStaticResource().getCacheConfig().isCachePrivate() ? "private" : "public";
                cacheControl = cacheControl + ", max-age=" + cacheSeconds;
                Integer cacheSecondsCdn = this.getStaticResource().getCacheConfig().getCacheSecondsCdn();
                if (cacheSecondsCdn != null) {
                    if (cacheSecondsCdn < 0) {
                        cacheSecondsCdn = 0;
                    }
                    cacheControl = cacheControl + ", s-maxage=" + cacheSecondsCdn;
                }
                exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, cacheControl);
            }
            Date date = DateUtils.addSeconds(new Date(), cacheSeconds);
            String dateStr = org.spincast.shaded.org.apache.http.client.utils.DateUtils.formatDate(date);
            exchange.getResponseHeaders().put(Headers.EXPIRES, dateStr);
        }
    }
}

