/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.controller;

import com.google.inject.Inject;
import java.util.HashMap;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exceptions.IPublicException;
import org.spincast.core.exceptions.PublicException;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.quickstart.config.IAppConfig;
import org.spincast.quickstart.controller.IAppController;
import org.spincast.quickstart.exchange.IAppRequestContext;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class AppController
implements IAppController {
    private final IAppConfig appConfig;

    @Inject
    public AppController(IAppConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected IAppConfig getAppConfig() {
        return this.appConfig;
    }

    @Override
    public void notFound(IAppRequestContext context) {
        String notFoundMessage = "Page not found";
        String specificNotFoundMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
        if (specificNotFoundMessage != null) {
            notFoundMessage = specificNotFoundMessage;
        }
        if (context.request().isJsonShouldBeReturn()) {
            IJsonObject errorObj = context.json().create();
            errorObj.put("message", notFoundMessage);
            context.response().sendJsonObj(errorObj);
        } else {
            context.response().sendHtmlTemplate("/templates/notFound.html", SpincastStatics.params("notFoundMessage", notFoundMessage));
        }
    }

    @Override
    public void exception(IAppRequestContext context) {
        String errorMessage = "An error occured! Please try again later...";
        Throwable originalException = context.variables().get(SpincastConstants.RequestScopedVariables.EXCEPTION, Throwable.class);
        if (originalException != null && originalException instanceof IPublicException) {
            errorMessage = originalException.getMessage();
        }
        if (context.request().isJsonShouldBeReturn()) {
            IJsonObject errorObj = context.json().create();
            errorObj.put("error", errorMessage);
            context.response().sendJsonObj(errorObj);
        } else {
            context.response().sendHtmlTemplate("/templates/exception.html", SpincastStatics.params("errorMessage", errorMessage));
        }
    }

    @Override
    public void indexPage(IAppRequestContext context) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("appName", this.getAppConfig().getAppName());
        variables.put("serverPort", this.getAppConfig().getHttpServerPort());
        context.response().sendHtmlTemplate("/templates/index.html", variables);
    }

    @Override
    public void sumRoute(IAppRequestContext context) {
        long sum;
        String error;
        block11: {
            int secondInt;
            int firstInt;
            String firstNbr = context.request().getFormDataFirst("first");
            if (StringUtils.isBlank(firstNbr)) {
                throw new PublicException("The 'first' post parameter is required.", 400);
            }
            String secondNbr = context.request().getFormDataFirst("second");
            if (StringUtils.isBlank(secondNbr)) {
                throw new PublicException("The 'second' post parameter is required.", 400);
            }
            error = null;
            sum = 0L;
            try {
                firstInt = Integer.parseInt(firstNbr);
            }
            catch (NumberFormatException ex) {
                error = ex.getMessage();
                break block11;
            }
            try {
                secondInt = Integer.parseInt(secondNbr);
            }
            catch (NumberFormatException ex) {
                error = ex.getMessage();
                break block11;
            }
            sum = (long)firstInt + (long)secondInt;
            if (sum > Integer.MAX_VALUE) {
                error = "The sum overflows the maximum integer value, 2147483647";
            } else if (sum < Integer.MIN_VALUE) {
                error = "The sum overflows the minimum integer value, -2147483648";
            }
        }
        IJsonObject resultObj = context.json().create();
        if (error != null) {
            context.response().setStatusCode(400);
            resultObj.put("error", error);
        } else {
            resultObj.put("result", String.valueOf(sum));
        }
        context.response().sendJsonObj(resultObj);
    }
}

