/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.json;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.IJsonArray;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.json.Immutable;
import org.spincast.core.json.JsonObjectArrayBase;
import org.spincast.core.utils.ISpincastUtils;

public class JsonArray
extends JsonObjectArrayBase
implements IJsonArray {
    protected final Logger logger = LoggerFactory.getLogger(JsonArray.class);
    private final List<Object> elements;
    private final List<Object> initialElements;

    @AssistedInject
    public JsonArray(IJsonManager jsonManager, ISpincastUtils spincastUtils) {
        this(null, jsonManager, spincastUtils);
    }

    @AssistedInject
    public JsonArray(@Assisted @Nullable List<Object> initialElements, IJsonManager jsonManager, ISpincastUtils spincastUtils) {
        super(jsonManager, spincastUtils);
        if (initialElements == null) {
            initialElements = new ArrayList<Object>();
        }
        this.initialElements = initialElements;
        this.elements = new LinkedList<Object>();
    }

    @Inject
    protected void init() {
        this.addInitalElements();
    }

    protected void addInitalElements() {
        if (this.initialElements != null) {
            for (Object element : this.initialElements) {
                this.addConvert(element);
            }
        }
    }

    protected List<Object> getElements() {
        return this.elements;
    }

    protected Object getElement(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.getElements().size() - 1) {
            return null;
        }
        Object valObj = this.getElements().get(index);
        return valObj;
    }

    @Override
    public IJsonArray add(String value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(Integer value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(Long value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(Float value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(Double value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(Boolean value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(BigDecimal value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(byte[] value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray add(Date value) {
        return this.addAsIs(value);
    }

    @Override
    public IJsonArray addConvert(Object value) {
        return this.addConvert(value, false);
    }

    @Override
    public IJsonArray addConvert(Object value, boolean clone) {
        if (value != null) {
            if (value instanceof IJsonObject) {
                if (clone || value instanceof Immutable) {
                    value = this.getJsonManager().cloneJsonObject((IJsonObject)value);
                }
            } else if (value instanceof IJsonArray) {
                if (clone || value instanceof Immutable) {
                    value = this.getJsonManager().cloneJsonArray((IJsonArray)value);
                }
            } else {
                value = this.getJsonManager().convertToNativeType(value);
            }
        }
        this.addAsIs(value);
        return this;
    }

    @Override
    public IJsonArray add(IJsonObject jsonObj) {
        return this.add(jsonObj, false);
    }

    @Override
    public IJsonArray add(IJsonObject jsonObj, boolean clone) {
        if (jsonObj != null && (clone || jsonObj instanceof Immutable)) {
            jsonObj = jsonObj.clone(true);
        }
        this.addAsIs(jsonObj);
        return this;
    }

    @Override
    public IJsonArray add(IJsonArray value) {
        return this.add(value, false);
    }

    @Override
    public IJsonArray add(IJsonArray array, boolean clone) {
        if (array != null && (clone || array instanceof Immutable)) {
            array = array.clone(true);
        }
        return this.addAsIs(array);
    }

    protected IJsonArray addAsIs(Object value) {
        this.getElements().add(value);
        return this;
    }

    @Override
    public IJsonArray remove(int index) {
        if (index < 0 || index > this.getElements().size() - 1) {
            return this;
        }
        this.getElements().remove(index);
        return this;
    }

    @Override
    public IJsonArray clear() {
        this.getElements().clear();
        return this;
    }

    @Override
    public int size() {
        return this.getElements().size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public IJsonArray clone() {
        return this.clone(true);
    }

    @Override
    public IJsonArray clone(boolean mutable) {
        return this.getJsonManager().cloneJsonArray(this, mutable);
    }

    @Override
    public List<String> convertToStringList() {
        List<Object> elements = this.getElements();
        ArrayList<String> stringList = new ArrayList<String>(elements.size());
        for (Object element : elements) {
            if (element == null) {
                stringList.add(null);
                continue;
            }
            stringList.add(element.toString());
        }
        return stringList;
    }

    @Override
    public IJsonObject getJsonObject(int index) {
        return this.getJsonObject(String.valueOf(index));
    }

    @Override
    public IJsonObject getJsonObject(int index, IJsonObject defaultValue) {
        return this.getJsonObject(String.valueOf(index), defaultValue);
    }

    @Override
    public IJsonObject getJsonObjectOrEmpty(int index) {
        return this.getJsonObjectOrEmpty(String.valueOf(index));
    }

    @Override
    public IJsonArray getJsonArray(int index) {
        return this.getJsonArray(String.valueOf(index));
    }

    @Override
    public IJsonArray getJsonArray(int index, IJsonArray defaultValue) {
        return this.getJsonArray(String.valueOf(index), defaultValue);
    }

    @Override
    public IJsonArray getJsonArrayOrEmpty(int index) {
        return this.getJsonArray(String.valueOf(index));
    }

    @Override
    public String getString(int index) {
        return this.getString(String.valueOf(index));
    }

    @Override
    public String getString(int index, String defaultValue) {
        return this.getString(String.valueOf(index), defaultValue);
    }

    @Override
    public Integer getInteger(int index) {
        return this.getInteger(String.valueOf(index));
    }

    @Override
    public Integer getInteger(int index, Integer defaultValue) {
        return this.getInteger(String.valueOf(index), defaultValue);
    }

    @Override
    public Long getLong(int index) {
        return this.getLong(String.valueOf(index));
    }

    @Override
    public Long getLong(int index, Long defaultValue) {
        return this.getLong(String.valueOf(index), defaultValue);
    }

    @Override
    public Double getDouble(int index) {
        return this.getDouble(String.valueOf(index));
    }

    @Override
    public Double getDouble(int index, Double defaultValue) {
        return this.getDouble(String.valueOf(index), defaultValue);
    }

    @Override
    public Float getFloat(int index) {
        return this.getFloat(String.valueOf(index));
    }

    @Override
    public Float getFloat(int index, Float defaultValue) {
        return this.getFloat(String.valueOf(index), defaultValue);
    }

    @Override
    public Boolean getBoolean(int index) {
        return this.getBoolean(String.valueOf(index));
    }

    @Override
    public Boolean getBoolean(int index, Boolean defaultValue) {
        return this.getBoolean(String.valueOf(index), defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return this.getBigDecimal(String.valueOf(index));
    }

    @Override
    public BigDecimal getBigDecimal(int index, BigDecimal defaultValue) {
        return this.getBigDecimal(String.valueOf(index), defaultValue);
    }

    @Override
    public byte[] getBytesFromBase64String(int index) {
        return this.getBytesFromBase64String(String.valueOf(index));
    }

    @Override
    public byte[] getBytesFromBase64String(int index, byte[] defaultValue) {
        return this.getBytesFromBase64String(String.valueOf(index), defaultValue);
    }

    @Override
    public Date getDate(int index) {
        return this.getDate(String.valueOf(index));
    }

    @Override
    public Date getDate(int index, Date defaultValue) {
        return this.getDate(String.valueOf(index), defaultValue);
    }

    @Override
    protected Object getElement(String keyPosition, boolean hasDefaultValue, Object defaultValue) {
        int pos = Integer.parseInt(keyPosition);
        if (pos < 0 || pos > this.getElements().size() - 1) {
            if (hasDefaultValue) {
                return defaultValue;
            }
            return null;
        }
        return this.getElements().get(pos);
    }

    @Override
    public List<Object> convertToPlainList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map<String, Object> element : this) {
            if (element instanceof IJsonObject) {
                element = ((IJsonObject)((Object)element)).convertToPlainMap();
            } else if (element instanceof IJsonArray) {
                element = ((IJsonArray)((Object)element)).convertToPlainList();
            }
            list.add(element);
        }
        return list;
    }
}

